/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.mledger.impl.LedgerMetadataUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.RawMessage;
import org.apache.pulsar.client.api.RawReader;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.RawBatchConverter;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.protocol.Markers;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.compaction.Compactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTwoPhaseCompactor<T>
extends Compactor {
    @VisibleForTesting
    static Runnable injectionAfterSeekInPhaseTwo = () -> {};
    private static final Logger log = LoggerFactory.getLogger(AbstractTwoPhaseCompactor.class);
    protected static final int MAX_OUTSTANDING = 500;
    protected final Duration phaseOneLoopReadTimeout;
    protected final boolean topicCompactionRetainNullKey;

    public AbstractTwoPhaseCompactor(ServiceConfiguration conf, PulsarClient pulsar, BookKeeper bk, ScheduledExecutorService scheduler) {
        super(conf, pulsar, bk, scheduler);
        this.phaseOneLoopReadTimeout = Duration.ofSeconds(conf.getBrokerServiceCompactionPhaseOneLoopTimeInSeconds());
        this.topicCompactionRetainNullKey = conf.isTopicCompactionRetainNullKey();
    }

    protected abstract Map<String, MessageId> toLatestMessageIdForKey(Map<String, T> var1);

    protected abstract boolean compactMessage(String var1, Map<String, T> var2, RawMessage var3, MessageMetadata var4, MessageId var5);

    protected abstract boolean compactBatchMessage(String var1, Map<String, T> var2, RawMessage var3, MessageMetadata var4, MessageId var5);

    @Override
    protected CompletableFuture<Long> doCompaction(RawReader reader, BookKeeper bk) {
        return reader.hasMessageAvailableAsync().thenCompose(available -> {
            if (available.booleanValue()) {
                return this.phaseOne(reader).thenCompose(r -> this.phaseTwo(reader, r.from, r.to, r.lastReadId, this.toLatestMessageIdForKey(r.latestForKey), bk));
            }
            log.info("Skip compaction of the empty topic {}", (Object)reader.getTopic());
            return CompletableFuture.completedFuture(-1L);
        });
    }

    private CompletableFuture<PhaseOneResult> phaseOne(RawReader reader) {
        HashMap latestForKey = new HashMap();
        CompletableFuture<PhaseOneResult> loopPromise = new CompletableFuture<PhaseOneResult>();
        ((CompletableFuture)reader.getLastMessageIdAsync().thenAccept(lastMessageId -> {
            log.info("Commencing phase one of compaction for {}, reading to {}", (Object)reader.getTopic(), lastMessageId);
            MessageIdImpl lastImpl = (MessageIdImpl)lastMessageId;
            MessageIdImpl lastEntryMessageId = new MessageIdImpl(lastImpl.getLedgerId(), lastImpl.getEntryId(), lastImpl.getPartitionIndex());
            this.phaseOneLoop(reader, Optional.empty(), Optional.empty(), (MessageId)lastEntryMessageId, latestForKey, loopPromise);
        })).exceptionally(ex -> {
            loopPromise.completeExceptionally((Throwable)ex);
            return null;
        });
        return loopPromise;
    }

    private void phaseOneLoop(RawReader reader, Optional<MessageId> firstMessageId, Optional<MessageId> toMessageId, MessageId lastMessageId, Map<String, T> latestForKey, CompletableFuture<PhaseOneResult> loopPromise) {
        if (loopPromise.isDone()) {
            return;
        }
        CompletableFuture<RawMessage> future = reader.readNextAsync();
        FutureUtil.addTimeoutHandling(future, (Duration)this.phaseOneLoopReadTimeout, (ScheduledExecutorService)this.scheduler, () -> FutureUtil.createTimeoutException((String)"Timeout", this.getClass(), (String)"phaseOneLoop(...)"));
        ((CompletableFuture)future.thenAcceptAsync(m -> {
            try (RawMessage rawMessage = m;){
                MessageId to;
                MessageId id = m.getMessageId();
                boolean deletedMessage = false;
                this.mxBean.addCompactionReadOp(reader.getTopic(), m.getHeadersAndPayload().readableBytes());
                MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)m.getHeadersAndPayload());
                if (Markers.isServerOnlyMarker((MessageMetadata)metadata)) {
                    this.mxBean.addCompactionRemovedEvent(reader.getTopic());
                    deletedMessage = true;
                } else {
                    deletedMessage = RawBatchConverter.isReadableBatch(metadata) ? this.compactBatchMessage(reader.getTopic(), latestForKey, (RawMessage)m, metadata, id) : this.compactMessage(reader.getTopic(), latestForKey, (RawMessage)m, metadata, id);
                }
                MessageId first = firstMessageId.orElse(deletedMessage ? null : id);
                MessageId messageId = to = deletedMessage ? (MessageId)toMessageId.orElse(null) : id;
                if (id.compareTo((Object)lastMessageId) == 0) {
                    loopPromise.complete(new PhaseOneResult(first == null ? id : first, to == null ? id : to, lastMessageId, latestForKey));
                } else {
                    this.phaseOneLoop(reader, Optional.ofNullable(first), Optional.ofNullable(to), lastMessageId, latestForKey, loopPromise);
                }
            }
        }, (Executor)this.scheduler)).exceptionally(ex -> {
            loopPromise.completeExceptionally((Throwable)ex);
            return null;
        });
    }

    private CompletableFuture<Long> phaseTwo(RawReader reader, MessageId from, MessageId to, MessageId lastReadId, Map<String, MessageId> latestForKey, BookKeeper bk) {
        Map metadata = LedgerMetadataUtils.buildMetadataForCompactedLedger((String)reader.getTopic(), (byte[])to.toByteArray());
        return this.createLedger(bk, metadata).thenCompose(ledger -> {
            log.info("Commencing phase two of compaction for {}, from {} to {}, compacting {} keys to ledger {}", new Object[]{reader.getTopic(), from, to, latestForKey.size(), ledger.getId()});
            return this.phaseTwoSeekThenLoop(reader, from, to, lastReadId, latestForKey, bk, (LedgerHandle)ledger);
        });
    }

    private CompletableFuture<Long> phaseTwoSeekThenLoop(RawReader reader, MessageId from, MessageId to, MessageId lastReadId, Map<String, MessageId> latestForKey, BookKeeper bk, LedgerHandle ledger) {
        CompletableFuture<Long> promise = new CompletableFuture<Long>();
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)reader.seekAsync(from).thenCompose(v -> {
            injectionAfterSeekInPhaseTwo.run();
            Semaphore outstanding = new Semaphore(500);
            CompletableFuture<Void> loopPromise = new CompletableFuture<Void>();
            this.phaseTwoLoop(reader, to, latestForKey, ledger, outstanding, loopPromise, MessageId.earliest);
            return loopPromise;
        })).thenCompose(v -> this.closeLedger(ledger))).thenCompose(v -> reader.acknowledgeCumulativeAsync(lastReadId, Map.of("CompactedTopicLedger", ledger.getId())))).whenComplete((res, exception) -> {
            if (exception != null) {
                this.deleteLedger(bk, ledger).whenComplete((res2, exception2) -> {
                    if (exception2 != null) {
                        log.warn("Cleanup of ledger {} for failed", (Object)ledger, exception2);
                    }
                    promise.completeExceptionally((Throwable)exception);
                });
            } else {
                promise.complete(ledger.getId());
            }
        });
        return promise;
    }

    private void phaseTwoLoop(RawReader reader, MessageId to, Map<String, MessageId> latestForKey, LedgerHandle lh, Semaphore outstanding, CompletableFuture<Void> promise, MessageId lastCompactedMessageId) {
        if (promise.isDone()) {
            return;
        }
        ((CompletableFuture)reader.readNextAsync().thenAcceptAsync(arg_0 -> this.lambda$phaseTwoLoop$17(promise, lastCompactedMessageId, reader, to, latestForKey, lh, outstanding, arg_0), (Executor)this.scheduler)).exceptionally(ex -> {
            promise.completeExceptionally((Throwable)ex);
            return null;
        });
    }

    protected CompletableFuture<LedgerHandle> createLedger(BookKeeper bk, Map<String, byte[]> metadata) {
        CompletableFuture<LedgerHandle> bkf = new CompletableFuture<LedgerHandle>();
        try {
            bk.asyncCreateLedger(this.conf.getManagedLedgerDefaultEnsembleSize(), this.conf.getManagedLedgerDefaultWriteQuorum(), this.conf.getManagedLedgerDefaultAckQuorum(), Compactor.COMPACTED_TOPIC_LEDGER_DIGEST_TYPE, Compactor.COMPACTED_TOPIC_LEDGER_PASSWORD, (rc, ledger, ctx) -> {
                if (rc != 0) {
                    bkf.completeExceptionally(BKException.create((int)rc));
                } else {
                    bkf.complete(ledger);
                }
            }, null, metadata);
        }
        catch (Throwable t) {
            log.error("Encountered unexpected error when creating compaction ledger", t);
            return FutureUtil.failedFuture((Throwable)t);
        }
        return bkf;
    }

    protected CompletableFuture<Void> deleteLedger(BookKeeper bk, LedgerHandle lh) {
        CompletableFuture<Void> bkf = new CompletableFuture<Void>();
        try {
            bk.asyncDeleteLedger(lh.getId(), (rc, ctx) -> {
                if (rc != 0) {
                    bkf.completeExceptionally(BKException.create((int)rc));
                } else {
                    bkf.complete(null);
                }
            }, null);
        }
        catch (Throwable t) {
            return FutureUtil.failedFuture((Throwable)t);
        }
        return bkf;
    }

    protected CompletableFuture<Void> closeLedger(LedgerHandle lh) {
        CompletableFuture<Void> bkf = new CompletableFuture<Void>();
        try {
            lh.asyncClose((rc, ledger, ctx) -> {
                if (rc != 0) {
                    bkf.completeExceptionally(BKException.create((int)rc));
                } else {
                    bkf.complete(null);
                }
            }, null);
        }
        catch (Throwable t) {
            return FutureUtil.failedFuture((Throwable)t);
        }
        return bkf;
    }

    private CompletableFuture<Void> addToCompactedLedger(LedgerHandle lh, RawMessage m, String topic) {
        CompletableFuture<Void> bkf = new CompletableFuture<Void>();
        ByteBuf serialized = m.serialize();
        try {
            this.mxBean.addCompactionWriteOp(topic, m.getHeadersAndPayload().readableBytes());
            long start = System.nanoTime();
            lh.asyncAddEntry(serialized, (rc, ledger, eid, ctx) -> {
                this.mxBean.addCompactionLatencyOp(topic, System.nanoTime() - start, TimeUnit.NANOSECONDS);
                if (rc != 0) {
                    bkf.completeExceptionally(BKException.create((int)rc));
                } else {
                    bkf.complete(null);
                }
            }, null);
        }
        catch (Throwable t) {
            return FutureUtil.failedFuture((Throwable)t);
        }
        return bkf;
    }

    protected Pair<String, Integer> extractKeyAndSize(RawMessage m, MessageMetadata msgMetadata) {
        ByteBuf headersAndPayload = m.getHeadersAndPayload();
        if (msgMetadata.hasPartitionKey()) {
            int size = headersAndPayload.readableBytes();
            if (msgMetadata.hasUncompressedSize()) {
                size = msgMetadata.getUncompressedSize();
            }
            return Pair.of((Object)msgMetadata.getPartitionKey(), (Object)size);
        }
        return null;
    }

    protected Optional<RawMessage> rebatchMessage(String topic, RawMessage msg, MessageMetadata metadata, BiPredicate<String, MessageId> filter, boolean retainNullKey) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Rebatching message {} for topic {}", (Object)msg.getMessageId(), (Object)topic);
        }
        return RawBatchConverter.rebatchMessage(msg, metadata, filter, retainNullKey);
    }

    public long getPhaseOneLoopReadTimeoutInSeconds() {
        return this.phaseOneLoopReadTimeout.getSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private /* synthetic */ void lambda$phaseTwoLoop$17(CompletableFuture promise, MessageId lastCompactedMessageId, RawReader reader, MessageId to, Map latestForKey, LedgerHandle lh, Semaphore outstanding, RawMessage m) {
        if (promise.isDone()) {
            m.close();
            return;
        }
        if (m.getMessageId().compareTo((Object)lastCompactedMessageId) <= 0) {
            m.close();
            this.phaseTwoLoop(reader, to, latestForKey, lh, outstanding, promise, lastCompactedMessageId);
            return;
        }
        try {
            id = m.getMessageId();
            messageToAdd /* !! */  = Optional.empty();
            this.mxBean.addCompactionReadOp(reader.getTopic(), m.getHeadersAndPayload().readableBytes());
            metadata = Commands.parseMessageMetadata((ByteBuf)m.getHeadersAndPayload());
            if (Markers.isServerOnlyMarker((MessageMetadata)metadata)) {
                messageToAdd /* !! */  = Optional.empty();
            } else if (RawBatchConverter.isReadableBatch(metadata)) {
                try {
                    messageToAdd /* !! */  = this.rebatchMessage(reader.getTopic(), m, metadata, (BiPredicate<String, MessageId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Z, lambda$phaseTwoLoop$14(java.util.Map java.lang.String org.apache.pulsar.client.api.MessageId ), (Ljava/lang/String;Lorg/apache/pulsar/client/api/MessageId;)Z)((Map)latestForKey), this.topicCompactionRetainNullKey);
                }
                catch (IOException ioe) {
                    AbstractTwoPhaseCompactor.log.info("Error decoding batch for message {}. Whole batch will be included in output", (Object)id, (Object)ioe);
                    messageToAdd /* !! */  = Optional.of(m);
                }
            } else {
                keyAndSize = this.extractKeyAndSize(m, metadata);
                if (keyAndSize == null) {
                    messageToAdd /* !! */  = this.topicCompactionRetainNullKey != false ? Optional.of(m) : Optional.empty();
                } else {
                    msg = (MessageId)latestForKey.get(keyAndSize.getLeft());
                    if (msg != null && msg.equals((Object)id)) {
                        if ((Integer)keyAndSize.getRight() <= 0) {
                            promise.completeExceptionally(new IllegalArgumentException("Compaction phase found empty record from sorted key-map"));
                        }
                        messageToAdd /* !! */  = Optional.of(m);
                    }
                }
            }
            if (messageToAdd /* !! */ .isPresent()) {
                message = (RawMessage)messageToAdd /* !! */ .get();
                try {
                    outstanding.acquire();
                    addFuture = this.addToCompactedLedger(lh, message, reader.getTopic()).whenComplete((BiConsumer)(BiConsumer<Void, Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$phaseTwoLoop$15(java.util.concurrent.Semaphore java.util.concurrent.CompletableFuture java.lang.Void java.lang.Throwable ), (Ljava/lang/Void;Ljava/lang/Throwable;)V)((Semaphore)outstanding, (CompletableFuture)promise));
                    if (!to.equals((Object)id)) ** GOTO lbl64
                    outstanding.acquire(500);
                    addFuture.whenComplete((BiConsumer<Void, Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$phaseTwoLoop$16(java.util.concurrent.CompletableFuture java.lang.Void java.lang.Throwable ), (Ljava/lang/Void;Ljava/lang/Throwable;)V)((CompletableFuture)promise));
                    return;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    promise.completeExceptionally(ie);
                }
                finally {
                    if (message != m) {
                        message.close();
                    }
                }
            } else if (to.equals((Object)id)) {
                try {
                    outstanding.acquire(500);
                    promise.complete(null);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    promise.completeExceptionally(e);
                }
                return;
            }
lbl64:
            // 4 sources

            this.phaseTwoLoop(reader, to, latestForKey, lh, outstanding, promise, m.getMessageId());
        }
        finally {
            m.close();
        }
    }

    private static /* synthetic */ void lambda$phaseTwoLoop$16(CompletableFuture promise, Void res, Throwable exception2) {
        if (exception2 == null) {
            promise.complete(null);
        }
    }

    private static /* synthetic */ void lambda$phaseTwoLoop$15(Semaphore outstanding, CompletableFuture promise, Void res, Throwable exception2) {
        outstanding.release();
        if (exception2 != null) {
            promise.completeExceptionally(exception2);
        }
    }

    private static /* synthetic */ boolean lambda$phaseTwoLoop$14(Map latestForKey, String key, MessageId subid) {
        return subid.equals(latestForKey.get(key));
    }

    protected static class PhaseOneResult<T> {
        final MessageId from;
        final MessageId to;
        final MessageId lastReadId;
        final Map<String, T> latestForKey;

        PhaseOneResult(MessageId from, MessageId to, MessageId lastReadId, Map<String, T> latestForKey) {
            this.from = from;
            this.to = to;
            this.lastReadId = lastReadId;
            this.latestForKey = latestForKey;
        }
    }
}

