/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.Objects;
import lombok.Generated;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.opentelemetry.OpenTelemetryAttributes;

public class TopicAttributes {
    protected final Attributes commonAttributes;

    public TopicAttributes(TopicName topicName) {
        Objects.requireNonNull(topicName);
        AttributesBuilder builder = Attributes.builder().put(OpenTelemetryAttributes.PULSAR_DOMAIN, (Object)topicName.getDomain().toString()).put(OpenTelemetryAttributes.PULSAR_TENANT, (Object)topicName.getTenant()).put(OpenTelemetryAttributes.PULSAR_NAMESPACE, (Object)topicName.getNamespace()).put(OpenTelemetryAttributes.PULSAR_TOPIC, (Object)topicName.getPartitionedTopicName());
        if (topicName.isPartitioned()) {
            builder.put(OpenTelemetryAttributes.PULSAR_PARTITION_INDEX, topicName.getPartitionIndex());
        }
        this.commonAttributes = builder.build();
    }

    @Generated
    public Attributes getCommonAttributes() {
        return this.commonAttributes;
    }
}

