/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.naming.AuthenticationException;
import javax.net.ssl.SSLSession;
import javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.broker.authentication.AuthenticationDataCommand;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.common.api.AuthData;

public class OneStageAuthenticationState
implements AuthenticationState {
    private AuthenticationDataSource authenticationDataSource;
    private final SocketAddress remoteAddress;
    private final SSLSession sslSession;
    private final AuthenticationProvider provider;
    private volatile String authRole;

    public OneStageAuthenticationState(AuthData authData, SocketAddress remoteAddress, SSLSession sslSession, AuthenticationProvider provider) {
        this.provider = provider;
        this.remoteAddress = remoteAddress;
        this.sslSession = sslSession;
    }

    public OneStageAuthenticationState(HttpServletRequest request, AuthenticationProvider provider) {
        this.authenticationDataSource = new AuthenticationDataHttps(request);
        this.provider = provider;
        this.remoteAddress = null;
        this.sslSession = null;
    }

    @Override
    public String getAuthRole() throws AuthenticationException {
        if (this.authRole == null) {
            throw new AuthenticationException("Must authenticate before calling getAuthRole");
        }
        return this.authRole;
    }

    @Override
    public AuthenticationDataSource getAuthDataSource() {
        return this.authenticationDataSource;
    }

    @Override
    public CompletableFuture<AuthData> authenticateAsync(AuthData authData) {
        if (this.authRole != null) {
            return CompletableFuture.completedFuture(null);
        }
        this.authenticationDataSource = new AuthenticationDataCommand(new String(authData.getBytes(), StandardCharsets.UTF_8), this.remoteAddress, this.sslSession);
        return this.provider.authenticateAsync(this.authenticationDataSource).thenApply(role -> {
            this.authRole = role;
            return null;
        });
    }

    @Override
    @Deprecated(since="3.0.0")
    public AuthData authenticate(AuthData authData) throws AuthenticationException {
        try {
            return this.authenticateAsync(authData).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated(since="3.0.0")
    public boolean isComplete() {
        return this.authRole != null;
    }
}

