/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.socket.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.Base64;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Recorder;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxTextMessageSize=65536)
public class SimpleTestProducerSocket {
    public static Recorder recorder = new Recorder(TimeUnit.SECONDS.toMillis(120000L), 5);
    private final CountDownLatch closeLatch;
    private volatile Session session;
    private ConcurrentHashMap<String, Long> startTimeMap = new ConcurrentHashMap();
    private static final String CONTEXT = "context";
    private static final Logger log = LoggerFactory.getLogger(SimpleTestProducerSocket.class);

    public SimpleTestProducerSocket() {
        this.closeLatch = new CountDownLatch(2);
    }

    public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
        return this.closeLatch.await(duration, unit);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        log.info("Connection closed: {} - {}", (Object)statusCode, (Object)reason);
        this.session.close();
        this.closeLatch.countDown();
    }

    @OnWebSocketConnect
    public void onConnect(Session session) throws InterruptedException, IOException, JsonParseException {
        log.info("Got conneceted to the proxy");
        this.session = session;
    }

    @OnWebSocketMessage
    public void onMessage(String msg) throws JsonParseException {
        long endTimeNs;
        JsonObject json = (JsonObject)new Gson().fromJson(msg, JsonObject.class);
        long startTime = endTimeNs = System.nanoTime();
        if (this.startTimeMap.get(json.get(CONTEXT).getAsString()) != null) {
            startTime = this.startTimeMap.get(json.get(CONTEXT).getAsString());
        }
        long latencyNs = endTimeNs - startTime;
        recorder.recordValue(TimeUnit.NANOSECONDS.toMicros(latencyNs));
    }

    public RemoteEndpoint getRemote() {
        return this.session.getRemote();
    }

    public Session getSession() {
        return this.session;
    }

    public void sendMsg(String context, byte[] payloadData) throws IOException, JsonParseException, InterruptedException, ExecutionException {
        String message = Base64.getEncoder().encodeToString(payloadData);
        String timeStamp = "{\"payload\": \"" + message + "\",\"context\": \"" + context + "\"}";
        String sampleMsg = ((JsonObject)new Gson().fromJson(timeStamp, JsonObject.class)).toString();
        if (this.session != null && this.session.isOpen() && this.session.getRemote() != null) {
            this.startTimeMap.put(context, System.nanoTime());
            this.session.getRemote().sendStringByFuture(sampleMsg).get();
        } else {
            log.error("Session is already closed");
        }
    }
}

