/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.stats;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.stats.OpStatsLogger;

public class OpStatsListener<T>
implements FutureEventListener<T> {
    private final OpStatsLogger opStatsLogger;
    private final Stopwatch stopwatch;

    public OpStatsListener(OpStatsLogger opStatsLogger, Stopwatch stopwatch) {
        this.opStatsLogger = opStatsLogger;
        this.stopwatch = null == stopwatch ? Stopwatch.createStarted() : stopwatch;
    }

    public OpStatsListener(OpStatsLogger opStatsLogger) {
        this(opStatsLogger, null);
    }

    @Override
    public void onSuccess(T value) {
        this.opStatsLogger.registerSuccessfulEvent(this.stopwatch.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
    }

    @Override
    public void onFailure(Throwable cause) {
        this.opStatsLogger.registerFailedEvent(this.stopwatch.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
    }
}

