/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.future;

import org.apache.pulsar.jetcd.shaded.io.vertx.core.Expectation;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.VertxException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.future.Listener;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.future.Operation;

public class Expect<T>
extends Operation<T>
implements Listener<T> {
    private final Expectation<? super T> expectation;

    public Expect(ContextInternal context, Expectation<? super T> expectation) {
        super(context);
        this.expectation = expectation;
    }

    @Override
    public void onSuccess(T value) {
        Throwable err = null;
        try {
            if (!this.expectation.test(value) && (err = this.expectation.describe(value)) == null) {
                err = new VertxException("Unexpected result: " + value, true);
            }
        }
        catch (Throwable e) {
            err = e;
        }
        if (err != null) {
            this.tryFail(err);
        } else {
            this.tryComplete(value);
        }
    }

    @Override
    public void onFailure(Throwable failure) {
        this.tryFail(failure);
    }
}

