/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.RollingBuffer;

public final class FlattenGraphFilter
extends TokenFilter {
    private final RollingBuffer<InputNode> inputNodes = new RollingBuffer<InputNode>(){

        protected InputNode newInstance() {
            return new InputNode();
        }
    };
    private final RollingBuffer<OutputNode> outputNodes = new RollingBuffer<OutputNode>(){

        protected OutputNode newInstance() {
            return new OutputNode();
        }
    };
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private int inputFrom;
    private int outputFrom;
    private boolean done;
    private int lastOutputFrom;
    private int finalOffset;
    private int finalPosInc;
    private int maxLookaheadUsed;
    private int lastStartOffset;

    public FlattenGraphFilter(TokenStream in) {
        super(in);
    }

    private boolean releaseBufferedToken() {
        while (this.outputFrom < this.outputNodes.getMaxPos()) {
            OutputNode output = (OutputNode)this.outputNodes.get(this.outputFrom);
            if (output.inputNodes.isEmpty()) {
                ++this.outputFrom;
                continue;
            }
            int maxToNode = -1;
            Iterator iterator = output.inputNodes.iterator();
            while (iterator.hasNext()) {
                int inputNodeID = (Integer)iterator.next();
                InputNode inputNode = (InputNode)this.inputNodes.get(inputNodeID);
                assert (inputNode.outputNode == this.outputFrom);
                maxToNode = Math.max(maxToNode, inputNode.maxToNode);
            }
            if (maxToNode <= this.inputFrom || this.done) {
                assert (output.nextOut < output.inputNodes.size()) : "output.nextOut=" + output.nextOut + " vs output.inputNodes.size()=" + OutputNode.access$200(output).size();
                InputNode inputNode = (InputNode)this.inputNodes.get(((Integer)output.inputNodes.get(output.nextOut)).intValue());
                if (this.done && inputNode.tokens.size() == 0 && this.outputFrom >= this.outputNodes.getMaxPos()) {
                    return false;
                }
                if (inputNode.tokens.size() == 0) {
                    assert (inputNode.nextOut == 0);
                    assert (output.nextOut == 0);
                    assert (output.inputNodes.size() == 1) : OutputNode.access$200(output).size();
                    ++this.outputFrom;
                    this.inputNodes.freeBefore(((Integer)output.inputNodes.get(0)).intValue());
                    this.outputNodes.freeBefore(this.outputFrom);
                    continue;
                }
                assert (inputNode.nextOut < inputNode.tokens.size());
                this.restoreState((AttributeSource.State)inputNode.tokens.get(inputNode.nextOut));
                assert (this.outputFrom >= this.lastOutputFrom);
                this.posIncAtt.setPositionIncrement(this.outputFrom - this.lastOutputFrom);
                int toInputNodeID = inputNode.node + this.posLenAtt.getPositionLength();
                InputNode toInputNode = (InputNode)this.inputNodes.get(toInputNodeID);
                assert (toInputNode.outputNode > this.outputFrom);
                this.posLenAtt.setPositionLength(toInputNode.outputNode - this.outputFrom);
                this.lastOutputFrom = this.outputFrom++;
                ++inputNode.nextOut;
                OutputNode outputEndNode = (OutputNode)this.outputNodes.get(toInputNode.outputNode);
                int startOffset = Math.max(this.lastStartOffset, output.startOffset);
                int endOffset = Math.max(startOffset, outputEndNode.endOffset);
                this.offsetAtt.setOffset(startOffset, endOffset);
                this.lastStartOffset = startOffset;
                if (inputNode.nextOut == inputNode.tokens.size()) {
                    ++output.nextOut;
                    if (output.nextOut == output.inputNodes.size()) {
                        this.inputNodes.freeBefore(((Integer)output.inputNodes.get(0)).intValue());
                        this.outputNodes.freeBefore(this.outputFrom);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean incrementToken() throws IOException {
        while (!this.releaseBufferedToken()) {
            if (this.done) {
                return false;
            }
            if (this.input.incrementToken()) {
                int outputEndNode;
                OutputNode outSrc;
                this.inputFrom += this.posIncAtt.getPositionIncrement();
                int startOffset = this.offsetAtt.startOffset();
                int endOffset = this.offsetAtt.endOffset();
                int inputTo = this.inputFrom + this.posLenAtt.getPositionLength();
                InputNode src = (InputNode)this.inputNodes.get(this.inputFrom);
                if (src.node == -1) {
                    assert (src.outputNode == -1);
                    src.node = this.inputFrom;
                    src.outputNode = this.outputNodes.getMaxPos() + 1;
                    outSrc = (OutputNode)this.outputNodes.get(src.outputNode);
                    assert (outSrc.node == -1);
                    outSrc.node = src.outputNode;
                    outSrc.inputNodes.add(this.inputFrom);
                    outSrc.startOffset = startOffset;
                } else {
                    outSrc = (OutputNode)this.outputNodes.get(src.outputNode);
                    if (outSrc.startOffset == -1 || startOffset > outSrc.startOffset) {
                        outSrc.startOffset = Math.max(startOffset, outSrc.startOffset);
                    }
                }
                src.tokens.add(this.captureState());
                src.maxToNode = Math.max(src.maxToNode, inputTo);
                this.maxLookaheadUsed = Math.max(this.maxLookaheadUsed, this.inputNodes.getBufferSize());
                InputNode dest = (InputNode)this.inputNodes.get(inputTo);
                if (dest.node == -1) {
                    dest.node = inputTo;
                }
                if ((outputEndNode = src.outputNode + 1) > dest.outputNode) {
                    if (dest.outputNode != -1) {
                        boolean removed = ((OutputNode)this.outputNodes.get(dest.outputNode)).inputNodes.remove((Object)inputTo);
                        assert (removed);
                    }
                    ((OutputNode)this.outputNodes.get(outputEndNode)).inputNodes.add(inputTo);
                    dest.outputNode = outputEndNode;
                    assert (outputEndNode <= inputTo) : "outputEndNode=" + outputEndNode + " vs inputTo=" + inputTo;
                }
                OutputNode outDest = (OutputNode)this.outputNodes.get(dest.outputNode);
                if (outDest.endOffset != -1 && endOffset >= outDest.endOffset) continue;
                outDest.endOffset = endOffset;
                continue;
            }
            this.input.end();
            this.finalPosInc = this.posIncAtt.getPositionIncrement();
            this.finalOffset = this.offsetAtt.endOffset();
            this.done = true;
        }
        return true;
    }

    public void end() throws IOException {
        if (!this.done) {
            super.end();
        }
        this.clearAttributes();
        if (this.done) {
            this.posIncAtt.setPositionIncrement(this.finalPosInc);
            this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
        } else {
            super.end();
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.inputFrom = -1;
        this.inputNodes.reset();
        InputNode in = (InputNode)this.inputNodes.get(0);
        in.node = 0;
        in.outputNode = 0;
        this.outputNodes.reset();
        OutputNode out = (OutputNode)this.outputNodes.get(0);
        out.node = 0;
        out.inputNodes.add(0);
        out.startOffset = 0;
        this.outputFrom = 0;
        this.lastOutputFrom = -1;
        this.done = false;
        this.finalPosInc = -1;
        this.finalOffset = -1;
        this.lastStartOffset = 0;
        this.maxLookaheadUsed = 0;
    }

    public int getMaxLookaheadUsed() {
        return this.maxLookaheadUsed;
    }

    private static final class OutputNode
    implements RollingBuffer.Resettable {
        private final List<Integer> inputNodes = new ArrayList<Integer>();
        int node = -1;
        int nextOut;
        int startOffset = -1;
        int endOffset = -1;

        private OutputNode() {
        }

        public void reset() {
            this.inputNodes.clear();
            this.node = -1;
            this.nextOut = 0;
            this.startOffset = -1;
            this.endOffset = -1;
        }
    }

    private static final class InputNode
    implements RollingBuffer.Resettable {
        private final List<AttributeSource.State> tokens = new ArrayList<AttributeSource.State>();
        int node = -1;
        int maxToNode = -1;
        int outputNode = -1;
        int nextOut;

        private InputNode() {
        }

        public void reset() {
            this.tokens.clear();
            this.node = -1;
            this.outputNode = -1;
            this.maxToNode = -1;
            this.nextOut = 0;
        }
    }
}

