/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.planprinter.BasicOperatorStats;
import io.trino.sql.planner.planprinter.OperatorHashCollisionsStats;
import io.trino.sql.planner.planprinter.PlanNodeStats;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class HashCollisionPlanNodeStats
extends PlanNodeStats {
    private final Map<String, OperatorHashCollisionsStats> operatorHashCollisionsStats;

    public HashCollisionPlanNodeStats(PlanNodeId planNodeId, Duration planNodeScheduledTime, Duration planNodeCpuTime, long planNodeInputPositions, DataSize planNodeInputDataSize, long planNodeOutputPositions, DataSize planNodeOutputDataSize, DataSize planNodeSpilledDataSize, Map<String, BasicOperatorStats> operatorStats, Map<String, OperatorHashCollisionsStats> operatorHashCollisionsStats) {
        super(planNodeId, planNodeScheduledTime, planNodeCpuTime, planNodeInputPositions, planNodeInputDataSize, planNodeOutputPositions, planNodeOutputDataSize, planNodeSpilledDataSize, operatorStats);
        this.operatorHashCollisionsStats = Objects.requireNonNull(operatorHashCollisionsStats, "operatorHashCollisionsStats is null");
    }

    public Map<String, Double> getOperatorHashCollisionsAverages() {
        return this.operatorHashCollisionsStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((OperatorHashCollisionsStats)entry.getValue()).getWeightedHashCollisions() / (double)((OperatorHashCollisionsStats)entry.getValue()).getInputPositions()));
    }

    public Map<String, Double> getOperatorHashCollisionsStdDevs() {
        return this.operatorHashCollisionsStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> HashCollisionPlanNodeStats.computedWeightedStdDev(((OperatorHashCollisionsStats)entry.getValue()).getWeightedSumSquaredHashCollisions(), ((OperatorHashCollisionsStats)entry.getValue()).getWeightedHashCollisions(), ((OperatorHashCollisionsStats)entry.getValue()).getInputPositions())));
    }

    private static double computedWeightedStdDev(double sumSquared, double sum, double totalWeight) {
        double average = sum / totalWeight;
        double variance = (sumSquared - 2.0 * sum * average) / totalWeight + average * average;
        return Math.sqrt(Math.max(variance, 0.0));
    }

    public Map<String, Double> getOperatorExpectedCollisionsAverages() {
        return this.operatorHashCollisionsStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((OperatorHashCollisionsStats)entry.getValue()).getWeightedExpectedHashCollisions() / (double)((OperatorHashCollisionsStats)entry.getValue()).getInputPositions()));
    }

    @Override
    public PlanNodeStats mergeWith(PlanNodeStats other) {
        PlanNodeStats merged = super.mergeWith(other);
        return new HashCollisionPlanNodeStats(merged.getPlanNodeId(), merged.getPlanNodeScheduledTime(), merged.getPlanNodeCpuTime(), merged.getPlanNodeInputPositions(), merged.getPlanNodeInputDataSize(), merged.getPlanNodeOutputPositions(), merged.getPlanNodeOutputDataSize(), merged.getPlanNodeSpilledDataSize(), merged.operatorStats, this.operatorHashCollisionsStats);
    }
}

