/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class PruneMarkDistinctColumns
extends ProjectOffPushDownRule<MarkDistinctNode> {
    public PruneMarkDistinctColumns() {
        super(Patterns.markDistinct());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, MarkDistinctNode markDistinctNode, Set<Symbol> referencedOutputs) {
        if (!referencedOutputs.contains(markDistinctNode.getMarkerSymbol())) {
            return Optional.of(markDistinctNode.getSource());
        }
        Set requiredInputs = (Set)Streams.concat((Stream[])new Stream[]{referencedOutputs.stream().filter(symbol -> !symbol.equals(markDistinctNode.getMarkerSymbol())), markDistinctNode.getDistinctSymbols().stream(), markDistinctNode.getHashSymbol().stream()}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictChildOutputs(context.getIdAllocator(), markDistinctNode, requiredInputs);
    }
}

