/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.remotetask;

import com.google.common.util.concurrent.AtomicDouble;
import io.airlift.stats.DistributionStat;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class RemoteTaskStats {
    private final IncrementalAverage updateRoundTripMillis = new IncrementalAverage();
    private final IncrementalAverage infoRoundTripMillis = new IncrementalAverage();
    private final IncrementalAverage statusRoundTripMillis = new IncrementalAverage();
    private final IncrementalAverage responseSizeBytes = new IncrementalAverage();
    private final DistributionStat updateWithPlanBytes = new DistributionStat();
    private final DistributionStat updateWithDynamicFilterBytes = new DistributionStat();
    private long requestSuccess;
    private long requestFailure;

    public void statusRoundTripMillis(long roundTripMillis) {
        this.statusRoundTripMillis.add(roundTripMillis);
    }

    public void infoRoundTripMillis(long roundTripMillis) {
        this.infoRoundTripMillis.add(roundTripMillis);
    }

    public void updateRoundTripMillis(long roundTripMillis) {
        this.updateRoundTripMillis.add(roundTripMillis);
    }

    public void responseSize(long responseSizeBytes) {
        this.responseSizeBytes.add(responseSizeBytes);
    }

    public void updateSuccess() {
        ++this.requestSuccess;
    }

    public void updateFailure() {
        ++this.requestFailure;
    }

    public void updateWithPlanBytes(long bytes) {
        this.updateWithPlanBytes.add(bytes);
    }

    public void updateWithDynamicFilterBytes(long bytes) {
        this.updateWithDynamicFilterBytes.add(bytes);
    }

    @Managed
    public double getResponseSizeBytes() {
        return this.responseSizeBytes.get();
    }

    @Managed
    public double getStatusRoundTripMillis() {
        return this.statusRoundTripMillis.get();
    }

    @Managed
    public double getUpdateRoundTripMillis() {
        return this.updateRoundTripMillis.get();
    }

    @Managed
    public double getInfoRoundTripMillis() {
        return this.infoRoundTripMillis.get();
    }

    @Managed
    public long getRequestSuccess() {
        return this.requestSuccess;
    }

    @Managed
    public long getRequestFailure() {
        return this.requestFailure;
    }

    @Managed
    @Nested
    public DistributionStat getUpdateWithPlanBytes() {
        return this.updateWithPlanBytes;
    }

    @Managed
    @Nested
    public DistributionStat getUpdateWithDynamicFilterBytes() {
        return this.updateWithDynamicFilterBytes;
    }

    @ThreadSafe
    private static class IncrementalAverage {
        private long count;
        private final AtomicDouble average = new AtomicDouble();

        private IncrementalAverage() {
        }

        synchronized void add(long value) {
            ++this.count;
            double oldAverage = this.average.get();
            this.average.set(oldAverage + ((double)value - oldAverage) / (double)this.count);
        }

        double get() {
            return this.average.get();
        }
    }
}

