/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.airlift.configuration.ConfigBinder;
import io.trino.server.JmxNamingConfig;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.ObjectNameBuilder;
import org.weakref.jmx.ObjectNameGenerator;

public class PrefixObjectNameGeneratorModule
implements Module {
    private final String packagePrefix;

    public PrefixObjectNameGeneratorModule(String packagePrefix) {
        this.packagePrefix = Objects.requireNonNull(packagePrefix, "packagePrefix is null");
    }

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(JmxNamingConfig.class);
    }

    @Provides
    ObjectNameGenerator createPrefixObjectNameGenerator(JmxNamingConfig jmxNamingConfig) {
        return new PrefixObjectNameGenerator(this.packagePrefix, jmxNamingConfig.getDomainBase());
    }

    public static final class PrefixObjectNameGenerator
    implements ObjectNameGenerator {
        private final String packagePrefix;
        private final String replacement;

        public PrefixObjectNameGenerator(String packagePrefix, String replacement) {
            this.packagePrefix = packagePrefix;
            this.replacement = replacement;
        }

        public String generatedNameOf(Class<?> type, Map<String, String> properties) {
            Object domain = type.getPackage().getName();
            if (((String)domain).startsWith(this.packagePrefix)) {
                domain = this.replacement + ((String)domain).substring(this.packagePrefix.length());
            }
            return new ObjectNameBuilder((String)domain).withProperties(properties).build();
        }
    }
}

