/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import com.google.common.base.Preconditions;
import io.trino.spi.function.AccumulatorState;

public interface VarianceState
extends AccumulatorState {
    public long getCount();

    public void setCount(long var1);

    public double getMean();

    public void setMean(double var1);

    public double getM2();

    public void setM2(double var1);

    default public void update(double value) {
        this.setCount(this.getCount() + 1L);
        double delta = value - this.getMean();
        this.setMean(this.getMean() + delta / (double)this.getCount());
        this.setM2(this.getM2() + delta * (value - this.getMean()));
    }

    default public void merge(VarianceState otherState) {
        long count = otherState.getCount();
        double mean = otherState.getMean();
        double m2 = otherState.getM2();
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count is negative");
        if (count == 0L) {
            return;
        }
        long newCount = count + this.getCount();
        double newMean = ((double)count * mean + (double)this.getCount() * this.getMean()) / (double)newCount;
        double delta = mean - this.getMean();
        this.setM2(this.getM2() + m2 + delta * delta * (double)count * (double)this.getCount() / (double)newCount);
        this.setCount(newCount);
        this.setMean(newMean);
    }
}

