/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.warnings;

import com.google.common.collect.ImmutableList;
import io.trino.execution.warnings.WarningCollector;
import io.trino.execution.warnings.WarningCollectorConfig;
import io.trino.spi.TrinoWarning;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DefaultWarningCollector
implements WarningCollector {
    @GuardedBy(value="this")
    private final Set<TrinoWarning> warnings = new LinkedHashSet<TrinoWarning>();
    private final WarningCollectorConfig config;

    public DefaultWarningCollector(WarningCollectorConfig config) {
        this.config = Objects.requireNonNull(config, "config is null");
    }

    @Override
    public synchronized void add(TrinoWarning warning) {
        Objects.requireNonNull(warning, "warning is null");
        if (this.warnings.size() < this.config.getMaxWarnings()) {
            this.warnings.add(warning);
        }
    }

    @Override
    public synchronized List<TrinoWarning> getWarnings() {
        return ImmutableList.copyOf(this.warnings);
    }
}

