/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Objects;

public final class FileUtils {
    private static final int TEMP_DIR_ATTEMPTS = 10000;

    private FileUtils() {
    }

    public static boolean isSymbolicLink(File file) {
        try {
            File canonicalFile = file.getCanonicalFile();
            File absoluteFile = file.getAbsoluteFile();
            File parentFile = file.getParentFile();
            return !canonicalFile.getName().equals(absoluteFile.getName()) || parentFile != null && !parentFile.getCanonicalPath().equals(canonicalFile.getParent());
        }
        catch (IOException e) {
            return true;
        }
    }

    public static ImmutableList<File> listFiles(File dir) {
        Object[] files = dir.listFiles();
        if (files == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Object[])files);
    }

    public static ImmutableList<File> listFiles(File dir, FilenameFilter filter) {
        Object[] files = dir.listFiles(filter);
        if (files == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Object[])files);
    }

    public static File createTempDir(String prefix) {
        return FileUtils.createTempDir(new File(System.getProperty("java.io.tmpdir")), prefix);
    }

    public static File createTempDir(File parentDir, String prefix) {
        String baseName = "";
        if (prefix != null) {
            baseName = baseName + prefix + "-";
        }
        baseName = baseName + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(parentDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    public static boolean deleteDirectoryContents(File directory) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"Not a directory: %s", (Object)directory);
        if (FileUtils.isSymbolicLink(directory)) {
            return false;
        }
        boolean success = true;
        for (File file : FileUtils.listFiles(directory)) {
            success = FileUtils.deleteRecursively(file) && success;
        }
        return success;
    }

    public static boolean deleteRecursively(File file) {
        boolean success = true;
        if (file.isDirectory()) {
            success = FileUtils.deleteDirectoryContents(file);
        }
        return file.delete() && success;
    }

    public static boolean copyDirectoryContents(File src, File target) {
        Preconditions.checkArgument((boolean)src.isDirectory(), (String)"Source dir is not a directory: %s", (Object)src);
        if (FileUtils.isSymbolicLink(src)) {
            return false;
        }
        target.mkdirs();
        Preconditions.checkArgument((boolean)target.isDirectory(), (String)"Target dir is not a directory: %s", (Object)src);
        boolean success = true;
        for (File file : FileUtils.listFiles(src)) {
            success = FileUtils.copyRecursively(file, new File(target, file.getName())) && success;
        }
        return success;
    }

    public static boolean copyRecursively(File src, File target) {
        if (src.isDirectory()) {
            return FileUtils.copyDirectoryContents(src, target);
        }
        try {
            Files.copy((File)src, (File)target);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static File newFile(String parent, String ... paths) {
        Objects.requireNonNull(parent, "parent is null");
        Objects.requireNonNull(paths, "paths is null");
        return FileUtils.newFile(new File(parent), (Iterable<String>)ImmutableList.copyOf((Object[])paths));
    }

    public static File newFile(File parent, String ... paths) {
        Objects.requireNonNull(parent, "parent is null");
        Objects.requireNonNull(paths, "paths is null");
        return FileUtils.newFile(parent, (Iterable<String>)ImmutableList.copyOf((Object[])paths));
    }

    public static File newFile(File parent, Iterable<String> paths) {
        Objects.requireNonNull(parent, "parent is null");
        Objects.requireNonNull(paths, "paths is null");
        File result = parent;
        for (String path : paths) {
            result = new File(result, path);
        }
        return result;
    }
}

