/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class UpdateEventDetails extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 685;
  }

  // Properties.
  protected final NodeId nodeId;
  protected final PerformUpdateType performInsertReplace;
  protected final EventFilter filter;
  protected final List<HistoryEventFieldList> eventData;

  public UpdateEventDetails(
      NodeId nodeId,
      PerformUpdateType performInsertReplace,
      EventFilter filter,
      List<HistoryEventFieldList> eventData) {
    super();
    this.nodeId = nodeId;
    this.performInsertReplace = performInsertReplace;
    this.filter = filter;
    this.eventData = eventData;
  }

  public NodeId getNodeId() {
    return nodeId;
  }

  public PerformUpdateType getPerformInsertReplace() {
    return performInsertReplace;
  }

  public EventFilter getFilter() {
    return filter;
  }

  public List<HistoryEventFieldList> getEventData() {
    return eventData;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("UpdateEventDetails");

    // Simple Field (nodeId)
    writeSimpleField("nodeId", nodeId, writeComplex(writeBuffer));

    // Simple Field (performInsertReplace)
    writeSimpleEnumField(
        "performInsertReplace",
        "PerformUpdateType",
        performInsertReplace,
        writeEnum(
            PerformUpdateType::getValue,
            PerformUpdateType::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (filter)
    writeSimpleField("filter", filter, writeComplex(writeBuffer));

    // Implicit Field (noOfEventData) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfEventData = (int) ((((getEventData()) == (null)) ? -(1) : COUNT(getEventData())));
    writeImplicitField("noOfEventData", noOfEventData, writeSignedInt(writeBuffer, 32));

    // Array Field (eventData)
    writeComplexTypeArrayField("eventData", eventData, writeBuffer);

    writeBuffer.popContext("UpdateEventDetails");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    UpdateEventDetails _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (nodeId)
    lengthInBits += nodeId.getLengthInBits();

    // Simple field (performInsertReplace)
    lengthInBits += 32;

    // Simple field (filter)
    lengthInBits += filter.getLengthInBits();

    // Implicit Field (noOfEventData)
    lengthInBits += 32;

    // Array field
    if (eventData != null) {
      int i = 0;
      for (HistoryEventFieldList element : eventData) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= eventData.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("UpdateEventDetails");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NodeId nodeId =
        readSimpleField("nodeId", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    PerformUpdateType performInsertReplace =
        readEnumField(
            "performInsertReplace",
            "PerformUpdateType",
            readEnum(PerformUpdateType::enumForValue, readUnsignedLong(readBuffer, 32)));

    EventFilter filter =
        readSimpleField(
            "filter",
            readComplex(
                () -> (EventFilter) ExtensionObjectDefinition.staticParse(readBuffer, (int) (727)),
                readBuffer));

    int noOfEventData = readImplicitField("noOfEventData", readSignedInt(readBuffer, 32));

    List<HistoryEventFieldList> eventData =
        readCountArrayField(
            "eventData",
            readComplex(
                () ->
                    (HistoryEventFieldList)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (922)),
                readBuffer),
            noOfEventData);

    readBuffer.closeContext("UpdateEventDetails");
    // Create the instance
    return new UpdateEventDetailsBuilderImpl(nodeId, performInsertReplace, filter, eventData);
  }

  public static class UpdateEventDetailsBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId nodeId;
    private final PerformUpdateType performInsertReplace;
    private final EventFilter filter;
    private final List<HistoryEventFieldList> eventData;

    public UpdateEventDetailsBuilderImpl(
        NodeId nodeId,
        PerformUpdateType performInsertReplace,
        EventFilter filter,
        List<HistoryEventFieldList> eventData) {
      this.nodeId = nodeId;
      this.performInsertReplace = performInsertReplace;
      this.filter = filter;
      this.eventData = eventData;
    }

    public UpdateEventDetails build() {
      UpdateEventDetails updateEventDetails =
          new UpdateEventDetails(nodeId, performInsertReplace, filter, eventData);
      return updateEventDetails;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof UpdateEventDetails)) {
      return false;
    }
    UpdateEventDetails that = (UpdateEventDetails) o;
    return (getNodeId() == that.getNodeId())
        && (getPerformInsertReplace() == that.getPerformInsertReplace())
        && (getFilter() == that.getFilter())
        && (getEventData() == that.getEventData())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getNodeId(), getPerformInsertReplace(), getFilter(), getEventData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
