/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class MediaTransportControlDataRewind extends MediaTransportControlData implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final byte operation;

  public MediaTransportControlDataRewind(
      MediaTransportControlCommandTypeContainer commandTypeContainer,
      byte mediaLinkGroup,
      byte operation) {
    super(commandTypeContainer, mediaLinkGroup);
    this.operation = operation;
  }

  public byte getOperation() {
    return operation;
  }

  public boolean getIsCeaseRewind() {
    return (boolean) ((getOperation()) == (0x00));
  }

  public boolean getIs2x() {
    return (boolean) ((getOperation()) == (0x02));
  }

  public boolean getIs4x() {
    return (boolean) ((getOperation()) == (0x04));
  }

  public boolean getIs8x() {
    return (boolean) ((getOperation()) == (0x06));
  }

  public boolean getIs16x() {
    return (boolean) ((getOperation()) == (0x08));
  }

  public boolean getIs32x() {
    return (boolean) ((getOperation()) == (0x0A));
  }

  public boolean getIs64x() {
    return (boolean) ((getOperation()) == (0x0C));
  }

  public boolean getIsReserved() {
    return (boolean)
        (((((((!(getIsCeaseRewind())) && (!(getIs2x()))) && (!(getIs4x()))) && (!(getIs8x())))
                    && (!(getIs16x())))
                && (!(getIs32x())))
            && (!(getIs64x())));
  }

  @Override
  protected void serializeMediaTransportControlDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("MediaTransportControlDataRewind");

    // Simple Field (operation)
    writeSimpleField("operation", operation, writeByte(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isCeaseRewind = getIsCeaseRewind();
    writeBuffer.writeVirtual("isCeaseRewind", isCeaseRewind);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean is2x = getIs2x();
    writeBuffer.writeVirtual("is2x", is2x);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean is4x = getIs4x();
    writeBuffer.writeVirtual("is4x", is4x);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean is8x = getIs8x();
    writeBuffer.writeVirtual("is8x", is8x);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean is16x = getIs16x();
    writeBuffer.writeVirtual("is16x", is16x);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean is32x = getIs32x();
    writeBuffer.writeVirtual("is32x", is32x);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean is64x = getIs64x();
    writeBuffer.writeVirtual("is64x", is64x);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isReserved = getIsReserved();
    writeBuffer.writeVirtual("isReserved", isReserved);

    writeBuffer.popContext("MediaTransportControlDataRewind");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    MediaTransportControlDataRewind _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (operation)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static MediaTransportControlDataBuilder staticParseMediaTransportControlDataBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("MediaTransportControlDataRewind");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte operation = readSimpleField("operation", readByte(readBuffer, 8));
    boolean isCeaseRewind = readVirtualField("isCeaseRewind", boolean.class, (operation) == (0x00));
    boolean is2x = readVirtualField("is2x", boolean.class, (operation) == (0x02));
    boolean is4x = readVirtualField("is4x", boolean.class, (operation) == (0x04));
    boolean is8x = readVirtualField("is8x", boolean.class, (operation) == (0x06));
    boolean is16x = readVirtualField("is16x", boolean.class, (operation) == (0x08));
    boolean is32x = readVirtualField("is32x", boolean.class, (operation) == (0x0A));
    boolean is64x = readVirtualField("is64x", boolean.class, (operation) == (0x0C));
    boolean isReserved =
        readVirtualField(
            "isReserved",
            boolean.class,
            ((((((!(isCeaseRewind)) && (!(is2x))) && (!(is4x))) && (!(is8x))) && (!(is16x)))
                    && (!(is32x)))
                && (!(is64x)));

    readBuffer.closeContext("MediaTransportControlDataRewind");
    // Create the instance
    return new MediaTransportControlDataRewindBuilderImpl(operation);
  }

  public static class MediaTransportControlDataRewindBuilderImpl
      implements MediaTransportControlData.MediaTransportControlDataBuilder {
    private final byte operation;

    public MediaTransportControlDataRewindBuilderImpl(byte operation) {
      this.operation = operation;
    }

    public MediaTransportControlDataRewind build(
        MediaTransportControlCommandTypeContainer commandTypeContainer, byte mediaLinkGroup) {
      MediaTransportControlDataRewind mediaTransportControlDataRewind =
          new MediaTransportControlDataRewind(commandTypeContainer, mediaLinkGroup, operation);
      return mediaTransportControlDataRewind;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof MediaTransportControlDataRewind)) {
      return false;
    }
    MediaTransportControlDataRewind that = (MediaTransportControlDataRewind) o;
    return (getOperation() == that.getOperation()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getOperation());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
