/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SALDataClockAndTimekeeping is the corresponding interface of SALDataClockAndTimekeeping
type SALDataClockAndTimekeeping interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SALData
	// GetClockAndTimekeepingData returns ClockAndTimekeepingData (property field)
	GetClockAndTimekeepingData() ClockAndTimekeepingData
	// IsSALDataClockAndTimekeeping is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSALDataClockAndTimekeeping()
	// CreateBuilder creates a SALDataClockAndTimekeepingBuilder
	CreateSALDataClockAndTimekeepingBuilder() SALDataClockAndTimekeepingBuilder
}

// _SALDataClockAndTimekeeping is the data-structure of this message
type _SALDataClockAndTimekeeping struct {
	SALDataContract
	ClockAndTimekeepingData ClockAndTimekeepingData
}

var _ SALDataClockAndTimekeeping = (*_SALDataClockAndTimekeeping)(nil)
var _ SALDataRequirements = (*_SALDataClockAndTimekeeping)(nil)

// NewSALDataClockAndTimekeeping factory function for _SALDataClockAndTimekeeping
func NewSALDataClockAndTimekeeping(salData SALData, clockAndTimekeepingData ClockAndTimekeepingData) *_SALDataClockAndTimekeeping {
	if clockAndTimekeepingData == nil {
		panic("clockAndTimekeepingData of type ClockAndTimekeepingData for SALDataClockAndTimekeeping must not be nil")
	}
	_result := &_SALDataClockAndTimekeeping{
		SALDataContract:         NewSALData(salData),
		ClockAndTimekeepingData: clockAndTimekeepingData,
	}
	_result.SALDataContract.(*_SALData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SALDataClockAndTimekeepingBuilder is a builder for SALDataClockAndTimekeeping
type SALDataClockAndTimekeepingBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(clockAndTimekeepingData ClockAndTimekeepingData) SALDataClockAndTimekeepingBuilder
	// WithClockAndTimekeepingData adds ClockAndTimekeepingData (property field)
	WithClockAndTimekeepingData(ClockAndTimekeepingData) SALDataClockAndTimekeepingBuilder
	// WithClockAndTimekeepingDataBuilder adds ClockAndTimekeepingData (property field) which is build by the builder
	WithClockAndTimekeepingDataBuilder(func(ClockAndTimekeepingDataBuilder) ClockAndTimekeepingDataBuilder) SALDataClockAndTimekeepingBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SALDataBuilder
	// Build builds the SALDataClockAndTimekeeping or returns an error if something is wrong
	Build() (SALDataClockAndTimekeeping, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SALDataClockAndTimekeeping
}

// NewSALDataClockAndTimekeepingBuilder() creates a SALDataClockAndTimekeepingBuilder
func NewSALDataClockAndTimekeepingBuilder() SALDataClockAndTimekeepingBuilder {
	return &_SALDataClockAndTimekeepingBuilder{_SALDataClockAndTimekeeping: new(_SALDataClockAndTimekeeping)}
}

type _SALDataClockAndTimekeepingBuilder struct {
	*_SALDataClockAndTimekeeping

	parentBuilder *_SALDataBuilder

	collectedErr []error
}

var _ (SALDataClockAndTimekeepingBuilder) = (*_SALDataClockAndTimekeepingBuilder)(nil)

func (b *_SALDataClockAndTimekeepingBuilder) setParent(contract SALDataContract) {
	b.SALDataContract = contract
	contract.(*_SALData)._SubType = b._SALDataClockAndTimekeeping
}

func (b *_SALDataClockAndTimekeepingBuilder) WithMandatoryFields(clockAndTimekeepingData ClockAndTimekeepingData) SALDataClockAndTimekeepingBuilder {
	return b.WithClockAndTimekeepingData(clockAndTimekeepingData)
}

func (b *_SALDataClockAndTimekeepingBuilder) WithClockAndTimekeepingData(clockAndTimekeepingData ClockAndTimekeepingData) SALDataClockAndTimekeepingBuilder {
	b.ClockAndTimekeepingData = clockAndTimekeepingData
	return b
}

func (b *_SALDataClockAndTimekeepingBuilder) WithClockAndTimekeepingDataBuilder(builderSupplier func(ClockAndTimekeepingDataBuilder) ClockAndTimekeepingDataBuilder) SALDataClockAndTimekeepingBuilder {
	builder := builderSupplier(b.ClockAndTimekeepingData.CreateClockAndTimekeepingDataBuilder())
	var err error
	b.ClockAndTimekeepingData, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "ClockAndTimekeepingDataBuilder failed"))
	}
	return b
}

func (b *_SALDataClockAndTimekeepingBuilder) Build() (SALDataClockAndTimekeeping, error) {
	if b.ClockAndTimekeepingData == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'clockAndTimekeepingData' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SALDataClockAndTimekeeping.deepCopy(), nil
}

func (b *_SALDataClockAndTimekeepingBuilder) MustBuild() SALDataClockAndTimekeeping {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SALDataClockAndTimekeepingBuilder) Done() SALDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSALDataBuilder().(*_SALDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SALDataClockAndTimekeepingBuilder) buildForSALData() (SALData, error) {
	return b.Build()
}

func (b *_SALDataClockAndTimekeepingBuilder) DeepCopy() any {
	_copy := b.CreateSALDataClockAndTimekeepingBuilder().(*_SALDataClockAndTimekeepingBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSALDataClockAndTimekeepingBuilder creates a SALDataClockAndTimekeepingBuilder
func (b *_SALDataClockAndTimekeeping) CreateSALDataClockAndTimekeepingBuilder() SALDataClockAndTimekeepingBuilder {
	if b == nil {
		return NewSALDataClockAndTimekeepingBuilder()
	}
	return &_SALDataClockAndTimekeepingBuilder{_SALDataClockAndTimekeeping: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SALDataClockAndTimekeeping) GetApplicationId() ApplicationId {
	return ApplicationId_CLOCK_AND_TIMEKEEPING
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SALDataClockAndTimekeeping) GetParent() SALDataContract {
	return m.SALDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SALDataClockAndTimekeeping) GetClockAndTimekeepingData() ClockAndTimekeepingData {
	return m.ClockAndTimekeepingData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSALDataClockAndTimekeeping(structType any) SALDataClockAndTimekeeping {
	if casted, ok := structType.(SALDataClockAndTimekeeping); ok {
		return casted
	}
	if casted, ok := structType.(*SALDataClockAndTimekeeping); ok {
		return *casted
	}
	return nil
}

func (m *_SALDataClockAndTimekeeping) GetTypeName() string {
	return "SALDataClockAndTimekeeping"
}

func (m *_SALDataClockAndTimekeeping) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SALDataContract.(*_SALData).getLengthInBits(ctx))

	// Simple field (clockAndTimekeepingData)
	lengthInBits += m.ClockAndTimekeepingData.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_SALDataClockAndTimekeeping) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SALDataClockAndTimekeeping) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SALData, applicationId ApplicationId) (__sALDataClockAndTimekeeping SALDataClockAndTimekeeping, err error) {
	m.SALDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SALDataClockAndTimekeeping"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SALDataClockAndTimekeeping")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	clockAndTimekeepingData, err := ReadSimpleField[ClockAndTimekeepingData](ctx, "clockAndTimekeepingData", ReadComplex[ClockAndTimekeepingData](ClockAndTimekeepingDataParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'clockAndTimekeepingData' field"))
	}
	m.ClockAndTimekeepingData = clockAndTimekeepingData

	if closeErr := readBuffer.CloseContext("SALDataClockAndTimekeeping"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SALDataClockAndTimekeeping")
	}

	return m, nil
}

func (m *_SALDataClockAndTimekeeping) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SALDataClockAndTimekeeping) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SALDataClockAndTimekeeping"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SALDataClockAndTimekeeping")
		}

		if err := WriteSimpleField[ClockAndTimekeepingData](ctx, "clockAndTimekeepingData", m.GetClockAndTimekeepingData(), WriteComplex[ClockAndTimekeepingData](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'clockAndTimekeepingData' field")
		}

		if popErr := writeBuffer.PopContext("SALDataClockAndTimekeeping"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SALDataClockAndTimekeeping")
		}
		return nil
	}
	return m.SALDataContract.(*_SALData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SALDataClockAndTimekeeping) IsSALDataClockAndTimekeeping() {}

func (m *_SALDataClockAndTimekeeping) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SALDataClockAndTimekeeping) deepCopy() *_SALDataClockAndTimekeeping {
	if m == nil {
		return nil
	}
	_SALDataClockAndTimekeepingCopy := &_SALDataClockAndTimekeeping{
		m.SALDataContract.(*_SALData).deepCopy(),
		utils.DeepCopy[ClockAndTimekeepingData](m.ClockAndTimekeepingData),
	}
	_SALDataClockAndTimekeepingCopy.SALDataContract.(*_SALData)._SubType = m
	return _SALDataClockAndTimekeepingCopy
}

func (m *_SALDataClockAndTimekeeping) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
