/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataUpdateKeySetTimeout is the corresponding interface of BACnetConstructedDataUpdateKeySetTimeout
type BACnetConstructedDataUpdateKeySetTimeout interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetUpdateKeySetTimeout returns UpdateKeySetTimeout (property field)
	GetUpdateKeySetTimeout() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataUpdateKeySetTimeout is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataUpdateKeySetTimeout()
	// CreateBuilder creates a BACnetConstructedDataUpdateKeySetTimeoutBuilder
	CreateBACnetConstructedDataUpdateKeySetTimeoutBuilder() BACnetConstructedDataUpdateKeySetTimeoutBuilder
}

// _BACnetConstructedDataUpdateKeySetTimeout is the data-structure of this message
type _BACnetConstructedDataUpdateKeySetTimeout struct {
	BACnetConstructedDataContract
	UpdateKeySetTimeout BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataUpdateKeySetTimeout = (*_BACnetConstructedDataUpdateKeySetTimeout)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataUpdateKeySetTimeout)(nil)

// NewBACnetConstructedDataUpdateKeySetTimeout factory function for _BACnetConstructedDataUpdateKeySetTimeout
func NewBACnetConstructedDataUpdateKeySetTimeout(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, updateKeySetTimeout BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataUpdateKeySetTimeout {
	if updateKeySetTimeout == nil {
		panic("updateKeySetTimeout of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataUpdateKeySetTimeout must not be nil")
	}
	_result := &_BACnetConstructedDataUpdateKeySetTimeout{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		UpdateKeySetTimeout:           updateKeySetTimeout,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataUpdateKeySetTimeoutBuilder is a builder for BACnetConstructedDataUpdateKeySetTimeout
type BACnetConstructedDataUpdateKeySetTimeoutBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(updateKeySetTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataUpdateKeySetTimeoutBuilder
	// WithUpdateKeySetTimeout adds UpdateKeySetTimeout (property field)
	WithUpdateKeySetTimeout(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataUpdateKeySetTimeoutBuilder
	// WithUpdateKeySetTimeoutBuilder adds UpdateKeySetTimeout (property field) which is build by the builder
	WithUpdateKeySetTimeoutBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataUpdateKeySetTimeoutBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataUpdateKeySetTimeout or returns an error if something is wrong
	Build() (BACnetConstructedDataUpdateKeySetTimeout, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataUpdateKeySetTimeout
}

// NewBACnetConstructedDataUpdateKeySetTimeoutBuilder() creates a BACnetConstructedDataUpdateKeySetTimeoutBuilder
func NewBACnetConstructedDataUpdateKeySetTimeoutBuilder() BACnetConstructedDataUpdateKeySetTimeoutBuilder {
	return &_BACnetConstructedDataUpdateKeySetTimeoutBuilder{_BACnetConstructedDataUpdateKeySetTimeout: new(_BACnetConstructedDataUpdateKeySetTimeout)}
}

type _BACnetConstructedDataUpdateKeySetTimeoutBuilder struct {
	*_BACnetConstructedDataUpdateKeySetTimeout

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataUpdateKeySetTimeoutBuilder) = (*_BACnetConstructedDataUpdateKeySetTimeoutBuilder)(nil)

func (b *_BACnetConstructedDataUpdateKeySetTimeoutBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataUpdateKeySetTimeout
}

func (b *_BACnetConstructedDataUpdateKeySetTimeoutBuilder) WithMandatoryFields(updateKeySetTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataUpdateKeySetTimeoutBuilder {
	return b.WithUpdateKeySetTimeout(updateKeySetTimeout)
}

func (b *_BACnetConstructedDataUpdateKeySetTimeoutBuilder) WithUpdateKeySetTimeout(updateKeySetTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataUpdateKeySetTimeoutBuilder {
	b.UpdateKeySetTimeout = updateKeySetTimeout
	return b
}

func (b *_BACnetConstructedDataUpdateKeySetTimeoutBuilder) WithUpdateKeySetTimeoutBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataUpdateKeySetTimeoutBuilder {
	builder := builderSupplier(b.UpdateKeySetTimeout.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.UpdateKeySetTimeout, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataUpdateKeySetTimeoutBuilder) Build() (BACnetConstructedDataUpdateKeySetTimeout, error) {
	if b.UpdateKeySetTimeout == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'updateKeySetTimeout' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataUpdateKeySetTimeout.deepCopy(), nil
}

func (b *_BACnetConstructedDataUpdateKeySetTimeoutBuilder) MustBuild() BACnetConstructedDataUpdateKeySetTimeout {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataUpdateKeySetTimeoutBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataUpdateKeySetTimeoutBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataUpdateKeySetTimeoutBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataUpdateKeySetTimeoutBuilder().(*_BACnetConstructedDataUpdateKeySetTimeoutBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataUpdateKeySetTimeoutBuilder creates a BACnetConstructedDataUpdateKeySetTimeoutBuilder
func (b *_BACnetConstructedDataUpdateKeySetTimeout) CreateBACnetConstructedDataUpdateKeySetTimeoutBuilder() BACnetConstructedDataUpdateKeySetTimeoutBuilder {
	if b == nil {
		return NewBACnetConstructedDataUpdateKeySetTimeoutBuilder()
	}
	return &_BACnetConstructedDataUpdateKeySetTimeoutBuilder{_BACnetConstructedDataUpdateKeySetTimeout: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataUpdateKeySetTimeout) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataUpdateKeySetTimeout) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_UPDATE_KEY_SET_TIMEOUT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataUpdateKeySetTimeout) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataUpdateKeySetTimeout) GetUpdateKeySetTimeout() BACnetApplicationTagUnsignedInteger {
	return m.UpdateKeySetTimeout
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataUpdateKeySetTimeout) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetUpdateKeySetTimeout())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataUpdateKeySetTimeout(structType any) BACnetConstructedDataUpdateKeySetTimeout {
	if casted, ok := structType.(BACnetConstructedDataUpdateKeySetTimeout); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataUpdateKeySetTimeout); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataUpdateKeySetTimeout) GetTypeName() string {
	return "BACnetConstructedDataUpdateKeySetTimeout"
}

func (m *_BACnetConstructedDataUpdateKeySetTimeout) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (updateKeySetTimeout)
	lengthInBits += m.UpdateKeySetTimeout.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataUpdateKeySetTimeout) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataUpdateKeySetTimeout) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataUpdateKeySetTimeout BACnetConstructedDataUpdateKeySetTimeout, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataUpdateKeySetTimeout"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataUpdateKeySetTimeout")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	updateKeySetTimeout, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "updateKeySetTimeout", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'updateKeySetTimeout' field"))
	}
	m.UpdateKeySetTimeout = updateKeySetTimeout

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), updateKeySetTimeout)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataUpdateKeySetTimeout"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataUpdateKeySetTimeout")
	}

	return m, nil
}

func (m *_BACnetConstructedDataUpdateKeySetTimeout) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataUpdateKeySetTimeout) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataUpdateKeySetTimeout"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataUpdateKeySetTimeout")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "updateKeySetTimeout", m.GetUpdateKeySetTimeout(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'updateKeySetTimeout' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataUpdateKeySetTimeout"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataUpdateKeySetTimeout")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataUpdateKeySetTimeout) IsBACnetConstructedDataUpdateKeySetTimeout() {}

func (m *_BACnetConstructedDataUpdateKeySetTimeout) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataUpdateKeySetTimeout) deepCopy() *_BACnetConstructedDataUpdateKeySetTimeout {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataUpdateKeySetTimeoutCopy := &_BACnetConstructedDataUpdateKeySetTimeout{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.UpdateKeySetTimeout),
	}
	_BACnetConstructedDataUpdateKeySetTimeoutCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataUpdateKeySetTimeoutCopy
}

func (m *_BACnetConstructedDataUpdateKeySetTimeout) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
