/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.columnar.ColumnarStruct;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.Expression;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.piggybank.storage.hiverc.HiveRCInputFormat;
import org.apache.pig.piggybank.storage.hiverc.HiveRCRecordReader;
import org.apache.pig.piggybank.storage.hiverc.HiveRCSchemaUtil;
import org.apache.pig.piggybank.storage.partition.PathPartitionHelper;

public class HiveColumnarLoader
extends FileInputLoadFunc
implements LoadMetadata,
LoadPushDown {
    public static final String PROJECTION_ID = HiveColumnarLoader.class.getName() + ".projection";
    public static final String DATE_RANGE = HiveColumnarLoader.class.getName() + ".date-range";
    protected static final Pattern pcols = Pattern.compile("[a-zA-Z_0-9]*[ ]");
    protected static final Log LOG = LogFactory.getLog(HiveColumnarLoader.class);
    protected TupleFactory tupleFactory = TupleFactory.getInstance();
    String signature = "";
    String dateRange = null;
    HiveRCRecordReader reader;
    ColumnarSerDe serde = null;
    Configuration conf = null;
    ResourceSchema pigSchema;
    boolean partitionKeysSet = false;
    BytesRefArrayWritable buff = null;
    private Properties props;
    private HiveConf hiveConf;
    transient int[] requiredColumns;
    transient Set<String> partitionColumns;
    transient PathPartitionHelper pathPartitionerHelper = new PathPartitionHelper();
    transient Path currentPath = null;
    transient Map<String, String> currentPathPartitionKeyMap;

    public HiveColumnarLoader(String table_schema) {
        this.setup(table_schema);
    }

    public HiveColumnarLoader(String table_schema, String dateRange, String columns) {
        this.setup(table_schema);
        this.dateRange = dateRange;
    }

    public HiveColumnarLoader(String table_schema, String dateRange) {
        this.setup(table_schema);
        this.dateRange = dateRange;
    }

    private Properties getUDFContext() {
        return UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
    }

    public InputFormat<LongWritable, BytesRefArrayWritable> getInputFormat() throws IOException {
        LOG.info((Object)("Signature: " + this.signature));
        return new HiveRCInputFormat(this.signature);
    }

    public Tuple getNext() throws IOException {
        Tuple tuple = null;
        try {
            if (this.reader.nextKeyValue()) {
                BytesRefArrayWritable buff = this.reader.getCurrentValue();
                ColumnarStruct struct = this.readColumnarStruct(buff);
                tuple = this.readColumnarTuple(struct, this.reader.getSplitPath());
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString(), e);
        }
        return tuple;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.reader = (HiveRCRecordReader)reader;
        int[] requiredIndexes = this.getRequiredColumns();
        if (requiredIndexes == null) {
            int fieldLen = this.pigSchema.getFields().length;
            String[] partitionKeys = this.getPartitionKeys(null, null);
            if (partitionKeys != null) {
                fieldLen += partitionKeys.length;
            }
            requiredIndexes = new int[fieldLen];
            for (int i = 0; i < fieldLen; ++i) {
                requiredIndexes[i] = i;
            }
            this.requiredColumns = requiredIndexes;
        }
        try {
            this.serde = new ColumnarSerDe();
            this.serde.initialize((Configuration)this.hiveConf, this.props);
        }
        catch (SerDeException e) {
            LOG.error((Object)e.toString(), (Throwable)e);
            throw new IOException(e);
        }
    }

    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    private void setup(String table_schema) {
        if (table_schema == null) {
            throw new RuntimeException("The table schema must be defined as colname type, colname type.  All types are hive types");
        }
        this.conf = new Configuration();
        this.hiveConf = new HiveConf(this.conf, SessionState.class);
        List<String> types = HiveRCSchemaUtil.parseSchemaTypes(table_schema);
        List<String> cols = HiveRCSchemaUtil.parseSchema(pcols, table_schema);
        ArrayList<Schema.FieldSchema> fieldSchemaList = new ArrayList<Schema.FieldSchema>(cols.size());
        for (int i = 0; i < cols.size(); ++i) {
            fieldSchemaList.add(new Schema.FieldSchema(cols.get(i), HiveRCSchemaUtil.findPigDataType(types.get(i))));
        }
        this.pigSchema = new ResourceSchema(new Schema(fieldSchemaList));
        this.props = new Properties();
        this.props.setProperty("columns", HiveRCSchemaUtil.listToString(cols));
        this.props.setProperty("columns.types", HiveRCSchemaUtil.listToString(types));
    }

    private ColumnarStruct readColumnarStruct(BytesRefArrayWritable buff) {
        ColumnarStruct struct = null;
        try {
            struct = (ColumnarStruct)this.serde.deserialize((Writable)buff);
        }
        catch (SerDeException e) {
            LOG.error((Object)e.toString(), (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
        return struct;
    }

    private Tuple readColumnarTuple(ColumnarStruct struct, Path path) throws IOException {
        int[] columnIndexes = this.getRequiredColumns();
        String[] partitionKeys = this.getPartitionKeys(null, null);
        if (this.currentPath == null || !this.currentPath.equals((Object)path)) {
            this.currentPathPartitionKeyMap = partitionKeys == null ? null : this.pathPartitionerHelper.getPathPartitionKeyValues(path.toString());
            this.currentPath = path;
        }
        int partitionColumnStartIndex = Integer.MAX_VALUE;
        if (this.partitionColumns != null && this.partitionColumns.size() != 0) {
            partitionColumnStartIndex = this.pigSchema.getFields().length;
        }
        Tuple t = this.tupleFactory.newTuple(columnIndexes.length);
        for (int i = 0; i < columnIndexes.length; ++i) {
            int columnIndex = columnIndexes[i];
            if (columnIndex < partitionColumnStartIndex) {
                Object obj = struct.getField(columnIndex);
                Object pigType = HiveRCSchemaUtil.extractPigTypeFromHiveType(obj);
                t.set(i, pigType);
                continue;
            }
            String key = partitionKeys[columnIndex - partitionColumnStartIndex];
            String value = this.currentPathPartitionKeyMap.get(key);
            t.set(i, (Object)value);
        }
        return t;
    }

    private int[] getRequiredColumns() {
        Properties properties;
        String projectionStr;
        if (this.requiredColumns == null && (projectionStr = (properties = this.getUDFContext()).getProperty(PROJECTION_ID)) != null) {
            String[] split = projectionStr.split(",");
            int[] columnIndexes = new int[split.length];
            int index = 0;
            for (String splitItem : split) {
                columnIndexes[index++] = Integer.parseInt(splitItem);
            }
            this.requiredColumns = columnIndexes;
        }
        return this.requiredColumns;
    }

    private Set<String> getPartitionColumns(String location, Job job) {
        if (this.partitionColumns == null) {
            String partitionColumnStr;
            Properties properties = this.getUDFContext();
            if (properties == null) {
                properties = new Properties();
            }
            if ((partitionColumnStr = properties.getProperty(PathPartitionHelper.PARTITION_COLUMNS)) == null && location != null && job != null) {
                Set<String> partitionColumnSet;
                try {
                    partitionColumnSet = this.pathPartitionerHelper.getPartitionKeys(location, job.getConfiguration());
                }
                catch (IOException e) {
                    RuntimeException rte = new RuntimeException(e);
                    rte.setStackTrace(e.getStackTrace());
                    throw rte;
                }
                if (partitionColumnSet != null) {
                    StringBuilder buff = new StringBuilder();
                    int i = 0;
                    for (String column : partitionColumnSet) {
                        if (i++ != 0) {
                            buff.append(',');
                        }
                        buff.append(column);
                    }
                    String buffStr = buff.toString().trim();
                    if (buffStr.length() > 0) {
                        properties.setProperty(PathPartitionHelper.PARTITION_COLUMNS, buff.toString());
                    }
                    this.partitionColumns = partitionColumnSet;
                }
            } else if (partitionColumnStr != null) {
                String[] split = partitionColumnStr.split(",");
                this.partitionColumns = new LinkedHashSet<String>();
                if (split.length > 0) {
                    for (String splitItem : split) {
                        this.partitionColumns.add(splitItem);
                    }
                }
            }
        }
        return this.partitionColumns;
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        Set<String> partitionKeys = this.getPartitionColumns(location, job);
        return partitionKeys == null ? null : partitionKeys.toArray(new String[0]);
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        if (!this.partitionKeysSet) {
            Set<String> keys = this.getPartitionColumns(location, job);
            if (keys != null && keys.size() != 0) {
                Object[] fields = this.pigSchema.getFields();
                LOG.debug((Object)("Schema: " + Arrays.toString(fields)));
                Object[] newFields = (ResourceSchema.ResourceFieldSchema[])Arrays.copyOf(fields, fields.length + keys.size());
                int index = fields.length;
                for (String key : keys) {
                    newFields[index++] = new ResourceSchema.ResourceFieldSchema(new Schema.FieldSchema(key, 55));
                }
                this.pigSchema.setFields((ResourceSchema.ResourceFieldSchema[])newFields);
                LOG.debug((Object)("Added partition fields: " + keys + " to loader schema"));
                LOG.debug((Object)("Schema is: " + Arrays.toString(newFields)));
            }
            this.partitionKeysSet = true;
        }
        return this.pigSchema;
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
        this.getUDFContext().setProperty(PathPartitionHelper.PARITITION_FILTER_EXPRESSION, partitionFilter.toString());
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        for (LoadPushDown.RequiredField f : requiredFieldList.getFields()) {
            if (i++ != 0) {
                buff.append(',');
            }
            buff.append(f.getIndex());
        }
        Properties properties = this.getUDFContext();
        properties.setProperty(PROJECTION_ID, buff.toString());
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public void setUDFContextSignature(String signature) {
        super.setUDFContextSignature(signature);
        LOG.debug((Object)("Signature: " + signature));
        this.signature = signature;
        if (this.dateRange != null) {
            this.getUDFContext().setProperty(DATE_RANGE, this.dateRange);
        }
    }
}

