/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.session;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.accumulo.core.client.impl.Translator;
import org.apache.accumulo.core.client.impl.Translators;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.ScanState;
import org.apache.accumulo.core.tabletserver.thrift.ScanType;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.tserver.scan.ScanRunState;
import org.apache.accumulo.tserver.scan.ScanTask;
import org.apache.accumulo.tserver.session.MultiScanSession;
import org.apache.accumulo.tserver.session.ScanSession;
import org.apache.accumulo.tserver.session.Session;
import org.apache.accumulo.tserver.session.UpdateSession;
import org.apache.accumulo.tserver.tablet.ScanBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private final SecureRandom random;
    private final ConcurrentMap<Long, Session> sessions = new ConcurrentHashMap<Long, Session>();
    private final long maxIdle;
    private final long maxUpdateIdle;
    private final List<Session> idleSessions = new ArrayList<Session>();
    private final Long expiredSessionMarker = -1L;
    private final AccumuloConfiguration aconf;

    public SessionManager(AccumuloConfiguration conf) {
        SecureRandom sr;
        this.aconf = conf;
        this.maxUpdateIdle = conf.getTimeInMillis(Property.TSERV_UPDATE_SESSION_MAXIDLE);
        this.maxIdle = conf.getTimeInMillis(Property.TSERV_SESSION_MAXIDLE);
        try {
            sr = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            log.debug("Unable to create SHA1PRNG secure random, using default");
            sr = new SecureRandom();
        }
        this.random = sr;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SessionManager.this.sweep(SessionManager.this.maxIdle, SessionManager.this.maxUpdateIdle);
            }
        };
        SimpleTimer.getInstance((AccumuloConfiguration)conf).schedule(r, 0L, Math.max(this.maxIdle / 2L, 1000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createSession(Session session, boolean reserve) {
        long sid = this.random.nextLong();
        Session session2 = session;
        synchronized (session2) {
            Preconditions.checkArgument((session.state == Session.State.NEW ? 1 : 0) != 0);
            session.state = reserve ? Session.State.RESERVED : Session.State.UNRESERVED;
            session.startTime = session.lastAccessTime = System.currentTimeMillis();
        }
        while (this.sessions.putIfAbsent(sid, session) != null) {
            sid = this.random.nextLong();
        }
        return sid;
    }

    public long getMaxIdleTime() {
        return this.maxIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session reserveSession(long sessionId) {
        Session session = (Session)this.sessions.get(sessionId);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                if (session.state == Session.State.RESERVED) {
                    throw new IllegalStateException("Attempted to reserved session that is already reserved " + sessionId);
                }
                if (session.state == Session.State.REMOVED) {
                    return null;
                }
                session.state = Session.State.RESERVED;
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session reserveSession(long sessionId, boolean wait) {
        Session session = (Session)this.sessions.get(sessionId);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                if (session.state == Session.State.REMOVED) {
                    return null;
                }
                while (wait && session.state == Session.State.RESERVED) {
                    try {
                        session.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException();
                    }
                }
                if (session.state == Session.State.RESERVED) {
                    throw new IllegalStateException("Attempted to reserved session that is already reserved " + sessionId);
                }
                if (session.state == Session.State.REMOVED) {
                    return null;
                }
                session.state = Session.State.RESERVED;
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unreserveSession(Session session) {
        Session session2 = session;
        synchronized (session2) {
            if (session.state == Session.State.REMOVED) {
                return;
            }
            if (session.state != Session.State.RESERVED) {
                throw new IllegalStateException("Cannon unreserve, state: " + (Object)((Object)session.state));
            }
            session.notifyAll();
            session.state = Session.State.UNRESERVED;
            session.lastAccessTime = System.currentTimeMillis();
        }
    }

    public void unreserveSession(long sessionId) {
        Session session = this.getSession(sessionId);
        if (session != null) {
            this.unreserveSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(long sessionId) {
        Session session = (Session)this.sessions.get(sessionId);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                if (session.state == Session.State.REMOVED) {
                    return null;
                }
                session.lastAccessTime = System.currentTimeMillis();
            }
        }
        return session;
    }

    public Session removeSession(long sessionId) {
        return this.removeSession(sessionId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session removeSession(long sessionId, boolean unreserve) {
        Session session = (Session)this.sessions.remove(sessionId);
        if (session != null) {
            boolean doCleanup = false;
            Session session2 = session;
            synchronized (session2) {
                if (session.state != Session.State.REMOVED) {
                    if (unreserve) {
                        this.unreserveSession(session);
                    }
                    doCleanup = true;
                    session.state = Session.State.REMOVED;
                }
            }
            if (doCleanup) {
                session.cleanup();
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweep(long maxIdle, long maxUpdateIdle) {
        ArrayList<Session> sessionsToCleanup = new ArrayList<Session>();
        Iterator iter = this.sessions.values().iterator();
        while (iter.hasNext()) {
            Session session;
            Session session2 = session = (Session)iter.next();
            synchronized (session2) {
                if (session.state == Session.State.UNRESERVED) {
                    long idleTime;
                    long configuredIdle = maxIdle;
                    if (session instanceof UpdateSession) {
                        configuredIdle = maxUpdateIdle;
                    }
                    if ((idleTime = System.currentTimeMillis() - session.lastAccessTime) > configuredIdle) {
                        log.info("Closing idle session from user=" + session.getUser() + ", client=" + session.client + ", idle=" + idleTime + "ms");
                        iter.remove();
                        sessionsToCleanup.add(session);
                        session.state = Session.State.REMOVED;
                    }
                }
            }
        }
        List<Session> list = this.idleSessions;
        synchronized (list) {
            sessionsToCleanup.addAll(this.idleSessions);
            this.idleSessions.clear();
        }
        for (Session session : sessionsToCleanup) {
            if (session.cleanup()) continue;
            List<Session> list2 = this.idleSessions;
            synchronized (list2) {
                this.idleSessions.add(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIfNotAccessed(final long sessionId, final long delay) {
        Session session = (Session)this.sessions.get(sessionId);
        if (session != null) {
            long tmp;
            Session session2 = session;
            synchronized (session2) {
                tmp = session.lastAccessTime;
            }
            final long removeTime = tmp;
            TimerTask r = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Session session2 = (Session)SessionManager.this.sessions.get(sessionId);
                    if (session2 != null) {
                        boolean shouldRemove = false;
                        Session session = session2;
                        synchronized (session) {
                            if (session2.lastAccessTime == removeTime && session2.state == Session.State.UNRESERVED) {
                                session2.state = Session.State.REMOVED;
                                shouldRemove = true;
                            }
                        }
                        if (shouldRemove) {
                            log.info("Closing not accessed session from user=" + session2.getUser() + ", client=" + session2.client + ", duration=" + delay + "ms");
                            SessionManager.this.sessions.remove(sessionId);
                            session2.cleanup();
                        }
                    }
                }
            };
            SimpleTimer.getInstance((AccumuloConfiguration)this.aconf).schedule((Runnable)r, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, MapCounter<ScanRunState>> getActiveScansPerTable() {
        HashMap<String, MapCounter<ScanRunState>> counts = new HashMap<String, MapCounter<ScanRunState>>();
        HashSet<Map.Entry> copiedIdleSessions = new HashSet<Map.Entry>();
        List<Session> list = this.idleSessions;
        synchronized (list) {
            for (Session session : this.idleSessions) {
                copiedIdleSessions.add(Maps.immutableEntry((Object)this.expiredSessionMarker, (Object)session));
            }
        }
        for (Map.Entry entry : Iterables.concat(this.sessions.entrySet(), copiedIdleSessions)) {
            ScanRunState srs;
            Session session;
            session = (Session)entry.getValue();
            ScanTask<ScanBatch> nbt = null;
            String tableID = null;
            if (session instanceof ScanSession) {
                ScanSession ss = (ScanSession)session;
                nbt = ss.nextBatchTask;
                tableID = ss.extent.getTableId();
            } else if (session instanceof MultiScanSession) {
                MultiScanSession mss = (MultiScanSession)session;
                nbt = mss.lookupTask;
                tableID = mss.threadPoolExtent.getTableId();
            }
            if (nbt == null || (srs = nbt.getScanRunState()) == ScanRunState.FINISHED) continue;
            MapCounter stateCounts = (MapCounter)counts.get(tableID);
            if (stateCounts == null) {
                stateCounts = new MapCounter();
                counts.put(tableID, (MapCounter<ScanRunState>)stateCounts);
            }
            stateCounts.increment((Object)srs, 1L);
        }
        return counts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActiveScan> getActiveScans() {
        ArrayList<ActiveScan> activeScans = new ArrayList<ActiveScan>();
        long ct = System.currentTimeMillis();
        HashSet<Map.Entry> copiedIdleSessions = new HashSet<Map.Entry>();
        List<Session> list = this.idleSessions;
        synchronized (list) {
            for (Session session : this.idleSessions) {
                copiedIdleSessions.add(Maps.immutableEntry((Object)this.expiredSessionMarker, (Object)session));
            }
        }
        for (Map.Entry entry : Iterables.concat(this.sessions.entrySet(), copiedIdleSessions)) {
            ScanTask<ScanBatch> nbt;
            ScanState state;
            Session session;
            session = (Session)entry.getValue();
            if (session instanceof ScanSession) {
                ScanSession ss = (ScanSession)session;
                state = ScanState.RUNNING;
                nbt = ss.nextBatchTask;
                if (nbt == null) {
                    state = ScanState.IDLE;
                } else {
                    switch (nbt.getScanRunState()) {
                        case QUEUED: {
                            state = ScanState.QUEUED;
                            break;
                        }
                        case FINISHED: {
                            state = ScanState.IDLE;
                            break;
                        }
                    }
                }
                ActiveScan activeScan = new ActiveScan(ss.client, ss.getUser(), ss.extent.getTableId(), ct - ss.startTime, ct - ss.lastAccessTime, ScanType.SINGLE, state, ss.extent.toThrift(), Translator.translate(ss.columnSet, (Translator)Translators.CT), ss.ssiList, ss.ssio, ss.auths.getAuthorizationsBB(), ss.context);
                activeScan.setScanId(((Long)entry.getKey()).longValue());
                activeScans.add(activeScan);
                continue;
            }
            if (!(session instanceof MultiScanSession)) continue;
            MultiScanSession mss = (MultiScanSession)session;
            state = ScanState.RUNNING;
            nbt = mss.lookupTask;
            if (nbt == null) {
                state = ScanState.IDLE;
            } else {
                switch (nbt.getScanRunState()) {
                    case QUEUED: {
                        state = ScanState.QUEUED;
                        break;
                    }
                    case FINISHED: {
                        state = ScanState.IDLE;
                        break;
                    }
                }
            }
            activeScans.add(new ActiveScan(mss.client, mss.getUser(), mss.threadPoolExtent.getTableId(), ct - mss.startTime, ct - mss.lastAccessTime, ScanType.BATCH, state, mss.threadPoolExtent.toThrift(), Translator.translate(mss.columnSet, (Translator)Translators.CT), mss.ssiList, mss.ssio, mss.auths.getAuthorizationsBB(), mss.context));
        }
        return activeScans;
    }
}

