/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.tablet.Tablet;

public class TabletServerMetricsUtil {
    private final TabletServer tserver;

    public TabletServerMetricsUtil(TabletServer tserver) {
        this.tserver = tserver;
    }

    public long getEntries() {
        long result = 0L;
        for (Tablet tablet : this.tserver.getOnlineTablets()) {
            result += tablet.getNumEntries();
        }
        return result;
    }

    public long getEntriesInMemory() {
        long result = 0L;
        for (Tablet tablet : this.tserver.getOnlineTablets()) {
            result += tablet.getNumEntriesInMemory();
        }
        return result;
    }

    public double getIngest() {
        double result = 0.0;
        for (Tablet tablet : this.tserver.getOnlineTablets()) {
            result += tablet.ingestRate();
        }
        return result;
    }

    public double getIngestByteRate() {
        double result = 0.0;
        for (Tablet tablet : this.tserver.getOnlineTablets()) {
            result += tablet.ingestByteRate();
        }
        return result;
    }

    public double getQueryRate() {
        double result = 0.0;
        for (Tablet tablet : this.tserver.getOnlineTablets()) {
            result += tablet.queryRate();
        }
        return result;
    }

    public double getQueryByteRate() {
        double result = 0.0;
        for (Tablet tablet : this.tserver.getOnlineTablets()) {
            result += tablet.queryByteRate();
        }
        return result;
    }

    public double getScannedRate() {
        double result = 0.0;
        for (Tablet tablet : this.tserver.getOnlineTablets()) {
            result += tablet.scanRate();
        }
        return result;
    }

    public int getMajorCompactions() {
        int result = 0;
        for (Tablet tablet : this.tserver.getOnlineTablets()) {
            if (!tablet.isMajorCompactionRunning()) continue;
            ++result;
        }
        return result;
    }

    public int getMajorCompactionsQueued() {
        int result = 0;
        for (Tablet tablet : this.tserver.getOnlineTablets()) {
            if (!tablet.isMajorCompactionQueued()) continue;
            ++result;
        }
        return result;
    }

    public int getMinorCompactions() {
        int result = 0;
        for (Tablet tablet : this.tserver.getOnlineTablets()) {
            if (!tablet.isMinorCompactionRunning()) continue;
            ++result;
        }
        return result;
    }

    public int getMinorCompactionsQueued() {
        int result = 0;
        for (Tablet tablet : this.tserver.getOnlineTablets()) {
            if (!tablet.isMinorCompactionQueued()) continue;
            ++result;
        }
        return result;
    }

    public int getOnlineCount() {
        return this.tserver.getOnlineTablets().size();
    }

    public int getOpeningCount() {
        return this.tserver.getOpeningCount();
    }

    public long getQueries() {
        long result = 0L;
        for (Tablet tablet : this.tserver.getOnlineTablets()) {
            result += tablet.totalQueries();
        }
        return result;
    }

    public int getUnopenedCount() {
        return this.tserver.getUnopenedCount();
    }

    public String getName() {
        return this.tserver.getClientAddressString();
    }

    public long getTotalMinorCompactions() {
        return this.tserver.getTotalMinorCompactions();
    }

    public double getHoldTime() {
        return this.tserver.getHoldTimeMillis() / 1000.0;
    }

    public double getAverageFilesPerTablet() {
        int count = 0;
        long result = 0L;
        for (Tablet tablet : this.tserver.getOnlineTablets()) {
            result += (long)tablet.getDatafiles().size();
            ++count;
        }
        if (count == 0) {
            return 0.0;
        }
        return (double)result / (double)count;
    }
}

