/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractResponse;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.AsyncProcessTask;
import org.apache.hadoop.hbase.client.AsyncRequestFuture;
import org.apache.hadoop.hbase.client.AsyncRequestFutureImpl;
import org.apache.hadoop.hbase.client.CancellableRegionServerCallable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.MultiServerCallable;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCallerImpl;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={ClientTests.class, SmallTests.class})
public class TestAsyncProcessWithRegionException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncProcessWithRegionException.class);
    private static final Result EMPTY_RESULT = Result.create(null, (Boolean)true);
    private static final IOException IOE = new IOException("YOU CAN'T PASS");
    private static final Configuration CONF = new Configuration();
    private static final TableName DUMMY_TABLE = TableName.valueOf((String)"DUMMY_TABLE");
    private static final byte[] GOOD_ROW = Bytes.toBytes((String)"GOOD_ROW");
    private static final byte[] BAD_ROW = Bytes.toBytes((String)"BAD_ROW");
    private static final byte[] BAD_ROW_WITHOUT_ACTION_EXCEPTION = Bytes.toBytes((String)"BAD_ROW_WITHOUT_ACTION_EXCEPTION");
    private static final byte[] FAMILY = Bytes.toBytes((String)"FAMILY");
    private static final ServerName SERVER_NAME = ServerName.valueOf((String)"s1,1,1");
    private static final RegionInfo REGION_INFO = RegionInfoBuilder.newBuilder((TableName)DUMMY_TABLE).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(1L).build();
    private static final HRegionLocation REGION_LOCATION = new HRegionLocation(REGION_INFO, SERVER_NAME);

    @BeforeClass
    public static void setUpBeforeClass() {
        CONF.setInt("hbase.client.retries.number", 0);
    }

    @Test
    public void testSuccessivePut() throws Exception {
        MyAsyncProcess ap = new MyAsyncProcess(TestAsyncProcessWithRegionException.createHConnection(), CONF);
        ArrayList<Put> puts = new ArrayList<Put>(1);
        puts.add(new Put(GOOD_ROW).addColumn(FAMILY, FAMILY, FAMILY));
        int expectedSize = puts.size();
        AsyncRequestFuture arf = ap.submit(DUMMY_TABLE, puts);
        arf.waitUntilDone();
        Object[] result = arf.getResults();
        Assert.assertEquals((long)expectedSize, (long)result.length);
        for (Object r : result) {
            Assert.assertEquals(Result.class, r.getClass());
        }
        Assert.assertTrue((boolean)puts.isEmpty());
        TestAsyncProcessWithRegionException.assertActionsInProgress(arf);
    }

    @Test
    public void testFailedPut() throws Exception {
        MyAsyncProcess ap = new MyAsyncProcess(TestAsyncProcessWithRegionException.createHConnection(), CONF);
        ArrayList<Put> puts = new ArrayList<Put>(2);
        puts.add(new Put(GOOD_ROW).addColumn(FAMILY, FAMILY, FAMILY));
        puts.add(new Put(BAD_ROW).addColumn(FAMILY, FAMILY, FAMILY));
        int expectedSize = puts.size();
        AsyncRequestFuture arf = ap.submit(DUMMY_TABLE, puts);
        arf.waitUntilDone();
        TestAsyncProcessWithRegionException.assertError(arf, 1);
        Object[] result = arf.getResults();
        Assert.assertEquals((long)expectedSize, (long)result.length);
        Assert.assertEquals(Result.class, result[0].getClass());
        Assert.assertTrue((boolean)(result[1] instanceof IOException));
        Assert.assertTrue((boolean)puts.isEmpty());
        TestAsyncProcessWithRegionException.assertActionsInProgress(arf);
    }

    @Test
    public void testFailedPutWithoutActionException() throws Exception {
        MyAsyncProcess ap = new MyAsyncProcess(TestAsyncProcessWithRegionException.createHConnection(), CONF);
        ArrayList<Put> puts = new ArrayList<Put>(3);
        puts.add(new Put(GOOD_ROW).addColumn(FAMILY, FAMILY, FAMILY));
        puts.add(new Put(BAD_ROW).addColumn(FAMILY, FAMILY, FAMILY));
        puts.add(new Put(BAD_ROW_WITHOUT_ACTION_EXCEPTION).addColumn(FAMILY, FAMILY, FAMILY));
        int expectedSize = puts.size();
        AsyncRequestFuture arf = ap.submit(DUMMY_TABLE, puts);
        arf.waitUntilDone();
        TestAsyncProcessWithRegionException.assertError(arf, 2);
        Object[] result = arf.getResults();
        Assert.assertEquals((long)expectedSize, (long)result.length);
        Assert.assertEquals(Result.class, result[0].getClass());
        Assert.assertTrue((boolean)(result[1] instanceof IOException));
        Assert.assertTrue((boolean)(result[2] instanceof IOException));
        Assert.assertTrue((boolean)puts.isEmpty());
        TestAsyncProcessWithRegionException.assertActionsInProgress(arf);
    }

    private static void assertError(AsyncRequestFuture arf, int expectedCountOfFailure) {
        Assert.assertTrue((boolean)arf.hasError());
        RetriesExhaustedWithDetailsException e = arf.getErrors();
        List errors = e.getCauses();
        Assert.assertEquals((long)expectedCountOfFailure, (long)errors.size());
        for (Throwable t : errors) {
            Assert.assertTrue((boolean)(t instanceof IOException));
        }
    }

    private static void assertActionsInProgress(AsyncRequestFuture arf) {
        if (arf instanceof AsyncRequestFutureImpl) {
            Assert.assertEquals((long)0L, (long)((AsyncRequestFutureImpl)arf).getNumberOfActionsInProgress());
        }
    }

    private static ClusterConnection createHConnection() throws IOException {
        ClusterConnection hc = (ClusterConnection)Mockito.mock(ClusterConnection.class);
        NonceGenerator ng = (NonceGenerator)Mockito.mock(NonceGenerator.class);
        Mockito.when((Object)ng.getNonceGroup()).thenReturn((Object)0L);
        Mockito.when((Object)hc.getNonceGenerator()).thenReturn((Object)ng);
        Mockito.when((Object)hc.getConfiguration()).thenReturn((Object)CONF);
        Mockito.when((Object)hc.getConnectionConfiguration()).thenReturn((Object)new ConnectionConfiguration(CONF));
        TestAsyncProcessWithRegionException.setMockLocation(hc, GOOD_ROW, new RegionLocations(new HRegionLocation[]{REGION_LOCATION}));
        TestAsyncProcessWithRegionException.setMockLocation(hc, BAD_ROW, new RegionLocations(new HRegionLocation[]{REGION_LOCATION}));
        Mockito.when((Object)hc.locateRegions((TableName)Mockito.eq((Object)DUMMY_TABLE), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn(Collections.singletonList(REGION_LOCATION));
        return hc;
    }

    private static void setMockLocation(ClusterConnection hc, byte[] row, RegionLocations result) throws IOException {
        Mockito.when((Object)hc.locateRegion((TableName)Mockito.eq((Object)DUMMY_TABLE), (byte[])Mockito.eq((Object)row), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyInt())).thenReturn((Object)result);
        Mockito.when((Object)hc.locateRegion((TableName)Mockito.eq((Object)DUMMY_TABLE), (byte[])Mockito.eq((Object)row), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)result);
    }

    private static class MyAsyncProcess
    extends AsyncProcess {
        private final ExecutorService service = Executors.newFixedThreadPool(5);

        MyAsyncProcess(ClusterConnection hc, Configuration conf) {
            super(hc, conf, new RpcRetryingCallerFactory(conf), new RpcControllerFactory(conf));
        }

        public AsyncRequestFuture submit(TableName tableName, List<? extends Row> rows) throws InterruptedIOException {
            return this.submit(AsyncProcessTask.newBuilder().setPool(this.service).setTableName(tableName).setRowAccess(rows).setSubmittedRows(AsyncProcessTask.SubmittedRows.NORMAL).setNeedResults(true).setRpcTimeout(60000).setOperationTimeout(1200000).build());
        }

        protected RpcRetryingCaller<AbstractResponse> createCaller(CancellableRegionServerCallable callable, int rpcTimeout) {
            MultiServerCallable callable1 = (MultiServerCallable)callable;
            final MultiResponse mr = new MultiResponse();
            callable1.getMulti().actions.forEach((regionName, actions) -> actions.forEach(action -> {
                if (Bytes.equals((byte[])action.getAction().getRow(), (byte[])GOOD_ROW)) {
                    mr.add(regionName, action.getOriginalIndex(), (Object)EMPTY_RESULT);
                } else if (Bytes.equals((byte[])action.getAction().getRow(), (byte[])BAD_ROW)) {
                    mr.add(regionName, action.getOriginalIndex(), (Object)IOE);
                }
            }));
            mr.addException(REGION_INFO.getRegionName(), (Throwable)IOE);
            return new RpcRetryingCallerImpl<AbstractResponse>(100L, 500L, 0, 9){

                public AbstractResponse callWithoutRetries(RetryingCallable<AbstractResponse> callable, int callTimeout) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return mr;
                }
            };
        }
    }
}

