/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.io.hfile.TestHFileBlock;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RedundantKVGenerator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, SmallTests.class})
public class TestHFileEncryption {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileEncryption.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHFileEncryption.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static FileSystem fs;
    private static Encryption.Context cryptoContext;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setFloat("hfile.block.cache.size", 0.0f);
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.master.key.name", "hbase");
        conf.setInt("hfile.format.version", 3);
        fs = FileSystem.get((Configuration)conf);
        cryptoContext = Encryption.newContext((Configuration)conf);
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        Cipher aes = Encryption.getCipher((Configuration)conf, (String)algorithm);
        Assert.assertNotNull((Object)aes);
        cryptoContext.setCipher(aes);
        byte[] key = new byte[aes.getKeyLength()];
        Bytes.secureRandom((byte[])key);
        cryptoContext.setKey(key);
    }

    private int writeBlock(FSDataOutputStream os, HFileContext fileContext, int size) throws IOException {
        HFileBlock.Writer hbw = new HFileBlock.Writer(null, fileContext);
        DataOutputStream dos = hbw.startWriting(BlockType.DATA);
        for (int j = 0; j < size; ++j) {
            dos.writeInt(j);
        }
        hbw.writeHeaderAndData(os);
        LOG.info("Wrote a block at " + os.getPos() + " with onDiskSizeWithHeader=" + hbw.getOnDiskSizeWithHeader() + " uncompressedSizeWithoutHeader=" + hbw.getOnDiskSizeWithoutHeader() + " uncompressedSizeWithoutHeader=" + hbw.getUncompressedSizeWithoutHeader());
        return hbw.getOnDiskSizeWithHeader();
    }

    private long readAndVerifyBlock(long pos, HFileContext ctx, HFileBlock.FSReaderImpl hbr, int size) throws IOException {
        HFileBlock b = hbr.readBlockData(pos, -1L, false, false, true);
        Assert.assertEquals((long)0L, (long)HFile.getAndResetChecksumFailuresCount());
        b.sanityCheck();
        Assert.assertFalse((boolean)b.isUnpacked());
        b = b.unpack(ctx, (HFileBlock.FSReader)hbr);
        LOG.info("Read a block at " + pos + " with onDiskSizeWithHeader=" + b.getOnDiskSizeWithHeader() + " uncompressedSizeWithoutHeader=" + b.getOnDiskSizeWithoutHeader() + " uncompressedSizeWithoutHeader=" + b.getUncompressedSizeWithoutHeader());
        DataInputStream dis = b.getByteStream();
        for (int i = 0; i < size; ++i) {
            int read = dis.readInt();
            if (read == i) continue;
            Assert.fail((String)("Block data corrupt at element " + i));
        }
        return b.getOnDiskSizeWithHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataBlockEncryption() throws IOException {
        int blocks = 10;
        int[] blockSizes = new int[10];
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < 10; ++i) {
            blockSizes[i] = (1024 + ((Random)rand).nextInt(64512)) / 4;
        }
        for (Compression.Algorithm compression : TestHFileBlock.COMPRESSION_ALGORITHMS) {
            Path path = new Path(TEST_UTIL.getDataTestDir(), "block_v3_" + compression + "_AES");
            LOG.info("testDataBlockEncryption: encryption=AES compression=" + compression);
            long totalSize = 0L;
            HFileContext fileContext = new HFileContextBuilder().withCompression(compression).withEncryptionContext(cryptoContext).build();
            try (FSDataOutputStream os = fs.create(path);){
                for (int i = 0; i < 10; ++i) {
                    totalSize += (long)this.writeBlock(os, fileContext, blockSizes[i]);
                }
            }
            FSDataInputStream is = fs.open(path);
            ReaderContext context = new ReaderContextBuilder().withInputStreamWrapper(new FSDataInputStreamWrapper(is)).withFilePath(path).withFileSystem(fs).withFileSize(totalSize).build();
            try {
                HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(context, fileContext, ByteBuffAllocator.HEAP);
                long pos = 0L;
                for (int i = 0; i < 10; ++i) {
                    pos += this.readAndVerifyBlock(pos, fileContext, hbr, blockSizes[i]);
                }
            }
            finally {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHFileEncryptionMetadata() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        CacheConfig cacheConf = new CacheConfig(conf);
        HFileContext fileContext = new HFileContextBuilder().withEncryptionContext(cryptoContext).build();
        Path path = new Path(TEST_UTIL.getDataTestDir(), "cryptometa.hfile");
        FSDataOutputStream out = fs.create(path);
        HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withOutputStream(out).withFileContext(fileContext).create();
        try {
            KeyValue kv = new KeyValue("foo".getBytes(), "f1".getBytes(), null, "value".getBytes());
            writer.append((Cell)kv);
        }
        finally {
            writer.close();
            out.close();
        }
        try (HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)path, (CacheConfig)cacheConf, (boolean)true, (Configuration)conf);){
            FixedFileTrailer trailer = reader.getTrailer();
            Assert.assertNotNull((Object)trailer.getEncryptionKey());
            Encryption.Context readerContext = reader.getFileContext().getEncryptionContext();
            Assert.assertEquals((Object)readerContext.getCipher().getName(), (Object)cryptoContext.getCipher().getName());
            Assert.assertTrue((boolean)Bytes.equals((byte[])readerContext.getKeyBytes(), (byte[])cryptoContext.getKeyBytes()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHFileEncryption() throws Exception {
        RedundantKVGenerator generator = new RedundantKVGenerator();
        List testKvs = generator.generateTestKeyValues(1000);
        Configuration conf = TEST_UTIL.getConfiguration();
        CacheConfig cacheConf = new CacheConfig(conf);
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            for (Compression.Algorithm compression : TestHFileBlock.COMPRESSION_ALGORITHMS) {
                Cell kv;
                HFileContext fileContext = new HFileContextBuilder().withBlockSize(4096).withEncryptionContext(cryptoContext).withCompression(compression).withDataBlockEncoding(encoding).build();
                LOG.info("Writing with " + fileContext);
                Path path = new Path(TEST_UTIL.getDataTestDir(), TEST_UTIL.getRandomUUID().toString() + ".hfile");
                FSDataOutputStream out = fs.create(path);
                HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withOutputStream(out).withFileContext(fileContext).create();
                try {
                    for (KeyValue kv2 : testKvs) {
                        writer.append((Cell)kv2);
                    }
                }
                finally {
                    writer.close();
                    out.close();
                }
                LOG.info("Reading with " + fileContext);
                int i = 0;
                HFileScanner scanner = null;
                HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)path, (CacheConfig)cacheConf, (boolean)true, (Configuration)conf);
                try {
                    FixedFileTrailer trailer = reader.getTrailer();
                    Assert.assertNotNull((Object)trailer.getEncryptionKey());
                    scanner = reader.getScanner(false, false);
                    Assert.assertTrue((String)"Initial seekTo failed", (boolean)scanner.seekTo());
                    do {
                        kv = scanner.getCell();
                        Assert.assertTrue((String)"Read back an unexpected or invalid KV", (boolean)testKvs.contains(KeyValueUtil.ensureKeyValue((Cell)kv)));
                        ++i;
                    } while (scanner.next());
                }
                finally {
                    reader.close();
                    scanner.close();
                }
                Assert.assertEquals((String)"Did not read back as many KVs as written", (long)i, (long)testKvs.size());
                LOG.info("Random seeking with " + fileContext);
                ThreadLocalRandom rand = ThreadLocalRandom.current();
                reader = HFile.createReader((FileSystem)fs, (Path)path, (CacheConfig)cacheConf, (boolean)true, (Configuration)conf);
                try {
                    scanner = reader.getScanner(false, true);
                    Assert.assertTrue((String)"Initial seekTo failed", (boolean)scanner.seekTo());
                    for (i = 0; i < 100; ++i) {
                        kv = (KeyValue)testKvs.get(((Random)rand).nextInt(testKvs.size()));
                        Assert.assertEquals((String)("Unable to find KV as expected: " + kv), (long)0L, (long)scanner.seekTo(kv));
                    }
                }
                finally {
                    scanner.close();
                    reader.close();
                }
            }
        }
    }
}

