/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.zookeeper;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.TransactionWatcher;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;

public class TransactionWatcher
extends org.apache.accumulo.fate.zookeeper.TransactionWatcher {
    public TransactionWatcher() {
        super((TransactionWatcher.Arbitrator)new ZooArbitrator());
    }

    public static class ZooArbitrator
    implements TransactionWatcher.Arbitrator {
        Instance instance = HdfsZooInstance.getInstance();
        ZooReader rdr = new ZooReader(this.instance.getZooKeepers(), this.instance.getZooKeepersSessionTimeOut());

        public boolean transactionAlive(String type, long tid) throws Exception {
            String path = ZooUtil.getRoot((Instance)this.instance) + "/" + type + "/" + tid;
            this.rdr.sync(path);
            return this.rdr.exists(path);
        }

        public static void start(String type, long tid) throws KeeperException, InterruptedException {
            Instance instance = HdfsZooInstance.getInstance();
            ZooReaderWriter writer = ZooReaderWriter.getInstance();
            writer.putPersistentData(ZooUtil.getRoot((Instance)instance) + "/" + type, new byte[0], ZooUtil.NodeExistsPolicy.OVERWRITE);
            writer.putPersistentData(ZooUtil.getRoot((Instance)instance) + "/" + type + "/" + tid, new byte[0], ZooUtil.NodeExistsPolicy.OVERWRITE);
            writer.putPersistentData(ZooUtil.getRoot((Instance)instance) + "/" + type + "/" + tid + "-running", new byte[0], ZooUtil.NodeExistsPolicy.OVERWRITE);
        }

        public static void stop(String type, long tid) throws KeeperException, InterruptedException {
            Instance instance = HdfsZooInstance.getInstance();
            ZooReaderWriter writer = ZooReaderWriter.getInstance();
            writer.recursiveDelete(ZooUtil.getRoot((Instance)instance) + "/" + type + "/" + tid, ZooUtil.NodeMissingPolicy.SKIP);
        }

        public static void cleanup(String type, long tid) throws KeeperException, InterruptedException {
            Instance instance = HdfsZooInstance.getInstance();
            ZooReaderWriter writer = ZooReaderWriter.getInstance();
            writer.recursiveDelete(ZooUtil.getRoot((Instance)instance) + "/" + type + "/" + tid, ZooUtil.NodeMissingPolicy.SKIP);
            writer.recursiveDelete(ZooUtil.getRoot((Instance)instance) + "/" + type + "/" + tid + "-running", ZooUtil.NodeMissingPolicy.SKIP);
        }

        public static Set<Long> allTransactionsAlive(String type) throws KeeperException, InterruptedException {
            Instance instance = HdfsZooInstance.getInstance();
            ZooReaderWriter reader = ZooReaderWriter.getInstance();
            HashSet<Long> result = new HashSet<Long>();
            String parent = ZooUtil.getRoot((Instance)instance) + "/" + type;
            reader.sync(parent);
            List children = reader.getChildren(parent);
            for (String child : children) {
                if (child.endsWith("-running")) continue;
                result.add(Long.parseLong(child));
            }
            return result;
        }

        public boolean transactionComplete(String type, long tid) throws Exception {
            String path = ZooUtil.getRoot((Instance)this.instance) + "/" + type + "/" + tid + "-running";
            this.rdr.sync(path);
            return !this.rdr.exists(path);
        }
    }
}

