/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.state;

import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.master.state.MergeState;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeStats {
    private static final Logger log = LoggerFactory.getLogger(MergeStats.class);
    private final MergeInfo info;
    private int hosted = 0;
    private int unassigned = 0;
    private int chopped = 0;
    private int needsToBeChopped = 0;
    private int total = 0;
    private boolean lowerSplit = false;
    private boolean upperSplit = false;

    public MergeStats(MergeInfo info) {
        this.info = info;
        if (info.getState().equals((Object)MergeState.NONE)) {
            return;
        }
        if (info.getExtent().getEndRow() == null) {
            this.upperSplit = true;
        }
        if (info.getExtent().getPrevEndRow() == null) {
            this.lowerSplit = true;
        }
    }

    public MergeInfo getMergeInfo() {
        return this.info;
    }

    public void update(KeyExtent ke, TabletState state, boolean chopped, boolean hasWALs) {
        if (this.info.getState().equals((Object)MergeState.NONE)) {
            return;
        }
        if (!this.upperSplit && this.info.getExtent().getEndRow().equals((Object)ke.getPrevEndRow())) {
            log.info("Upper split found: {}", (Object)ke.getPrevEndRow());
            this.upperSplit = true;
        }
        if (!this.lowerSplit && this.info.getExtent().getPrevEndRow().equals((Object)ke.getEndRow())) {
            log.info("Lower split found: {}", (Object)ke.getEndRow());
            this.lowerSplit = true;
        }
        if (!this.info.overlaps(ke)) {
            return;
        }
        if (this.info.needsToBeChopped(ke)) {
            ++this.needsToBeChopped;
            if (chopped) {
                if (state.equals((Object)TabletState.HOSTED)) {
                    ++this.chopped;
                } else if (!hasWALs) {
                    ++this.chopped;
                }
            }
        }
        ++this.total;
        if (state.equals((Object)TabletState.HOSTED)) {
            ++this.hosted;
        }
        if (state.equals((Object)TabletState.UNASSIGNED) || state.equals((Object)TabletState.SUSPENDED)) {
            ++this.unassigned;
        }
    }

    public MergeState nextMergeState(Connector connector, CurrentState master) throws Exception {
        MergeState state = this.info.getState();
        if (state == MergeState.NONE) {
            return state;
        }
        if (this.total == 0) {
            log.trace("failed to see any tablets for this range, ignoring {}", (Object)this.info.getExtent());
            return state;
        }
        log.info("Computing next merge state for {} which is presently {} isDelete : {}", new Object[]{this.info.getExtent(), state, this.info.isDelete()});
        if (state == MergeState.STARTED) {
            state = MergeState.SPLITTING;
        }
        if (state == MergeState.SPLITTING) {
            log.info("{} are hosted, total {}", (Object)this.hosted, (Object)this.total);
            if (!this.info.isDelete() && this.total == 1) {
                log.info("Merge range is already contained in a single tablet {}", (Object)this.info.getExtent());
                state = MergeState.COMPLETE;
            } else if (this.hosted == this.total) {
                if (this.info.isDelete()) {
                    if (!this.lowerSplit) {
                        log.info("Waiting for {} lower split to occur {}", (Object)this.info, (Object)this.info.getExtent());
                    } else if (!this.upperSplit) {
                        log.info("Waiting for {} upper split to occur {}", (Object)this.info, (Object)this.info.getExtent());
                    } else {
                        state = MergeState.WAITING_FOR_CHOPPED;
                    }
                } else {
                    state = MergeState.WAITING_FOR_CHOPPED;
                }
            } else {
                log.info("Waiting for {} hosted tablets to be {} {}", new Object[]{this.hosted, this.total, this.info.getExtent()});
            }
        }
        if (state == MergeState.WAITING_FOR_CHOPPED) {
            log.info("{} tablets are chopped {}", (Object)this.chopped, (Object)this.info.getExtent());
            if (this.chopped == this.needsToBeChopped) {
                state = MergeState.WAITING_FOR_OFFLINE;
            } else {
                log.info("Waiting for {} chopped tablets to be {} {}", new Object[]{this.chopped, this.needsToBeChopped, this.info.getExtent()});
            }
        }
        if (state == MergeState.WAITING_FOR_OFFLINE) {
            if (this.chopped != this.needsToBeChopped) {
                log.warn("Unexpected state: chopped tablets should be {} was {} merge {}", new Object[]{this.needsToBeChopped, this.chopped, this.info.getExtent()});
                state = MergeState.WAITING_FOR_CHOPPED;
            } else {
                log.info("{} tablets are chopped, {} are offline {}", new Object[]{this.chopped, this.unassigned, this.info.getExtent()});
                if (this.unassigned == this.total && this.chopped == this.needsToBeChopped) {
                    if (this.verifyMergeConsistency(connector, master)) {
                        state = MergeState.MERGING;
                    } else {
                        log.info("Merge consistency check failed {}", (Object)this.info.getExtent());
                    }
                } else {
                    log.info("Waiting for {} unassigned tablets to be {} {}", new Object[]{this.unassigned, this.total, this.info.getExtent()});
                }
            }
        }
        if (state == MergeState.MERGING) {
            if (this.hosted != 0) {
                log.error("Unexpected state: hosted tablets should be zero {} merge {}", (Object)this.hosted, (Object)this.info.getExtent());
                state = MergeState.WAITING_FOR_OFFLINE;
            }
            if (this.unassigned != this.total) {
                log.error("Unexpected state: unassigned tablets should be {} was {} merge {}", new Object[]{this.total, this.unassigned, this.info.getExtent()});
                state = MergeState.WAITING_FOR_CHOPPED;
            }
            log.info("{} tablets are unassigned {}", (Object)this.unassigned, (Object)this.info.getExtent());
        }
        return state;
    }

    private boolean verifyMergeConsistency(Connector connector, CurrentState master) throws TableNotFoundException, IOException {
        MergeStats verify = new MergeStats(this.info);
        KeyExtent extent = this.info.getExtent();
        Scanner scanner = connector.createScanner(extent.isMeta() ? "accumulo.root" : "accumulo.metadata", Authorizations.EMPTY);
        MetaDataTableScanner.configureScanner((ScannerBase)scanner, (CurrentState)master);
        Text start = extent.getPrevEndRow();
        if (start == null) {
            start = new Text();
        }
        String tableId = extent.getTableId();
        Text first = KeyExtent.getMetadataEntry((String)tableId, (Text)start);
        Range range = new Range(first, false, null, true);
        scanner.setRange(range.clip(MetadataSchema.TabletsSection.getRange()));
        KeyExtent prevExtent = null;
        log.debug("Scanning range {}", (Object)range);
        for (Map.Entry entry : scanner) {
            TabletLocationState tls;
            try {
                tls = MetaDataTableScanner.createTabletLocationState((Key)((Key)entry.getKey()), (Value)((Value)entry.getValue()));
            }
            catch (TabletLocationState.BadLocationStateException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                return false;
            }
            log.debug("consistency check: {} walogs {}", (Object)tls, (Object)tls.walogs.size());
            if (!tls.extent.getTableId().equals(tableId)) break;
            if (!tls.walogs.isEmpty() && verify.getMergeInfo().needsToBeChopped(tls.extent)) {
                log.debug("failing consistency: needs to be chopped {}", (Object)tls.extent);
                return false;
            }
            if (prevExtent == null) {
                if (tls.extent.getPrevEndRow() != null && tls.extent.getPrevEndRow().compareTo((BinaryComparable)start) > 0) {
                    log.debug("failing consistency: prev row is too high {}", (Object)start);
                    return false;
                }
                if (tls.getState(master.onlineTabletServers()) != TabletState.UNASSIGNED && tls.getState(master.onlineTabletServers()) != TabletState.SUSPENDED) {
                    log.debug("failing consistency: assigned or hosted {}", (Object)tls);
                    return false;
                }
            } else if (!tls.extent.isPreviousExtent(prevExtent)) {
                log.debug("hole in {}", (Object)"accumulo.metadata");
                return false;
            }
            prevExtent = tls.extent;
            verify.update(tls.extent, tls.getState(master.onlineTabletServers()), tls.chopped, !tls.walogs.isEmpty());
            if (tls.extent.getPrevEndRow() == null || extent.getEndRow() == null || tls.extent.getPrevEndRow().compareTo((BinaryComparable)extent.getEndRow()) <= 0) continue;
            break;
        }
        log.debug("chopped {} v.chopped {} unassigned {} v.unassigned {} verify.total {}", new Object[]{this.chopped, verify.chopped, this.unassigned, verify.unassigned, verify.total});
        return this.chopped == verify.chopped && this.unassigned == verify.unassigned && this.unassigned == verify.total;
    }

    public static void main(String[] args) throws Exception {
        ClientOpts opts = new ClientOpts();
        opts.parseArgs(MergeStats.class.getName(), args, new Object[0]);
        Connector conn = opts.getConnector();
        Map tableIdMap = conn.tableOperations().tableIdMap();
        for (Map.Entry entry : tableIdMap.entrySet()) {
            String table = (String)entry.getKey();
            String tableId = (String)entry.getValue();
            String path = ZooUtil.getRoot((String)conn.getInstance().getInstanceID()) + "/tables" + "/" + tableId + "/merge";
            MergeInfo info = new MergeInfo();
            if (ZooReaderWriter.getInstance().exists(path)) {
                byte[] data = ZooReaderWriter.getInstance().getData(path, new Stat());
                DataInputBuffer in = new DataInputBuffer();
                in.reset(data, data.length);
                info.readFields((DataInput)in);
            }
            System.out.println(String.format("%25s  %10s %10s %s", table, info.getState(), info.getOperation(), info.getExtent()));
        }
    }
}

