/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.spark.TaskContext$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockInfo;
import org.apache.spark.storage.BlockInfo$;
import org.apache.spark.storage.BlockInfoWrapper;
import org.slf4j.Logger;
import org.sparkproject.guava.collect.ConcurrentHashMultiset;
import org.sparkproject.guava.collect.ImmutableMultiset;
import org.sparkproject.guava.collect.Multiset;
import org.sparkproject.guava.util.concurrent.Striped;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Iterable$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh!B\u000f\u001f\u0001y1\u0003\"B\u001a\u0001\t\u0003)T\u0001\u0002\u001d\u0001\teBa\u0001\u0010\u0001!\u0002\u0013i\u0004BB'\u0001A\u0003%a\n\u0003\u0004`\u0001\u0001\u0006I\u0001\u0019\u0005\u0007O\u0002\u0001\u000b\u0011\u00025\t\u000b=\u0004A\u0011\u00019\t\u000bY\u0004A\u0011B<\t\u000ba\u0004A\u0011B=\t\u000f\u0005m\u0001\u0001\"\u0003\u0002\u001e!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003\"CA)\u0001E\u0005I\u0011AA*\u0011\u001d\tI\u0007\u0001C\u0001\u0003WB\u0011\"!\u001d\u0001#\u0003%\t!a\u0015\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v!A\u0011\u0011\u0010\u0001\u0005\u0002y\tY\bC\u0004\u0002\u0000\u0001!\t!!!\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\"I\u0011\u0011\u0013\u0001\u0012\u0002\u0013\u0005\u00111\u0013\u0005\b\u0003/\u0003A\u0011AAM\u0011%\t)\u000bAI\u0001\n\u0003\t\u0019\u0006C\u0004\u0002(\u0002!\t!!+\t\u0011\u0005\u0015\u0007\u0001\"\u0001\u001f\u0003\u000fDq!!5\u0001\t\u0003\t\u0019\u000e\u0003\u0005\u0002V\u0002!\tAHAl\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!!;\u0001\t\u0003\tY\u000fC\u0004\u0002p\u0002!\t!!=\u0003!\tcwnY6J]\u001a|W*\u00198bO\u0016\u0014(BA\u0010!\u0003\u001d\u0019Ho\u001c:bO\u0016T!!\t\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\r\"\u0013AB1qC\u000eDWMC\u0001&\u0003\ry'oZ\n\u0004\u0001\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g\r\u0005\u0002/c5\tqF\u0003\u00021A\u0005A\u0011N\u001c;fe:\fG.\u0003\u00023_\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003Y\u0002\"a\u000e\u0001\u000e\u0003y\u0011Q\u0002V1tW\u0006#H/Z7qi&#\u0007C\u0001\u0015;\u0013\tY\u0014F\u0001\u0003M_:<\u0017!\u00052m_\u000e\\\u0017J\u001c4p/J\f\u0007\u000f]3sgB!a(R$K\u001b\u0005y$B\u0001!B\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u0005\u000e\u000bA!\u001e;jY*\tA)\u0001\u0003kCZ\f\u0017B\u0001$@\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003o!K!!\u0013\u0010\u0003\u000f\tcwnY6JIB\u0011qgS\u0005\u0003\u0019z\u0011\u0001C\u00117pG.LeNZ8Xe\u0006\u0004\b/\u001a:\u0002\u000b1|7m[:\u0011\u0007=C&,D\u0001Q\u0015\t\u0001\u0015K\u0003\u0002C%*\u00111\u000bV\u0001\u0007G>lWn\u001c8\u000b\u0005U3\u0016AB4p_\u001edWMC\u0001X\u0003\r\u0019w.\\\u0005\u00033B\u0013qa\u0015;sSB,G\r\u0005\u0002\\;6\tAL\u0003\u0002N\u007f%\u0011a\f\u0018\u0002\u0005\u0019>\u001c7.\u0001\txe&$X\rT8dWN\u0014\u0015\u0010V1tWB!a(R1d!\t\u0011'!D\u0001\u0001!\r!WmR\u0007\u0002\u0003&\u0011a-\u0011\u0002\u0004'\u0016$\u0018a\u0004:fC\u0012dunY6t\u0005f$\u0016m]6\u0011\ty*\u0015-\u001b\t\u0004U6<U\"A6\u000b\u00051\u0014\u0016aB2pY2,7\r^\u0005\u0003].\u0014acQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T;mi&\u001cX\r^\u0001\re\u0016<\u0017n\u001d;feR\u000b7o\u001b\u000b\u0003cR\u0004\"\u0001\u000b:\n\u0005ML#\u0001B+oSRDQ!^\u0004A\u0002\u0005\fQ\u0002^1tW\u0006#H/Z7qi&#\u0017\u0001F2veJ,g\u000e\u001e+bg.\fE\u000f^3naRLE-F\u0001b\u0003-\t7-];je\u0016dunY6\u0015\u000bi\f\u0019\"a\u0006\u0015\u0007m\f\u0019\u0001E\u0002)yzL!!`\u0015\u0003\r=\u0003H/[8o!\t9t0C\u0002\u0002\u0002y\u0011\u0011B\u00117pG.LeNZ8\t\u000f\u0005\u0015\u0011\u00021\u0001\u0002\b\u0005\ta\r\u0005\u0004)\u0003\u0013q\u0018QB\u0005\u0004\u0003\u0017I#!\u0003$v]\u000e$\u0018n\u001c82!\rA\u0013qB\u0005\u0004\u0003#I#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003+I\u0001\u0019A$\u0002\u000f\tdwnY6JI\"9\u0011\u0011D\u0005A\u0002\u00055\u0011\u0001\u00032m_\u000e\\\u0017N\\4\u0002\u0013\tdwnY6J]\u001a|W\u0003BA\u0010\u0003O!B!!\t\u0002HQ!\u00111EA\u001d!\u0011\t)#a\n\r\u0001\u00119\u0011\u0011\u0006\u0006C\u0002\u0005-\"!\u0001+\u0012\t\u00055\u00121\u0007\t\u0004Q\u0005=\u0012bAA\u0019S\t9aj\u001c;iS:<\u0007c\u0001\u0015\u00026%\u0019\u0011qG\u0015\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0006)\u0001\r!a\u000f\u0011\u0011!\niD`A!\u0003GI1!a\u0010*\u0005%1UO\\2uS>t'\u0007E\u0002\\\u0003\u0007J1!!\u0012]\u0005%\u0019uN\u001c3ji&|g\u000e\u0003\u0004\u0002\u0016)\u0001\raR\u0001\u000fY>\u001c7NR8s%\u0016\fG-\u001b8h)\u0015Y\u0018QJA(\u0011\u0019\t)b\u0003a\u0001\u000f\"I\u0011\u0011D\u0006\u0011\u0002\u0003\u0007\u0011QB\u0001\u0019Y>\u001c7NR8s%\u0016\fG-\u001b8hI\u0011,g-Y;mi\u0012\u0012TCAA+U\u0011\ti!a\u0016,\u0005\u0005e\u0003\u0003BA.\u0003Kj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0019*\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\niFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa\u0002\\8dW\u001a{'o\u0016:ji&tw\rF\u0003|\u0003[\ny\u0007\u0003\u0004\u0002\u00165\u0001\ra\u0012\u0005\n\u00033i\u0001\u0013!a\u0001\u0003\u001b\t\u0001\u0004\\8dW\u001a{'o\u0016:ji&tw\r\n3fM\u0006,H\u000e\u001e\u00133\u0003u\t7o]3si\ncwnY6Jg2{7m[3e\r>\u0014xK]5uS:<Gc\u0001@\u0002x!1\u0011QC\bA\u0002\u001d\u000b1aZ3u)\rY\u0018Q\u0010\u0005\u0007\u0003+\u0001\u0002\u0019A$\u0002\u001b\u0011|wO\\4sC\u0012,Gj\\2l)\r\t\u00181\u0011\u0005\u0007\u0003+\t\u0002\u0019A$\u0002\rUtGn\\2l)\u0015\t\u0018\u0011RAF\u0011\u0019\t)B\u0005a\u0001\u000f\"I\u0011Q\u0012\n\u0011\u0002\u0003\u0007\u0011qR\u0001\u0014i\u0006\u001c8.\u0011;uK6\u0004H/\u00133PaRLwN\u001c\t\u0004Qq\f\u0017\u0001E;oY>\u001c7\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\t)J\u000b\u0003\u0002\u0010\u0006]\u0013A\u00067pG.tUm\u001e\"m_\u000e\\gi\u001c:Xe&$\u0018N\\4\u0015\u0011\u00055\u00111TAO\u0003CCa!!\u0006\u0015\u0001\u00049\u0005BBAP)\u0001\u0007a0\u0001\u0007oK^\u0014En\\2l\u0013:4w\u000eC\u0005\u0002$R\u0001\n\u00111\u0001\u0002\u000e\u0005a1.Z3q%\u0016\fG\rT8dW\u0006\u0001Cn\\2l\u001d\u0016<(\t\\8dW\u001a{'o\u0016:ji&tw\r\n3fM\u0006,H\u000e\u001e\u00134\u0003Y\u0011X\r\\3bg\u0016\fE\u000e\u001c'pG.\u001chi\u001c:UCN\\G\u0003BAV\u0003\u0007\u0004R!!,\u0002>\u001esA!a,\u0002::!\u0011\u0011WA\\\u001b\t\t\u0019LC\u0002\u00026R\na\u0001\u0010:p_Rt\u0014\"\u0001\u0016\n\u0007\u0005m\u0016&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0016\u0011\u0019\u0002\u0004'\u0016\f(bAA^S!)QO\u0006a\u0001C\u0006\u0001r-\u001a;UCN\\Gj\\2l\u0007>,h\u000e\u001e\u000b\u0005\u0003\u0013\fy\rE\u0002)\u0003\u0017L1!!4*\u0005\rIe\u000e\u001e\u0005\u0006k^\u0001\r!Y\u0001\u0005g&TX-\u0006\u0002\u0002J\u0006)r-\u001a;Ok6\u0014WM](g\u001b\u0006\u0004XI\u001c;sS\u0016\u001cX#A\u001d\u0002\u000f\u0015tGO]5fgV\u0011\u0011Q\u001c\t\u0007\u0003[\u000by.a9\n\t\u0005\u0005\u0018\u0011\u0019\u0002\t\u0013R,'/\u0019;peB)\u0001&!:H}&\u0019\u0011q]\u0015\u0003\rQ+\b\u000f\\33\u0003-\u0011X-\\8wK\ncwnY6\u0015\u0007E\fi\u000f\u0003\u0004\u0002\u0016m\u0001\raR\u0001\u0006G2,\u0017M\u001d\u000b\u0002c\u0002")
public class BlockInfoManager
implements Logging {
    private final ConcurrentHashMap<BlockId, BlockInfoWrapper> blockInfoWrappers;
    private final Striped<Lock> locks;
    private final ConcurrentHashMap<Object, Set<BlockId>> writeLocksByTask;
    private final ConcurrentHashMap<Object, ConcurrentHashMultiset<BlockId>> readLocksByTask;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void registerTask(long taskAttemptId) {
        this.writeLocksByTask.putIfAbsent(BoxesRunTime.boxToLong((long)taskAttemptId), Collections.synchronizedSet(new HashSet()));
        this.readLocksByTask.putIfAbsent(BoxesRunTime.boxToLong((long)taskAttemptId), (ConcurrentHashMultiset<BlockId>)ConcurrentHashMultiset.create());
    }

    private long currentTaskAttemptId() {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.taskAttemptId())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BlockInfo$.MODULE$.NON_TASK_WRITER()));
    }

    private Option<BlockInfo> acquireLock(BlockId blockId, boolean blocking, Function1<BlockInfo, Object> f) {
        BooleanRef done = BooleanRef.create((boolean)false);
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        while (!done.elem) {
            Object object;
            BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
            if (wrapper == null) {
                done.elem = true;
                object = BoxedUnit.UNIT;
                continue;
            }
            object = wrapper.withLock((Function2 & Serializable & scala.Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$acquireLock$1(f, result, done, blocking, info, condition);
                return BoxedUnit.UNIT;
            });
        }
        return (Option)result.elem;
    }

    private <T> T blockInfo(BlockId blockId, Function2<BlockInfo, Condition, T> f) {
        BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
        if (wrapper == null) {
            throw SparkCoreErrors$.MODULE$.blockDoesNotExistError(blockId);
        }
        return wrapper.withLock(f);
    }

    public Option<BlockInfo> lockForReading(BlockId blockId, boolean blocking) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Task ").append(taskAttemptId).append(" trying to acquire read lock for ").append(blockId).toString());
        return this.acquireLock(blockId, blocking, (Function1<BlockInfo, Object>)(Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)BlockInfoManager.$anonfun$lockForReading$2(this, taskAttemptId, blockId, info)));
    }

    public boolean lockForReading$default$2() {
        return true;
    }

    public Option<BlockInfo> lockForWriting(BlockId blockId, boolean blocking) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Task ").append(taskAttemptId).append(" trying to acquire write lock for ").append(blockId).toString());
        return this.acquireLock(blockId, blocking, (Function1<BlockInfo, Object>)(Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)BlockInfoManager.$anonfun$lockForWriting$2(this, taskAttemptId, blockId, info)));
    }

    public boolean lockForWriting$default$2() {
        return true;
    }

    public BlockInfo assertBlockIsLockedForWriting(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        return (BlockInfo)this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, x$2) -> {
            if (info.writerTask() != taskAttemptId) {
                throw SparkCoreErrors$.MODULE$.taskHasNotLockedBlockError(this.currentTaskAttemptId(), blockId);
            }
            return info;
        });
    }

    public Option<BlockInfo> get(BlockId blockId) {
        BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
        if (wrapper != null) {
            return new Some((Object)wrapper.info());
        }
        return None$.MODULE$;
    }

    public void downgradeLock(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Task ").append(taskAttemptId).append(" downgrading write lock for ").append(blockId).toString());
        this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, x$3) -> {
            BlockInfoManager.$anonfun$downgradeLock$2(this, taskAttemptId, blockId, info, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public void unlock(BlockId blockId, Option<Object> taskAttemptIdOption) {
        long taskAttemptId = BoxesRunTime.unboxToLong((Object)taskAttemptIdOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.currentTaskAttemptId()));
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Task ").append(taskAttemptId).append(" releasing lock for ").append(blockId).toString());
        this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$unlock$3(this, taskAttemptId, blockId, info, condition);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Object> unlock$default$2() {
        return None$.MODULE$;
    }

    public boolean lockNewBlockForWriting(BlockId blockId, BlockInfo newBlockInfo, boolean keepReadLock) {
        boolean bl;
        block6: {
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Task ").append(this.currentTaskAttemptId()).append(" trying to put ").append(blockId).toString());
            Lock lock = (Lock)this.locks.get((Object)blockId);
            lock.lock();
            try {
                BlockInfoWrapper wrapper = new BlockInfoWrapper(newBlockInfo, lock);
                do {
                    BlockInfoWrapper previous;
                    if ((previous = this.blockInfoWrappers.putIfAbsent(blockId, wrapper)) == null) {
                        Option<BlockInfo> result = this.lockForWriting(blockId, false);
                        Predef$.MODULE$.assert(result.isDefined());
                        bl = true;
                    } else {
                        if (keepReadLock) continue;
                        bl = false;
                    }
                    break block6;
                } while (!this.lockForReading(blockId, this.lockForReading$default$2()).isDefined());
                bl = false;
            }
            finally {
                lock.unlock();
            }
        }
        return bl;
    }

    public boolean lockNewBlockForWriting$default$3() {
        return true;
    }

    public Seq<BlockId> releaseAllLocksForTask(long taskAttemptId) {
        ArrayBuffer blocksWithReleasedLocks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set writeLocks = (Set)Option$.MODULE$.apply(this.writeLocksByTask.remove(BoxesRunTime.boxToLong((long)taskAttemptId))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptySet());
        writeLocks.forEach(blockId -> {
            this.blockInfo((BlockId)blockId, (Function2 & Serializable & scala.Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$releaseAllLocksForTask$3(taskAttemptId, info, condition);
                return BoxedUnit.UNIT;
            });
            blocksWithReleasedLocks.$plus$eq(blockId);
        });
        Multiset readLocks = (Multiset)Option$.MODULE$.apply(this.readLocksByTask.remove(BoxesRunTime.boxToLong((long)taskAttemptId))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ImmutableMultiset.of());
        readLocks.entrySet().forEach(entry -> {
            BlockId blockId = (BlockId)entry.getElement();
            int lockCount = entry.getCount();
            blocksWithReleasedLocks.$plus$eq((Object)blockId);
            this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$releaseAllLocksForTask$6(lockCount, info, condition);
                return BoxedUnit.UNIT;
            });
        });
        return blocksWithReleasedLocks.toSeq();
    }

    public int getTaskLockCount(long taskAttemptId) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public int size() {
        return this.blockInfoWrappers.size();
    }

    public long getNumberOfMapEntries() {
        return this.size() + this.readLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.readLocksByTask).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$1(x$6)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + this.writeLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.writeLocksByTask).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$2(x$7)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Iterator<Tuple2<BlockId, BlockInfo>> entries() {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.blockInfoWrappers.entrySet().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv.getKey()), (Object)((BlockInfoWrapper)kv.getValue()).info()));
    }

    public void removeBlock(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Task ").append(taskAttemptId).append(" trying to remove block ").append(blockId).toString());
        this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$removeBlock$2(this, taskAttemptId, blockId, info, condition);
            return BoxedUnit.UNIT;
        });
    }

    public void clear() {
        this.blockInfoWrappers.values().forEach(wrapper -> wrapper.tryLock((Function2<BlockInfo, Condition, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$clear$2(info, condition);
            return BoxedUnit.UNIT;
        }));
        this.blockInfoWrappers.clear();
        this.readLocksByTask.clear();
        this.writeLocksByTask.clear();
    }

    public static final /* synthetic */ void $anonfun$acquireLock$1(Function1 f$1, ObjectRef result$1, BooleanRef done$1, boolean blocking$1, BlockInfo info, Condition condition) {
        if (BoxesRunTime.unboxToBoolean((Object)f$1.apply((Object)info))) {
            result$1.elem = new Some((Object)info);
            done$1.elem = true;
            return;
        }
        if (!blocking$1) {
            done$1.elem = true;
            return;
        }
        condition.await();
    }

    public static final /* synthetic */ boolean $anonfun$lockForReading$2(BlockInfoManager $this, long taskAttemptId$1, BlockId blockId$1, BlockInfo info) {
        boolean acquire;
        block0: {
            boolean bl = acquire = info.writerTask() == BlockInfo$.MODULE$.NO_WRITER();
            if (!acquire) break block0;
            info.readerCount_$eq(info.readerCount() + 1);
            $this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$1)).add((Object)blockId$1);
            $this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Task ").append(taskAttemptId$1).append(" acquired read lock for ").append(blockId$1).toString());
        }
        return acquire;
    }

    public static final /* synthetic */ boolean $anonfun$lockForWriting$2(BlockInfoManager $this, long taskAttemptId$2, BlockId blockId$2, BlockInfo info) {
        boolean acquire;
        block0: {
            boolean bl = acquire = info.writerTask() == BlockInfo$.MODULE$.NO_WRITER() && info.readerCount() == 0;
            if (!acquire) break block0;
            info.writerTask_$eq(taskAttemptId$2);
            $this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$2)).add(blockId$2);
            $this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Task ").append(taskAttemptId$2).append(" acquired write lock for ").append(blockId$2).toString());
        }
        return acquire;
    }

    public static final /* synthetic */ void $anonfun$downgradeLock$2(BlockInfoManager $this, long taskAttemptId$4, BlockId blockId$4, BlockInfo info, Condition x$3) {
        Predef$.MODULE$.require(info.writerTask() == taskAttemptId$4, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Task ").append(taskAttemptId$4).append(" tried to downgrade a write lock that it does not hold on").append(" block ").append(blockId$4).toString());
        $this.unlock(blockId$4, $this.unlock$default$2());
        Option<BlockInfo> lockOutcome = $this.lockForReading(blockId$4, false);
        Predef$.MODULE$.assert(lockOutcome.isDefined());
    }

    public static final /* synthetic */ void $anonfun$unlock$3(BlockInfoManager $this, long taskAttemptId$5, BlockId blockId$5, BlockInfo info, Condition condition) {
        Object object;
        if (info.writerTask() != BlockInfo$.MODULE$.NO_WRITER()) {
            info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
            object = BoxesRunTime.boxToBoolean((boolean)$this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$5)).remove(blockId$5));
        } else {
            ConcurrentHashMultiset<BlockId> countsForTask = $this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$5));
            if (countsForTask != null) {
                Predef$.MODULE$.assert(info.readerCount() > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Block ").append(blockId$5).append(" is not locked for reading").toString());
                info.readerCount_$eq(info.readerCount() - 1);
                int newPinCountForTask = countsForTask.remove((Object)blockId$5, 1) - 1;
                Predef$.MODULE$.assert(newPinCountForTask >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Task ").append(taskAttemptId$5).append(" release lock on block ").append(blockId$5).append(" more times than it acquired it").toString());
            }
            object = BoxedUnit.UNIT;
        }
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$3(long taskAttemptId$6, BlockInfo info, Condition condition) {
        Predef$.MODULE$.assert(info.writerTask() == taskAttemptId$6);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$6(int lockCount$1, BlockInfo info, Condition condition) {
        info.readerCount_$eq(info.readerCount() - lockCount$1);
        Predef$.MODULE$.assert(info.readerCount() >= 0);
        condition.signalAll();
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$1(Tuple2 x$6) {
        return ((ConcurrentHashMultiset)x$6._2()).size();
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$2(Tuple2 x$7) {
        return ((Set)x$7._2()).size();
    }

    public static final /* synthetic */ void $anonfun$removeBlock$2(BlockInfoManager $this, long taskAttemptId$7, BlockId blockId$7, BlockInfo info, Condition condition) {
        if (info.writerTask() != taskAttemptId$7) {
            throw new IllegalStateException(new StringBuilder(52).append("Task ").append(taskAttemptId$7).append(" called remove() on block ").append(blockId$7).append(" without a write lock").toString());
        }
        $this.blockInfoWrappers.remove(blockId$7);
        info.readerCount_$eq(0);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        $this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$7)).remove(blockId$7);
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$clear$2(BlockInfo info, Condition condition) {
        info.readerCount_$eq(0);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        condition.signalAll();
    }

    public BlockInfoManager() {
        Logging.$init$(this);
        this.blockInfoWrappers = new ConcurrentHashMap();
        this.locks = Striped.lock((int)1024);
        this.writeLocksByTask = new ConcurrentHashMap();
        this.readLocksByTask = new ConcurrentHashMap();
        this.registerTask(BlockInfo$.MODULE$.NON_TASK_WRITER());
    }
}

