/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.CombinerPackager;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.LitePackager;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.util.Pair;

public class POPackageAnnotator
extends MROpPlanVisitor {
    public POPackageAnnotator(MROperPlan plan) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DepthFirstWalker<MapReduceOper, MROperPlan>(plan));
    }

    @Override
    public void visitMROp(MapReduceOper mr) throws VisitorException {
        POPackage pkg;
        PackageDiscoverer pkgDiscoverer;
        if (!mr.combinePlan.isEmpty()) {
            pkgDiscoverer = new PackageDiscoverer(mr.combinePlan);
            pkgDiscoverer.visit();
            pkg = pkgDiscoverer.getPkg();
            if (pkg != null) {
                this.handlePackage(mr, pkg);
            }
        }
        if (!mr.reducePlan.isEmpty()) {
            pkgDiscoverer = new PackageDiscoverer(mr.reducePlan);
            pkgDiscoverer.visit();
            pkg = pkgDiscoverer.getPkg();
            if (pkg != null) {
                if (pkg.getPkgr() instanceof CombinerPackager) {
                    if (this.patchPackage(mr.combinePlan, pkg) != pkg.getNumInps()) {
                        int errCode = 2085;
                        String msg = "Unexpected problem during optimization. Could not find LocalRearrange in combine plan.";
                        throw new OptimizerException(msg, errCode, 4);
                    }
                } else {
                    this.handlePackage(mr, pkg);
                }
            }
        }
    }

    private void handlePackage(MapReduceOper mr, POPackage pkg) throws VisitorException {
        int lrFound = 0;
        lrFound = this.patchPackage(mr.mapPlan, pkg);
        if (lrFound != pkg.getNumInps()) {
            List<MapReduceOper> preds = ((MROperPlan)this.mPlan).getPredecessors(mr);
            for (MapReduceOper mrOper : preds) {
                if (mrOper.isLimitOnly() && !((MROperPlan)this.mPlan).getPredecessors(mrOper).get(0).isGlobalSort()) {
                    mrOper = ((MROperPlan)this.mPlan).getPredecessors(mrOper).get(0);
                }
                if ((lrFound += this.patchPackage(mrOper.reducePlan, pkg)) != pkg.getNumInps()) continue;
                break;
            }
        }
        if (lrFound != pkg.getNumInps()) {
            int errCode = 2086;
            String msg = "Unexpected problem during optimization. Could not find all LocalRearrange operators.";
            throw new OptimizerException(msg, errCode, 4);
        }
    }

    private int patchPackage(PhysicalPlan plan, POPackage pkg) throws VisitorException {
        LoRearrangeDiscoverer lrDiscoverer = new LoRearrangeDiscoverer(plan, pkg);
        lrDiscoverer.visit();
        return lrDiscoverer.getLoRearrangeFound();
    }

    static class LoRearrangeDiscoverer
    extends PhyPlanVisitor {
        private int loRearrangeFound = 0;
        private POPackage pkg;

        public LoRearrangeDiscoverer(PhysicalPlan plan, POPackage pkg) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.pkg = pkg;
        }

        @Override
        public void visitLocalRearrange(POLocalRearrange lrearrange) throws VisitorException {
            ++this.loRearrangeFound;
            if (this.pkg.getPkgr() instanceof LitePackager && lrearrange.getIndex() != 0) {
                throw new RuntimeException("POLocalRearrange for POPackageLite cannot have index other than 0, but has index - " + lrearrange.getIndex());
            }
            Map<Integer, Pair<Boolean, Map<Integer, Integer>>> keyInfo = this.pkg.getPkgr().getKeyInfo();
            if (keyInfo == null) {
                keyInfo = new HashMap<Integer, Pair<Boolean, Map<Integer, Integer>>>();
            }
            if (keyInfo.get(lrearrange.getIndex()) != null) {
                int errCode = 2087;
                String msg = "Unexpected problem during optimization. Found index:" + lrearrange.getIndex() + " in multiple LocalRearrange operators.";
                throw new OptimizerException(msg, errCode, 4);
            }
            keyInfo.put(Integer.valueOf(lrearrange.getIndex()), new Pair<Boolean, Map<Integer, Integer>>(lrearrange.isProjectStar(), lrearrange.getProjectedColsMap()));
            this.pkg.getPkgr().setKeyInfo(keyInfo);
            this.pkg.getPkgr().setKeyTuple(lrearrange.isKeyTuple());
            this.pkg.getPkgr().setKeyCompound(lrearrange.isKeyCompound());
        }

        public int getLoRearrangeFound() {
            return this.loRearrangeFound;
        }
    }

    static class PackageDiscoverer
    extends PhyPlanVisitor {
        private POPackage pkg;

        public PackageDiscoverer(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        @Override
        public void visitPackage(POPackage pkg) throws VisitorException {
            this.pkg = pkg;
        }

        public POPackage getPkg() {
            return this.pkg;
        }
    }
}

