/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pig.backend.hadoop.executionengine.spark.JobMetricsListener;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListener;

public class JobStatisticCollector {
    private final Map<Integer, int[]> jobIdToStageId = Maps.newHashMap();
    private final Map<Integer, Integer> stageIdToJobId = Maps.newHashMap();
    private final Map<Integer, Map<String, List<TaskMetrics>>> allJobStatistics = Maps.newHashMap();
    private final Set<Integer> finishedJobIds = Sets.newHashSet();
    private SparkListener sparkListener;

    public SparkListener getSparkListener() {
        if (this.sparkListener == null) {
            this.sparkListener = new JobMetricsListener(this.jobIdToStageId, this.stageIdToJobId, this.allJobStatistics, this.finishedJobIds);
        }
        return this.sparkListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<TaskMetrics>> getJobMetric(int jobId) {
        SparkListener sparkListener = this.sparkListener;
        synchronized (sparkListener) {
            return this.allJobStatistics.get(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobToEnd(int jobId) throws InterruptedException {
        SparkListener sparkListener = this.sparkListener;
        synchronized (sparkListener) {
            while (!this.finishedJobIds.contains(jobId)) {
                this.sparkListener.wait();
            }
            this.finishedJobIds.remove(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(int jobId) {
        SparkListener sparkListener = this.sparkListener;
        synchronized (sparkListener) {
            this.allJobStatistics.remove(jobId);
            this.jobIdToStageId.remove(jobId);
            Iterator<Map.Entry<Integer, Integer>> iterator = this.stageIdToJobId.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, Integer> entry = iterator.next();
                if (entry.getValue() != jobId) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        SparkListener sparkListener = this.sparkListener;
        synchronized (sparkListener) {
            this.stageIdToJobId.clear();
            this.jobIdToStageId.clear();
            this.allJobStatistics.clear();
            this.finishedJobIds.clear();
        }
    }
}

