/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.AbstractInjectable;
import org.apache.webbeans.proxy.NormalScopeProxyFactory;
import org.apache.webbeans.proxy.OwbNormalScopeProxy;

public class InjectableMethod<T>
extends AbstractInjectable<T> {
    protected Method method;
    protected Object ownerInstance;
    private boolean disposable;
    private Object producerMethodInstance = null;
    private Map<Bean<?>, Object> dependentParameters = new HashMap();
    private Set<InjectionPoint> injectionPoints;

    public InjectableMethod(Method m, Object instance, Producer<T> owner, CreationalContextImpl<T> creationalContext) {
        this(m, instance, owner, creationalContext, new HashSet<InjectionPoint>(InjectableMethod.createInjectionPoints(owner, m)));
    }

    public InjectableMethod(Method m, Object instance, Producer<T> owner, CreationalContextImpl<T> creationalContext, Set<InjectionPoint> ips) {
        super(owner, creationalContext);
        this.method = m;
        this.ownerInstance = instance;
        this.injectionPoints = ips;
    }

    public T doInjection() {
        Object owner = this.ownerInstance;
        if (owner instanceof OwbNormalScopeProxy) {
            owner = NormalScopeProxyFactory.unwrapInstance(owner);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        block2: for (int i = 0; i < this.injectionPoints.size(); ++i) {
            for (InjectionPoint point : this.injectionPoints) {
                AnnotatedParameter parameter = (AnnotatedParameter)point.getAnnotated();
                if (parameter.getPosition() != i) continue;
                if (point.isDelegate()) {
                    list.add(this.creationalContext.getDelegate());
                    continue block2;
                }
                boolean injectionPoint = false;
                if (this.getBean() instanceof ProducerMethodBean && parameter.getBaseType().equals(InjectionPoint.class)) {
                    BeanManagerImpl manager = this.getWebBeansContext().getBeanManagerImpl();
                    Object reference = manager.getInjectableReference(point, this.creationalContext);
                    list.add(reference);
                    injectionPoint = true;
                }
                if (injectionPoint) continue block2;
                if (this.isDisposable() && parameter.getAnnotation(Disposes.class) != null) {
                    list.add(this.producerMethodInstance);
                    continue block2;
                }
                Object instance = this.inject(point);
                InjectionResolver injectionResolver = this.getWebBeansContext().getBeanManagerImpl().getInjectionResolver();
                Bean<?> injectedBean = injectionResolver.getInjectionPointBean(point);
                if (injectedBean.getScope() == Dependent.class) {
                    this.dependentParameters.put(injectedBean, instance);
                }
                list.add(instance);
                continue block2;
            }
        }
        try {
            if (!this.method.isAccessible()) {
                this.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.method, true);
            }
            return (T)this.method.invoke(owner, list.toArray(new Object[list.size()]));
        }
        catch (Exception e) {
            throw new WebBeansException(e);
        }
    }

    public Map<Bean<?>, Object> getDependentBeanParameters() {
        return this.dependentParameters;
    }

    private boolean isDisposable() {
        return this.disposable;
    }

    public void setDisposable(boolean disposable) {
        this.disposable = disposable;
    }

    public void setProducerMethodInstance(Object instance) {
        this.producerMethodInstance = instance;
    }
}

