/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.DoubleFloatHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class DoubleFloatScatterMap
extends DoubleFloatHashMap {
    public DoubleFloatScatterMap() {
        this(4);
    }

    public DoubleFloatScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public DoubleFloatScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(double key) {
        return BitMixer.mixPhi(key);
    }

    public static DoubleFloatScatterMap from(double[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleFloatScatterMap map = new DoubleFloatScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

