/****************************************************************************
 * libs/libnx/nxfonts/nxfonts_serif27x38b.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __LIBS_LIBNX_NXFONTS_NXFONTS_SERIF27X38B_H
#define __LIBS_LIBNX_NXFONTS_NXFONTS_SERIF27X38B_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

/****************************************************************************
 * Pre-Processor Definitions
 ****************************************************************************/

/* Font ID */

#define NXFONT_ID         FONTID_SERIF27X38B

/* Ranges of 7-bit and 8-bit fonts */

#define NXFONT_MIN7BIT    33
#define NXFONT_MAX7BIT    126

#define NXFONT_MIN8BIT    161
#define NXFONT_MAX8BIT    255

/* Maximum height and width of any glyph in the set */

#define NXFONT_MAXHEIGHT  38
#define NXFONT_MAXWIDTH   27

/* The width of a space */

#define NXFONT_SPACEWIDTH 6

/* exclam (33) */
#define NXFONT_METRICS_33 {1, 4, 17, 2, 11, 0}
#define NXFONT_BITMAP_33 {0x60, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x0, 0x0, 0x60, 0xf0, 0xf0, 0x60}

/* quotedbl (34) */
#define NXFONT_METRICS_34 {1, 8, 8, 2, 11, 0}
#define NXFONT_BITMAP_34 {0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0x42, 0x42}

/* numbersign (35) */
#define NXFONT_METRICS_35 {2, 12, 17, 0, 11, 0}
#define NXFONT_BITMAP_35 {0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0x7f, 0xf0, 0x7f, 0xf0, 0x19, 0x80, 0x19, 0x80, 0x19, 0x80, 0x19, 0x80, 0xff, 0xe0, 0xff, 0xe0, 0x33, 0x0, 0x33, 0x0, 0x33, 0x0, 0x33, 0x0, 0x33, 0x0}

/* dollar (36) */
#define NXFONT_METRICS_36 {2, 10, 20, 1, 10, 0}
#define NXFONT_BITMAP_36 {0x8, 0x0, 0x8, 0x0, 0x3f, 0x0, 0x6b, 0x80, 0xe9, 0x80, 0xe9, 0x80, 0xf8, 0x80, 0x7c, 0x0, 0x7e, 0x0, 0x3f, 0x0, 0x1f, 0x80, 0xf, 0x80, 0xb, 0xc0, 0x89, 0xc0, 0xc9, 0xc0, 0xc9, 0x80, 0xeb, 0x80, 0x3e, 0x0, 0x8, 0x0, 0x8, 0x0}

/* percent (37) */
#define NXFONT_METRICS_37 {3, 17, 17, 1, 11, 0}
#define NXFONT_BITMAP_37 {0x1e, 0xc, 0x0, 0x3b, 0xfc, 0x0, 0x71, 0x18, 0x0, 0xe1, 0x30, 0x0, 0xe2, 0x30, 0x0, 0xe2, 0x60, 0x0, 0xf4, 0x60, 0x0, 0x78, 0xc0, 0x0, 0x0, 0xc0, 0x0, 0x1, 0x8f, 0x0, 0x1, 0x9d, 0x80, 0x3, 0x38, 0x80, 0x3, 0x70, 0x80, 0x6, 0x71, 0x0, 0x6, 0x71, 0x0, 0xc, 0x7a, 0x0, 0xc, 0x3c, 0x0}

/* ampersand (38) */
#define NXFONT_METRICS_38 {3, 17, 17, 1, 11, 0}
#define NXFONT_BITMAP_38 {0x3, 0xe0, 0x0, 0x6, 0x70, 0x0, 0xe, 0x30, 0x0, 0xe, 0x30, 0x0, 0xe, 0x70, 0x0, 0x7, 0xe0, 0x0, 0xf, 0xf, 0x80, 0x1f, 0x87, 0x0, 0x33, 0xc2, 0x0, 0x61, 0xe6, 0x0, 0xe1, 0xfc, 0x0, 0xe0, 0xf8, 0x0, 0xe0, 0x78, 0x0, 0xf0, 0x7c, 0x0, 0xf8, 0xff, 0x80, 0x7f, 0x9f, 0x0, 0x3f, 0xe, 0x0}

/* quotesingle (39) */
#define NXFONT_METRICS_39 {1, 3, 8, 2, 11, 0}
#define NXFONT_BITMAP_39 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x40, 0x40}

/* parenleft (40) */
#define NXFONT_METRICS_40 {1, 5, 21, 1, 11, 0}
#define NXFONT_BITMAP_40 {0x8, 0x18, 0x30, 0x30, 0x70, 0x60, 0x60, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x60, 0x60, 0x70, 0x30, 0x30, 0x18, 0x8}

/* parenright (41) */
#define NXFONT_METRICS_41 {1, 5, 21, 1, 11, 0}
#define NXFONT_BITMAP_41 {0x80, 0xc0, 0x60, 0x60, 0x30, 0x30, 0x30, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x30, 0x30, 0x30, 0x60, 0x60, 0xc0, 0x80}

/* asterisk (42) */
#define NXFONT_METRICS_42 {2, 10, 11, 1, 11, 0}
#define NXFONT_BITMAP_42 {0xc, 0x0, 0xc, 0x0, 0x4c, 0x80, 0xed, 0xc0, 0x7f, 0x80, 0x1e, 0x0, 0x7f, 0x80, 0xed, 0xc0, 0x4c, 0x80, 0xc, 0x0, 0xc, 0x0}

/* plus (43) */
#define NXFONT_METRICS_43 {2, 12, 12, 1, 16, 0}
#define NXFONT_BITMAP_43 {0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0xff, 0xf0, 0xff, 0xf0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0}

/* comma (44) */
#define NXFONT_METRICS_44 {1, 4, 9, 1, 24, 0}
#define NXFONT_BITMAP_44 {0x60, 0xf0, 0xf0, 0x70, 0x30, 0x60, 0x60, 0xc0, 0x80}

/* hyphen (45) */
#define NXFONT_METRICS_45 {1, 6, 3, 1, 20, 0}
#define NXFONT_BITMAP_45 {0xfc, 0xfc, 0xfc}

/* period (46) */
#define NXFONT_METRICS_46 {1, 4, 4, 1, 24, 0}
#define NXFONT_BITMAP_46 {0x60, 0xf0, 0xf0, 0x60}

/* slash (47) */
#define NXFONT_METRICS_47 {1, 7, 17, 0, 11, 0}
#define NXFONT_BITMAP_47 {0x6, 0x6, 0x4, 0xc, 0xc, 0x8, 0x18, 0x18, 0x10, 0x30, 0x30, 0x20, 0x60, 0x60, 0x40, 0xc0, 0xc0}

/* zero (48) */
#define NXFONT_METRICS_48 {2, 11, 17, 0, 11, 0}
#define NXFONT_BITMAP_48 {0xe, 0x0, 0x3b, 0x80, 0x31, 0x80, 0x71, 0xc0, 0x71, 0xc0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0x71, 0xc0, 0x71, 0xc0, 0x71, 0xc0, 0x31, 0x80, 0x3b, 0x80, 0xe, 0x0}

/* one (49) */
#define NXFONT_METRICS_49 {2, 9, 17, 2, 11, 0}
#define NXFONT_BITMAP_49 {0xc, 0x0, 0x3c, 0x0, 0xfc, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x3e, 0x0, 0xff, 0x80}

/* two (50) */
#define NXFONT_METRICS_50 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_50 {0x1e, 0x0, 0x3f, 0x0, 0x7f, 0x80, 0xc7, 0x80, 0x83, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x0, 0x7, 0x0, 0x6, 0x0, 0xc, 0x0, 0xc, 0x0, 0x18, 0x40, 0x30, 0x40, 0x7f, 0xc0, 0xff, 0xc0, 0xff, 0x80}

/* three (51) */
#define NXFONT_METRICS_51 {2, 11, 17, 0, 11, 0}
#define NXFONT_BITMAP_51 {0xf, 0x0, 0x3f, 0x80, 0x63, 0xc0, 0x41, 0xc0, 0x1, 0xc0, 0x3, 0x80, 0x7, 0x0, 0x1f, 0x0, 0x7, 0xc0, 0x1, 0xe0, 0x1, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x60, 0xe0, 0xf1, 0xc0, 0xfb, 0x80, 0x7e, 0x0}

/* four (52) */
#define NXFONT_METRICS_52 {2, 11, 17, 0, 11, 0}
#define NXFONT_BITMAP_52 {0x1, 0x80, 0x3, 0x80, 0x7, 0x80, 0x7, 0x80, 0xf, 0x80, 0x1b, 0x80, 0x33, 0x80, 0x33, 0x80, 0x63, 0x80, 0xc3, 0x80, 0xff, 0xe0, 0xff, 0xe0, 0xff, 0xe0, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80}

/* five (53) */
#define NXFONT_METRICS_53 {2, 11, 17, 0, 11, 0}
#define NXFONT_BITMAP_53 {0x1f, 0xe0, 0x1f, 0xc0, 0x3f, 0xc0, 0x30, 0x0, 0x20, 0x0, 0x70, 0x0, 0x7f, 0x0, 0x7f, 0x80, 0x7f, 0xc0, 0x7, 0xc0, 0x1, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x60, 0xc0, 0xf1, 0x80, 0xfb, 0x80, 0x7e, 0x0}

/* six (54) */
#define NXFONT_METRICS_54 {2, 11, 17, 1, 11, 0}
#define NXFONT_BITMAP_54 {0x1, 0xe0, 0x7, 0x80, 0x1e, 0x0, 0x3c, 0x0, 0x38, 0x0, 0x78, 0x0, 0x77, 0x0, 0x7b, 0x80, 0xf1, 0xc0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0x71, 0xc0, 0x71, 0xc0, 0x3b, 0x80, 0x1e, 0x0}

/* seven (55) */
#define NXFONT_METRICS_55 {2, 11, 17, 0, 11, 0}
#define NXFONT_BITMAP_55 {0x3f, 0xe0, 0x7f, 0xe0, 0x7f, 0xc0, 0xc0, 0xc0, 0x81, 0x80, 0x1, 0x80, 0x3, 0x80, 0x3, 0x0, 0x3, 0x0, 0x7, 0x0, 0x6, 0x0, 0x6, 0x0, 0xe, 0x0, 0xe, 0x0, 0xc, 0x0, 0x1c, 0x0, 0x1c, 0x0}

/* eight (56) */
#define NXFONT_METRICS_56 {2, 11, 17, 0, 11, 0}
#define NXFONT_BITMAP_56 {0x1f, 0x0, 0x3b, 0x80, 0x71, 0xc0, 0x71, 0xc0, 0x71, 0xc0, 0x79, 0x80, 0x3b, 0x0, 0x3f, 0x0, 0x1f, 0x80, 0x37, 0xc0, 0x63, 0xc0, 0xe1, 0xe0, 0xe1, 0xe0, 0xe1, 0xe0, 0xf1, 0xc0, 0x7b, 0x80, 0x3e, 0x0}

/* nine (57) */
#define NXFONT_METRICS_57 {2, 11, 17, 0, 11, 0}
#define NXFONT_BITMAP_57 {0xe, 0x0, 0x3b, 0x80, 0x71, 0xc0, 0x71, 0xc0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0xf1, 0xe0, 0x71, 0xe0, 0x3b, 0xc0, 0x1f, 0xc0, 0x3, 0xc0, 0x3, 0x80, 0x7, 0x80, 0xf, 0x0, 0x3c, 0x0, 0xf0, 0x0}

/* colon (58) */
#define NXFONT_METRICS_58 {1, 4, 12, 2, 16, 0}
#define NXFONT_BITMAP_58 {0x60, 0xf0, 0xf0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x60, 0xf0, 0xf0, 0x60}

/* semicolon (59) */
#define NXFONT_METRICS_59 {1, 4, 17, 2, 16, 0}
#define NXFONT_BITMAP_59 {0x60, 0xf0, 0xf0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x60, 0xf0, 0xf0, 0x70, 0x30, 0x60, 0x60, 0xc0, 0x80}

/* less (60) */
#define NXFONT_METRICS_60 {2, 11, 12, 1, 16, 0}
#define NXFONT_BITMAP_60 {0x0, 0x60, 0x1, 0xe0, 0x7, 0xc0, 0x1f, 0x0, 0x3c, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0x3c, 0x0, 0x1f, 0x0, 0x7, 0xc0, 0x1, 0xe0, 0x0, 0x60}

/* equal (61) */
#define NXFONT_METRICS_61 {2, 11, 6, 1, 19, 0}
#define NXFONT_BITMAP_61 {0xff, 0xe0, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xe0, 0xff, 0xe0}

/* greater (62) */
#define NXFONT_METRICS_62 {2, 11, 12, 1, 16, 0}
#define NXFONT_BITMAP_62 {0xc0, 0x0, 0xf0, 0x0, 0x7c, 0x0, 0x1f, 0x0, 0x7, 0x80, 0x0, 0xe0, 0x0, 0xe0, 0x7, 0x80, 0x1f, 0x0, 0x7c, 0x0, 0xf0, 0x0, 0xc0, 0x0}

/* question (63) */
#define NXFONT_METRICS_63 {2, 9, 17, 1, 11, 0}
#define NXFONT_BITMAP_63 {0x3e, 0x0, 0x6f, 0x0, 0xe7, 0x80, 0xe7, 0x80, 0x47, 0x80, 0x7, 0x80, 0xf, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x18, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x18, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x18, 0x0}

/* at (64) */
#define NXFONT_METRICS_64 {3, 20, 21, 1, 11, 0}
#define NXFONT_BITMAP_64 {0x0, 0x7c, 0x0, 0x3, 0xf7, 0x80, 0xf, 0x80, 0xc0, 0x1e, 0x0, 0x60, 0x3c, 0x0, 0x20, 0x38, 0x3b, 0x30, 0x70, 0xff, 0x10, 0x71, 0xe7, 0x10, 0xf1, 0xc7, 0x10, 0xe3, 0xc6, 0x10, 0xe3, 0x8e, 0x10, 0xe3, 0x8e, 0x30, 0xe3, 0x8e, 0x20, 0xf3, 0x9e, 0x60, 0xf1, 0xfe, 0xc0, 0x70, 0xf3, 0x80, 0x78, 0x0, 0x0, 0x38, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x7, 0x83, 0x0, 0x1, 0xfc, 0x0}

/* A (65) */
#define NXFONT_METRICS_65 {3, 17, 17, 0, 11, 0}
#define NXFONT_BITMAP_65 {0x1, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x3, 0xc0, 0x0, 0x3, 0xe0, 0x0, 0x3, 0xe0, 0x0, 0x6, 0xe0, 0x0, 0x6, 0xf0, 0x0, 0x4, 0x70, 0x0, 0xc, 0x70, 0x0, 0x8, 0x78, 0x0, 0x8, 0x38, 0x0, 0x1f, 0xf8, 0x0, 0x10, 0x3c, 0x0, 0x30, 0x3c, 0x0, 0x30, 0x1e, 0x0, 0x70, 0x1e, 0x0, 0xf8, 0x7f, 0x80}

/* B (66) */
#define NXFONT_METRICS_66 {2, 14, 17, 0, 11, 0}
#define NXFONT_BITMAP_66 {0xff, 0xc0, 0x3c, 0xf0, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x70, 0x3c, 0xc0, 0x3f, 0xe0, 0x3c, 0x78, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x38, 0x3c, 0x78, 0xff, 0xe0}

/* C (67) */
#define NXFONT_METRICS_67 {2, 15, 17, 1, 11, 0}
#define NXFONT_BITMAP_67 {0x3, 0xf2, 0x1e, 0x3e, 0x3c, 0xe, 0x78, 0x6, 0x78, 0x2, 0xf0, 0x2, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0x78, 0x0, 0x78, 0x2, 0x3c, 0xe, 0x1f, 0x3c, 0x7, 0xf0}

/* D (68) */
#define NXFONT_METRICS_68 {2, 16, 17, 1, 11, 0}
#define NXFONT_BITMAP_68 {0xff, 0xe0, 0x3c, 0x78, 0x3c, 0x3c, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0xf, 0x3c, 0xf, 0x3c, 0xf, 0x3c, 0xf, 0x3c, 0xf, 0x3c, 0xf, 0x3c, 0xe, 0x3c, 0x1e, 0x3c, 0x1c, 0x3c, 0x3c, 0x3c, 0x78, 0xff, 0xe0}

/* E (69) */
#define NXFONT_METRICS_69 {2, 15, 17, 1, 11, 0}
#define NXFONT_BITMAP_69 {0xff, 0xfc, 0x3c, 0x1c, 0x3c, 0xc, 0x3c, 0x4, 0x3c, 0x4, 0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x60, 0x3f, 0xe0, 0x3c, 0x60, 0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x2, 0x3c, 0x2, 0x3c, 0x6, 0x3c, 0xe, 0xff, 0xfe}

/* F (70) */
#define NXFONT_METRICS_70 {2, 14, 17, 0, 11, 0}
#define NXFONT_BITMAP_70 {0xff, 0xfc, 0x3c, 0x1c, 0x3c, 0xc, 0x3c, 0x4, 0x3c, 0x4, 0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x60, 0x3f, 0xe0, 0x3c, 0x60, 0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0xff, 0x0}

/* G (71) */
#define NXFONT_METRICS_71 {3, 17, 17, 1, 11, 0}
#define NXFONT_BITMAP_71 {0x3, 0xf2, 0x0, 0x1e, 0x3e, 0x0, 0x3c, 0xe, 0x0, 0x78, 0x6, 0x0, 0x78, 0x2, 0x0, 0xf0, 0x2, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x7f, 0x80, 0xf0, 0x1e, 0x0, 0xf0, 0x1e, 0x0, 0x78, 0x1e, 0x0, 0x78, 0x1e, 0x0, 0x38, 0x1e, 0x0, 0x1e, 0x1e, 0x0, 0x7, 0xf8, 0x0}

/* H (72) */
#define NXFONT_METRICS_72 {3, 18, 17, 0, 11, 0}
#define NXFONT_BITMAP_72 {0xff, 0x3f, 0xc0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0x3f, 0xff, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf, 0x0, 0xff, 0x3f, 0xc0}

/* I (73) */
#define NXFONT_METRICS_73 {1, 8, 17, 0, 11, 0}
#define NXFONT_BITMAP_73 {0xff, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0xff}

/* J (74) */
#define NXFONT_METRICS_74 {2, 11, 19, 0, 11, 0}
#define NXFONT_BITMAP_74 {0x1f, 0xe0, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0xe7, 0x80, 0xe7, 0x80, 0xe7, 0x0, 0xe7, 0x0, 0x3c, 0x0}

/* K (75) */
#define NXFONT_METRICS_75 {3, 18, 17, 0, 11, 0}
#define NXFONT_BITMAP_75 {0xff, 0x3f, 0x80, 0x3c, 0x1e, 0x0, 0x3c, 0x18, 0x0, 0x3c, 0x30, 0x0, 0x3c, 0x60, 0x0, 0x3c, 0xc0, 0x0, 0x3d, 0x80, 0x0, 0x3f, 0xc0, 0x0, 0x3f, 0xc0, 0x0, 0x3d, 0xe0, 0x0, 0x3c, 0xf0, 0x0, 0x3c, 0xf8, 0x0, 0x3c, 0x7c, 0x0, 0x3c, 0x3e, 0x0, 0x3c, 0x1f, 0x0, 0x3c, 0xf, 0x80, 0xff, 0x1f, 0xc0}

/* L (76) */
#define NXFONT_METRICS_76 {2, 15, 17, 0, 11, 0}
#define NXFONT_BITMAP_76 {0xff, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x2, 0x3c, 0x6, 0x3c, 0xc, 0x3c, 0x1c, 0xff, 0xfc}

/* M (77) */
#define NXFONT_METRICS_77 {3, 21, 17, 1, 11, 0}
#define NXFONT_BITMAP_77 {0xfc, 0x1, 0xf8, 0x3c, 0x3, 0xe0, 0x3e, 0x3, 0xe0, 0x3e, 0x7, 0xe0, 0x2f, 0x5, 0xe0, 0x2f, 0xd, 0xe0, 0x27, 0x9, 0xe0, 0x27, 0x89, 0xe0, 0x27, 0x99, 0xe0, 0x23, 0x91, 0xe0, 0x23, 0xf1, 0xe0, 0x23, 0xf1, 0xe0, 0x21, 0xe1, 0xe0, 0x21, 0xe1, 0xe0, 0x20, 0xc1, 0xe0, 0x20, 0xc1, 0xe0, 0xf8, 0x7, 0xf8}

/* N (78) */
#define NXFONT_METRICS_78 {3, 17, 17, 0, 11, 0}
#define NXFONT_BITMAP_78 {0xf8, 0xf, 0x80, 0x7c, 0x7, 0x0, 0x3e, 0x2, 0x0, 0x3f, 0x2, 0x0, 0x3f, 0x82, 0x0, 0x2f, 0xc2, 0x0, 0x27, 0xe2, 0x0, 0x23, 0xe2, 0x0, 0x21, 0xf2, 0x0, 0x20, 0xfa, 0x0, 0x20, 0x7e, 0x0, 0x20, 0x3e, 0x0, 0x20, 0x1e, 0x0, 0x20, 0x1e, 0x0, 0x20, 0xe, 0x0, 0x60, 0x6, 0x0, 0xf8, 0x2, 0x0}

/* O (79) */
#define NXFONT_METRICS_79 {2, 16, 17, 1, 11, 0}
#define NXFONT_BITMAP_79 {0x7, 0xe0, 0x1c, 0x38, 0x38, 0x1c, 0x78, 0x1e, 0x70, 0xe, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0x70, 0xe, 0x78, 0x1e, 0x38, 0x1c, 0x1c, 0x38, 0x7, 0xe0}

/* P (80) */
#define NXFONT_METRICS_80 {2, 14, 17, 0, 11, 0}
#define NXFONT_BITMAP_80 {0xff, 0xe0, 0x3c, 0x78, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x78, 0x3f, 0xe0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0xff, 0x0}

/* Q (81) */
#define NXFONT_METRICS_81 {3, 17, 22, 1, 11, 0}
#define NXFONT_BITMAP_81 {0x7, 0xe0, 0x0, 0x1c, 0x38, 0x0, 0x38, 0x1c, 0x0, 0x78, 0x1e, 0x0, 0x70, 0xe, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xe, 0x0, 0x78, 0x1e, 0x0, 0x78, 0x1c, 0x0, 0x3c, 0x38, 0x0, 0x1f, 0xe0, 0x0, 0x7, 0xc0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x3f, 0x80}

/* R (82) */
#define NXFONT_METRICS_82 {2, 16, 17, 1, 11, 0}
#define NXFONT_BITMAP_82 {0xff, 0xe0, 0x3c, 0x78, 0x3c, 0x38, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x38, 0x3c, 0x70, 0x3f, 0xc0, 0x3d, 0xe0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0x78, 0x3c, 0x7c, 0x3c, 0x3c, 0x3c, 0x1e, 0xff, 0x1f}

/* S (83) */
#define NXFONT_METRICS_83 {2, 12, 17, 1, 11, 0}
#define NXFONT_BITMAP_83 {0x3f, 0xa0, 0x71, 0xe0, 0xe0, 0xe0, 0xe0, 0x60, 0xe0, 0x20, 0xf8, 0x0, 0x7e, 0x0, 0x7f, 0x80, 0x3f, 0xc0, 0xf, 0xe0, 0x7, 0xe0, 0x81, 0xf0, 0x80, 0xf0, 0xc0, 0xf0, 0xe0, 0xe0, 0xf9, 0xe0, 0xbf, 0x80}

/* T (84) */
#define NXFONT_METRICS_84 {2, 14, 17, 1, 11, 0}
#define NXFONT_BITMAP_84 {0xff, 0xfc, 0xe7, 0x9c, 0xc7, 0x8c, 0x87, 0x84, 0x87, 0x84, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x1f, 0xe0}

/* U (85) */
#define NXFONT_METRICS_85 {3, 17, 17, 0, 11, 0}
#define NXFONT_BITMAP_85 {0xff, 0xf, 0x80, 0x7e, 0x7, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x6, 0x0, 0x1e, 0x4, 0x0, 0x1f, 0xc, 0x0, 0x7, 0xf8, 0x0}

/* V (86) */
#define NXFONT_METRICS_86 {3, 17, 17, 0, 11, 0}
#define NXFONT_BITMAP_86 {0xff, 0x1f, 0x80, 0x3c, 0x6, 0x0, 0x3c, 0x4, 0x0, 0x1e, 0x4, 0x0, 0x1e, 0xc, 0x0, 0xf, 0x8, 0x0, 0xf, 0x18, 0x0, 0xf, 0x18, 0x0, 0x7, 0x90, 0x0, 0x7, 0xb0, 0x0, 0x3, 0xe0, 0x0, 0x3, 0xe0, 0x0, 0x3, 0xe0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x80, 0x0, 0x0, 0x80, 0x0}

/* W (87) */
#define NXFONT_METRICS_87 {3, 24, 17, 0, 11, 0}
#define NXFONT_BITMAP_87 {0xff, 0x7f, 0x9f, 0x3c, 0x1e, 0x6, 0x3c, 0x1e, 0x4, 0x1e, 0xf, 0xc, 0x1e, 0x1f, 0x8, 0x1e, 0x1f, 0x18, 0xf, 0x17, 0x98, 0xf, 0x37, 0x90, 0xf, 0x27, 0xb0, 0x7, 0xe3, 0xb0, 0x7, 0xc3, 0xe0, 0x7, 0xc3, 0xe0, 0x3, 0xc1, 0xe0, 0x3, 0x81, 0xc0, 0x3, 0x81, 0xc0, 0x1, 0x0, 0x80, 0x1, 0x0, 0x80}

/* X (88) */
#define NXFONT_METRICS_88 {2, 16, 17, 1, 11, 0}
#define NXFONT_BITMAP_88 {0xff, 0x3f, 0x3e, 0xc, 0x1e, 0x8, 0x1f, 0x18, 0xf, 0x30, 0xf, 0xa0, 0x7, 0xe0, 0x3, 0xc0, 0x3, 0xe0, 0x3, 0xe0, 0x3, 0xf0, 0x6, 0xf0, 0xc, 0x78, 0x8, 0x7c, 0x18, 0x3c, 0x38, 0x3e, 0xfc, 0xff}

/* Y (89) */
#define NXFONT_METRICS_89 {3, 18, 17, 0, 11, 0}
#define NXFONT_BITMAP_89 {0xff, 0x8f, 0xc0, 0x3e, 0x3, 0x0, 0x1e, 0x2, 0x0, 0xf, 0x6, 0x0, 0xf, 0xc, 0x0, 0x7, 0x8c, 0x0, 0x7, 0x98, 0x0, 0x3, 0xd0, 0x0, 0x3, 0xf0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x7, 0xf8, 0x0}

/* Z (90) */
#define NXFONT_METRICS_90 {2, 14, 17, 1, 11, 0}
#define NXFONT_BITMAP_90 {0xff, 0xf8, 0xe0, 0xf8, 0xc1, 0xf0, 0xc1, 0xf0, 0x83, 0xe0, 0x3, 0xc0, 0x7, 0xc0, 0x7, 0x80, 0xf, 0x80, 0xf, 0x0, 0x1e, 0x0, 0x3e, 0x4, 0x3c, 0x4, 0x7c, 0xc, 0x78, 0x1c, 0xf8, 0x3c, 0xff, 0xf8}

/* bracketleft (91) */
#define NXFONT_METRICS_91 {1, 5, 21, 1, 11, 0}
#define NXFONT_BITMAP_91 {0xf8, 0xe0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe0, 0xf8}

/* backslash (92) */
#define NXFONT_METRICS_92 {1, 7, 17, 0, 11, 0}
#define NXFONT_BITMAP_92 {0xc0, 0xc0, 0x40, 0x60, 0x60, 0x20, 0x30, 0x30, 0x10, 0x18, 0x18, 0x8, 0xc, 0xc, 0x4, 0x6, 0x6}

/* bracketright (93) */
#define NXFONT_METRICS_93 {1, 5, 21, 1, 11, 0}
#define NXFONT_BITMAP_93 {0xf8, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0xf8}

/* asciicircum (94) */
#define NXFONT_METRICS_94 {1, 8, 10, 3, 11, 0}
#define NXFONT_BITMAP_94 {0x18, 0x18, 0x3c, 0x24, 0x66, 0x66, 0x66, 0xc3, 0xc3, 0x81}

/* underscore (95) */
#define NXFONT_METRICS_95 {2, 12, 2, 0, 31, 0}
#define NXFONT_BITMAP_95 {0xff, 0xf0, 0xff, 0xf0}

/* grave (96) */
#define NXFONT_METRICS_96 {1, 5, 4, 1, 11, 0}
#define NXFONT_BITMAP_96 {0xe0, 0x70, 0x30, 0x18}

/* a (97) */
#define NXFONT_METRICS_97 {2, 10, 12, 1, 16, 0}
#define NXFONT_BITMAP_97 {0x3e, 0x0, 0x77, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0x43, 0x80, 0xf, 0x80, 0x73, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0xc0, 0x71, 0x80}

/* b (98) */
#define NXFONT_METRICS_98 {2, 11, 17, 1, 11, 0}
#define NXFONT_BITMAP_98 {0xf0, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x77, 0x0, 0x7f, 0xc0, 0x71, 0xc0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x71, 0xc0, 0x7b, 0xc0, 0x67, 0x0}

/* c (99) */
#define NXFONT_METRICS_99 {2, 9, 12, 1, 16, 0}
#define NXFONT_BITMAP_99 {0x1e, 0x0, 0x73, 0x0, 0x73, 0x80, 0xe3, 0x80, 0xe1, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xf0, 0x0, 0x78, 0x80, 0x7f, 0x0, 0x1e, 0x0}

/* d (100) */
#define NXFONT_METRICS_100 {2, 12, 17, 1, 11, 0}
#define NXFONT_BITMAP_100 {0x1, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x1e, 0xe0, 0x7f, 0xe0, 0x71, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf0, 0xe0, 0x71, 0xe0, 0x7e, 0xe0, 0x1c, 0x70}

/* e (101) */
#define NXFONT_METRICS_101 {2, 9, 12, 1, 16, 0}
#define NXFONT_BITMAP_101 {0x1e, 0x0, 0x73, 0x0, 0x73, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xff, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xf0, 0x0, 0x78, 0x80, 0x7f, 0x0, 0x1e, 0x0}

/* f (102) */
#define NXFONT_METRICS_102 {1, 8, 17, 1, 11, 0}
#define NXFONT_BITMAP_102 {0x1e, 0x33, 0x73, 0x70, 0x70, 0xfc, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0xf8}

/* g (103) */
#define NXFONT_METRICS_103 {2, 10, 17, 1, 16, 0}
#define NXFONT_BITMAP_103 {0x3e, 0xc0, 0x77, 0xc0, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x73, 0x0, 0x3e, 0x0, 0x60, 0x0, 0xe0, 0x0, 0xff, 0x80, 0xff, 0xc0, 0x7f, 0xc0, 0xc1, 0xc0, 0xc0, 0xc0, 0xe1, 0x80, 0x7f, 0x0}

/* h (104) */
#define NXFONT_METRICS_104 {2, 12, 17, 1, 11, 0}
#define NXFONT_BITMAP_104 {0xf0, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x73, 0xc0, 0x7f, 0xe0, 0x78, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0xf9, 0xf0}

/* i (105) */
#define NXFONT_METRICS_105 {1, 5, 17, 1, 11, 0}
#define NXFONT_BITMAP_105 {0x70, 0x70, 0x70, 0x0, 0x0, 0xf0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0xf8}

/* j (106) - NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_106 {1, 7, 22, 0, 11, 0}
#define NXFONT_BITMAP_106 {0xe, 0xe, 0xe, 0x0, 0x0, 0x1e, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xe, 0xce, 0xce, 0xcc, 0x78}

/* k (107) */
#define NXFONT_METRICS_107 {2, 13, 17, 1, 11, 0}
#define NXFONT_BITMAP_107 {0xf0, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x73, 0xf0, 0x70, 0xc0, 0x71, 0x80, 0x73, 0x0, 0x76, 0x0, 0x7e, 0x0, 0x7f, 0x0, 0x77, 0x80, 0x73, 0xc0, 0x71, 0xe0, 0x70, 0xf0, 0xfb, 0xf8}

/* l (108) */
#define NXFONT_METRICS_108 {1, 5, 17, 1, 11, 0}
#define NXFONT_BITMAP_108 {0xf0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0xf8}

/* m (109) */
#define NXFONT_METRICS_109 {3, 19, 12, 1, 16, 0}
#define NXFONT_BITMAP_109 {0xf3, 0xc7, 0x80, 0x77, 0xdf, 0xc0, 0x78, 0xf1, 0xc0, 0x70, 0xe1, 0xc0, 0x70, 0xe1, 0xc0, 0x70, 0xe1, 0xc0, 0x70, 0xe1, 0xc0, 0x70, 0xe1, 0xc0, 0x70, 0xe1, 0xc0, 0x70, 0xe1, 0xc0, 0x70, 0xe1, 0xc0, 0xf9, 0xf3, 0xe0}

/* n (110) */
#define NXFONT_METRICS_110 {2, 12, 12, 1, 16, 0}
#define NXFONT_BITMAP_110 {0xf3, 0xc0, 0x77, 0xe0, 0x78, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0xf9, 0xf0}

/* o (111) */
#define NXFONT_METRICS_111 {2, 11, 12, 1, 16, 0}
#define NXFONT_BITMAP_111 {0x1f, 0x0, 0x71, 0xc0, 0x71, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x71, 0xc0, 0x71, 0xc0, 0x1f, 0x0}

/* p (112) */
#define NXFONT_METRICS_112 {2, 12, 17, 1, 16, 0}
#define NXFONT_BITMAP_112 {0xe3, 0xc0, 0x77, 0xe0, 0x78, 0xe0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x78, 0xe0, 0x77, 0xe0, 0x73, 0x80, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0xfc, 0x0}

/* q (113) */
#define NXFONT_METRICS_113 {2, 12, 17, 1, 16, 0}
#define NXFONT_BITMAP_113 {0xe, 0x60, 0x3f, 0xe0, 0x71, 0xe0, 0x70, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x71, 0xe0, 0x7e, 0xe0, 0x1c, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x1, 0xf0}

/* r (114) */
#define NXFONT_METRICS_114 {2, 9, 12, 1, 16, 0}
#define NXFONT_BITMAP_114 {0xef, 0x0, 0x7f, 0x80, 0x73, 0x80, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0xf8, 0x0}

/* s (115) */
#define NXFONT_METRICS_115 {1, 8, 12, 1, 16, 0}
#define NXFONT_BITMAP_115 {0x3e, 0x66, 0xe2, 0xe0, 0xf8, 0x7c, 0x3e, 0x1f, 0x87, 0x87, 0xc6, 0xfc}

/* t (116) */
#define NXFONT_METRICS_116 {1, 8, 16, 0, 12, 0}
#define NXFONT_BITMAP_116 {0x8, 0x18, 0x38, 0x78, 0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x39, 0x3e, 0x1c}

/* u (117) */
#define NXFONT_METRICS_117 {2, 12, 12, 1, 16, 0}
#define NXFONT_BITMAP_117 {0xf1, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x71, 0xe0, 0x7e, 0xf0, 0x3c, 0xe0}

/* v (118) */
#define NXFONT_METRICS_118 {2, 12, 12, 0, 16, 0}
#define NXFONT_BITMAP_118 {0xfc, 0xf0, 0x70, 0x60, 0x78, 0x40, 0x38, 0xc0, 0x38, 0x80, 0x1c, 0x80, 0x1d, 0x80, 0x1f, 0x0, 0xf, 0x0, 0xf, 0x0, 0x6, 0x0, 0x6, 0x0}

/* w (119) */
#define NXFONT_METRICS_119 {3, 17, 12, 0, 16, 0}
#define NXFONT_BITMAP_119 {0xfd, 0xf7, 0x80, 0x78, 0xe3, 0x0, 0x38, 0xe3, 0x0, 0x38, 0xe2, 0x0, 0x3c, 0xe6, 0x0, 0x1d, 0x76, 0x0, 0x1d, 0x74, 0x0, 0x1f, 0x3c, 0x0, 0xe, 0x38, 0x0, 0xe, 0x38, 0x0, 0x4, 0x10, 0x0, 0x4, 0x10, 0x0}

/* x (120) */
#define NXFONT_METRICS_120 {2, 12, 12, 0, 16, 0}
#define NXFONT_BITMAP_120 {0xfc, 0xf0, 0x78, 0x60, 0x3c, 0xc0, 0x1d, 0x80, 0x1f, 0x0, 0xf, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x1b, 0xc0, 0x31, 0xc0, 0x61, 0xe0, 0xf3, 0xf0}

/* y (121) */
#define NXFONT_METRICS_121 {2, 12, 17, 0, 16, 0}
#define NXFONT_BITMAP_121 {0xfd, 0xf0, 0x78, 0x60, 0x38, 0x40, 0x38, 0xc0, 0x3c, 0x80, 0x1c, 0x80, 0x1d, 0x80, 0x1f, 0x0, 0xf, 0x0, 0xf, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x64, 0x0, 0xec, 0x0, 0xf8, 0x0, 0x70, 0x0}

/* z (122) */
#define NXFONT_METRICS_122 {2, 9, 12, 1, 16, 0}
#define NXFONT_BITMAP_122 {0xff, 0x80, 0xc7, 0x0, 0x8f, 0x0, 0x8e, 0x0, 0x1e, 0x0, 0x1c, 0x0, 0x3c, 0x0, 0x38, 0x0, 0x78, 0x80, 0x71, 0x80, 0xf1, 0x80, 0xff, 0x80}

/* braceleft (123) */
#define NXFONT_METRICS_123 {1, 7, 21, 1, 11, 0}
#define NXFONT_BITMAP_123 {0xe, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x60, 0xc0, 0x60, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0xe}

/* bar (124) */
#define NXFONT_METRICS_124 {1, 2, 22, 2, 11, 0}
#define NXFONT_BITMAP_124 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* braceright (125) */
#define NXFONT_METRICS_125 {1, 7, 21, 1, 11, 0}
#define NXFONT_BITMAP_125 {0xe0, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xc, 0x6, 0xc, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0xe0}

/* asciitilde (126) */
#define NXFONT_METRICS_126 {2, 12, 6, 0, 16, 0}
#define NXFONT_BITMAP_126 {0x18, 0x0, 0x7e, 0x10, 0xff, 0x10, 0x8f, 0xf0, 0x87, 0xe0, 0x1, 0x80}

/* exclamdown (161) */
#define NXFONT_METRICS_161 {1, 4, 17, 2, 16, 0}
#define NXFONT_BITMAP_161 {0x60, 0xf0, 0xf0, 0x60, 0x0, 0x0, 0x60, 0x60, 0x60, 0x60, 0x60, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x60}

/* cent (162) */
#define NXFONT_METRICS_162 {2, 10, 18, 1, 13, 0}
#define NXFONT_BITMAP_162 {0x0, 0x80, 0x1, 0x80, 0x1, 0x0, 0x1f, 0x80, 0x73, 0xc0, 0x73, 0xc0, 0xe6, 0x80, 0xe4, 0x0, 0xe4, 0x0, 0xec, 0x0, 0xe8, 0x0, 0xf8, 0x0, 0x78, 0x80, 0x7f, 0x80, 0x3e, 0x0, 0x30, 0x0, 0x60, 0x0, 0x60, 0x0}

/* sterling (163) */
#define NXFONT_METRICS_163 {2, 11, 17, 0, 11, 0}
#define NXFONT_BITMAP_163 {0xf, 0xc0, 0x1e, 0x60, 0x3c, 0xe0, 0x3c, 0xe0, 0x3c, 0x40, 0x1c, 0x0, 0x1c, 0x0, 0xff, 0x80, 0xff, 0x80, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0xc, 0x20, 0x7c, 0x60, 0xcf, 0xe0, 0xff, 0xe0, 0x73, 0xc0}

/* currency (164) */
#define NXFONT_METRICS_164 {2, 11, 12, 0, 13, 0}
#define NXFONT_BITMAP_164 {0xc0, 0x60, 0xee, 0xe0, 0x7f, 0xc0, 0x3b, 0x80, 0x71, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x71, 0xc0, 0x3b, 0x80, 0x7f, 0xc0, 0xee, 0xe0, 0xc0, 0x60}

/* yen (165) */
#define NXFONT_METRICS_165 {2, 14, 17, 0, 11, 0}
#define NXFONT_BITMAP_165 {0xfe, 0x7c, 0x38, 0x30, 0x3c, 0x20, 0x1c, 0x60, 0x1e, 0x40, 0xe, 0xc0, 0xf, 0x80, 0x7, 0x80, 0x7, 0x0, 0x1f, 0xc0, 0x7, 0x0, 0x1f, 0xc0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x1f, 0xc0}

/* brokenbar (166) */
#define NXFONT_METRICS_166 {1, 2, 22, 2, 11, 0}
#define NXFONT_BITMAP_166 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* section (167) */
#define NXFONT_METRICS_167 {1, 7, 20, 2, 11, 0}
#define NXFONT_BITMAP_167 {0x3c, 0x6e, 0xce, 0xc6, 0xe0, 0x70, 0x78, 0x5c, 0x8e, 0x86, 0xc2, 0xe2, 0x74, 0x3c, 0x1c, 0xe, 0xc6, 0xe6, 0xec, 0x78}

/* dieresis (168) */
#define NXFONT_METRICS_168 {1, 6, 2, 1, 12, 0}
#define NXFONT_BITMAP_168 {0xcc, 0xcc}

/* copyright (169) */
#define NXFONT_METRICS_169 {3, 17, 17, 1, 11, 0}
#define NXFONT_BITMAP_169 {0x3, 0xe0, 0x0, 0xf, 0xf8, 0x0, 0x3c, 0x1e, 0x0, 0x30, 0x6, 0x0, 0x61, 0xf3, 0x0, 0x63, 0x33, 0x0, 0xc6, 0x11, 0x80, 0xc6, 0x1, 0x80, 0xc6, 0x1, 0x80, 0xc6, 0x1, 0x80, 0xc6, 0x1, 0x80, 0x63, 0x33, 0x0, 0x61, 0xe3, 0x0, 0x30, 0x6, 0x0, 0x3c, 0x1e, 0x0, 0xf, 0xf8, 0x0, 0x3, 0xe0, 0x0}

/* ordfeminine (170) */
#define NXFONT_METRICS_170 {1, 7, 10, 0, 11, 0}
#define NXFONT_BITMAP_170 {0x78, 0xdc, 0xc, 0x7c, 0xec, 0xcc, 0x7e, 0x0, 0xfe, 0xfe}

/* guillemotleft (171) */
#define NXFONT_METRICS_171 {2, 11, 10, 1, 17, 0}
#define NXFONT_BITMAP_171 {0xc, 0x60, 0x18, 0xc0, 0x31, 0x80, 0x73, 0x80, 0xe7, 0x0, 0xe7, 0x0, 0x73, 0x80, 0x31, 0x80, 0x18, 0xc0, 0xc, 0x60}

/* logicalnot (172) */
#define NXFONT_METRICS_172 {2, 11, 7, 2, 19, 0}
#define NXFONT_BITMAP_172 {0xff, 0xe0, 0xff, 0xe0, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60}

/* hyphen (173) */
#define NXFONT_METRICS_173 {1, 6, 3, 1, 20, 0}
#define NXFONT_BITMAP_173 {0xfc, 0xfc, 0xfc}

/* registered (174) */
#define NXFONT_METRICS_174 {3, 17, 17, 1, 11, 0}
#define NXFONT_BITMAP_174 {0x3, 0xe0, 0x0, 0xf, 0xf8, 0x0, 0x3c, 0x1e, 0x0, 0x30, 0x6, 0x0, 0x67, 0xe3, 0x0, 0x63, 0x33, 0x0, 0xc3, 0x31, 0x80, 0xc3, 0x31, 0x80, 0xc3, 0xe1, 0x80, 0xc3, 0x61, 0x80, 0xc3, 0x31, 0x80, 0x63, 0x33, 0x0, 0x67, 0xbb, 0x0, 0x30, 0x6, 0x0, 0x3c, 0x1e, 0x0, 0xf, 0xf8, 0x0, 0x3, 0xe0, 0x0}

/* macron (175) */
#define NXFONT_METRICS_175 {1, 6, 1, 1, 13, 0}
#define NXFONT_BITMAP_175 {0xfc}

/* degree (176) */
#define NXFONT_METRICS_176 {1, 8, 7, 0, 11, 0}
#define NXFONT_BITMAP_176 {0x3c, 0x66, 0xc3, 0xc3, 0xc3, 0x66, 0x3c}

/* plusminus (177) */
#define NXFONT_METRICS_177 {2, 12, 13, 1, 15, 0}
#define NXFONT_BITMAP_177 {0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0xff, 0xf0, 0xff, 0xf0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x0, 0x0, 0xff, 0xf0, 0xff, 0xf0}

/* twosuperior (178) */
#define NXFONT_METRICS_178 {1, 6, 10, 0, 11, 0}
#define NXFONT_BITMAP_178 {0x38, 0x7c, 0x8c, 0xc, 0x18, 0x10, 0x20, 0x40, 0xfc, 0xfc}

/* threesuperior (179) */
#define NXFONT_METRICS_179 {1, 6, 10, 0, 11, 0}
#define NXFONT_BITMAP_179 {0x38, 0x7c, 0x8c, 0xc, 0x38, 0x1c, 0xc, 0x8c, 0xf8, 0x70}

/* acute (180) */
#define NXFONT_METRICS_180 {1, 5, 4, 2, 11, 0}
#define NXFONT_BITMAP_180 {0x38, 0x70, 0x60, 0xc0}

/* mu (181) */
#define NXFONT_METRICS_181 {2, 12, 17, 1, 16, 0}
#define NXFONT_BITMAP_181 {0xf1, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x71, 0xe0, 0x7e, 0xf0, 0x6c, 0xe0, 0x60, 0x0, 0x60, 0x0, 0xe0, 0x0, 0xf0, 0x0, 0x60, 0x0}

/* paragraph (182) */
#define NXFONT_METRICS_182 {2, 11, 22, 1, 11, 0}
#define NXFONT_BITMAP_182 {0x1f, 0xe0, 0x7f, 0xe0, 0x7e, 0x40, 0xfe, 0x40, 0xfe, 0x40, 0xfe, 0x40, 0xfe, 0x40, 0xfe, 0x40, 0xfe, 0x40, 0x7e, 0x40, 0x7e, 0x40, 0x1e, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40}

/* periodcentered (183) */
#define NXFONT_METRICS_183 {1, 3, 3, 1, 19, 0}
#define NXFONT_BITMAP_183 {0xe0, 0xe0, 0xe0}

/* cedilla (184) */
#define NXFONT_METRICS_184 {1, 6, 6, 1, 28, 0}
#define NXFONT_BITMAP_184 {0x10, 0x30, 0x38, 0xc, 0x8c, 0x78}

/* onesuperior (185) */
#define NXFONT_METRICS_185 {1, 6, 10, 0, 11, 0}
#define NXFONT_BITMAP_185 {0x30, 0xf0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xfc}

/* ordmasculine (186) */
#define NXFONT_METRICS_186 {1, 7, 10, 0, 11, 0}
#define NXFONT_BITMAP_186 {0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x0, 0xfe, 0xfe}

/* guillemotright (187) */
#define NXFONT_METRICS_187 {2, 11, 10, 1, 17, 0}
#define NXFONT_BITMAP_187 {0xc6, 0x0, 0x63, 0x0, 0x31, 0x80, 0x39, 0xc0, 0x1c, 0xe0, 0x1c, 0xe0, 0x39, 0xc0, 0x33, 0x80, 0x63, 0x0, 0xc6, 0x0}

/* onequarter (188) */
#define NXFONT_METRICS_188 {3, 17, 17, 0, 11, 0}
#define NXFONT_BITMAP_188 {0x30, 0x4, 0x0, 0xf0, 0xc, 0x0, 0x30, 0x18, 0x0, 0x30, 0x18, 0x0, 0x30, 0x30, 0x0, 0x30, 0x20, 0x0, 0x30, 0x60, 0x0, 0x30, 0x42, 0x0, 0x30, 0xc6, 0x0, 0xfc, 0x8e, 0x0, 0x1, 0x8e, 0x0, 0x1, 0x16, 0x0, 0x3, 0x36, 0x0, 0x6, 0x26, 0x0, 0x6, 0x7f, 0x80, 0xc, 0x6, 0x0, 0x8, 0x6, 0x0}

/* onehalf (189) */
#define NXFONT_METRICS_189 {3, 17, 17, 0, 11, 0}
#define NXFONT_BITMAP_189 {0x30, 0x4, 0x0, 0xf0, 0xc, 0x0, 0x30, 0x18, 0x0, 0x30, 0x18, 0x0, 0x30, 0x30, 0x0, 0x30, 0x20, 0x0, 0x30, 0x60, 0x0, 0x30, 0x47, 0x0, 0x30, 0xcf, 0x80, 0xfc, 0x91, 0x80, 0x1, 0x81, 0x80, 0x1, 0x3, 0x0, 0x3, 0x2, 0x0, 0x6, 0x4, 0x0, 0x6, 0x8, 0x0, 0xc, 0x1f, 0x80, 0x8, 0x1f, 0x80}

/* threequarters (190) */
#define NXFONT_METRICS_190 {3, 17, 17, 1, 11, 0}
#define NXFONT_BITMAP_190 {0x38, 0x4, 0x0, 0x7c, 0xc, 0x0, 0x8c, 0x18, 0x0, 0xc, 0x18, 0x0, 0x38, 0x30, 0x0, 0x1c, 0x20, 0x0, 0xc, 0x60, 0x0, 0x8c, 0x42, 0x0, 0xf8, 0xc6, 0x0, 0x71, 0xe, 0x0, 0x3, 0xe, 0x0, 0x2, 0x16, 0x0, 0x6, 0x36, 0x0, 0xc, 0x26, 0x0, 0xc, 0x7f, 0x80, 0x18, 0x6, 0x0, 0x10, 0x6, 0x0}

/* questiondown (191) */
#define NXFONT_METRICS_191 {2, 9, 17, 1, 16, 0}
#define NXFONT_BITMAP_191 {0xc, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0xc, 0x0, 0x1c, 0x0, 0x38, 0x0, 0x78, 0x0, 0xf0, 0x0, 0xf1, 0x0, 0xf3, 0x80, 0xf3, 0x80, 0x7b, 0x0, 0x3e, 0x0}

/* Agrave (192) */
#define NXFONT_METRICS_192 {3, 17, 22, 0, 6, 0}
#define NXFONT_BITMAP_192 {0x3, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x3, 0xc0, 0x0, 0x3, 0xe0, 0x0, 0x3, 0xe0, 0x0, 0x6, 0xe0, 0x0, 0x6, 0xf0, 0x0, 0x4, 0x70, 0x0, 0xc, 0x70, 0x0, 0x8, 0x78, 0x0, 0x8, 0x38, 0x0, 0x1f, 0xf8, 0x0, 0x10, 0x3c, 0x0, 0x30, 0x3c, 0x0, 0x30, 0x1e, 0x0, 0x70, 0x1e, 0x0, 0xf8, 0x7f, 0x80}

/* Aacute (193) */
#define NXFONT_METRICS_193 {3, 17, 22, 0, 6, 0}
#define NXFONT_BITMAP_193 {0x0, 0xe0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0x80, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x3, 0xc0, 0x0, 0x3, 0xe0, 0x0, 0x3, 0xe0, 0x0, 0x6, 0xe0, 0x0, 0x6, 0xf0, 0x0, 0x4, 0x70, 0x0, 0xc, 0x70, 0x0, 0x8, 0x78, 0x0, 0x8, 0x38, 0x0, 0x1f, 0xf8, 0x0, 0x10, 0x3c, 0x0, 0x30, 0x3c, 0x0, 0x30, 0x1e, 0x0, 0x70, 0x1e, 0x0, 0xf8, 0x7f, 0x80}

/* Acircumflex (194) */
#define NXFONT_METRICS_194 {3, 17, 22, 0, 6, 0}
#define NXFONT_BITMAP_194 {0x1, 0x80, 0x0, 0x3, 0xc0, 0x0, 0x6, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x3, 0xc0, 0x0, 0x3, 0xe0, 0x0, 0x3, 0xe0, 0x0, 0x6, 0xe0, 0x0, 0x6, 0xf0, 0x0, 0x4, 0x70, 0x0, 0xc, 0x70, 0x0, 0x8, 0x78, 0x0, 0x8, 0x38, 0x0, 0x1f, 0xf8, 0x0, 0x10, 0x3c, 0x0, 0x30, 0x3c, 0x0, 0x30, 0x1e, 0x0, 0x70, 0x1e, 0x0, 0xf8, 0x7f, 0x80}

/* Atilde (195) */
#define NXFONT_METRICS_195 {3, 17, 21, 0, 7, 0}
#define NXFONT_BITMAP_195 {0x3, 0x10, 0x0, 0x7, 0xe0, 0x0, 0x8, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x3, 0xc0, 0x0, 0x3, 0xe0, 0x0, 0x3, 0xe0, 0x0, 0x6, 0xe0, 0x0, 0x6, 0xf0, 0x0, 0x4, 0x70, 0x0, 0xc, 0x70, 0x0, 0x8, 0x78, 0x0, 0x8, 0x38, 0x0, 0x1f, 0xf8, 0x0, 0x10, 0x3c, 0x0, 0x30, 0x3c, 0x0, 0x30, 0x1e, 0x0, 0x70, 0x1e, 0x0, 0xf8, 0x7f, 0x80}

/* Adieresis (196) */
#define NXFONT_METRICS_196 {3, 17, 21, 0, 7, 0}
#define NXFONT_BITMAP_196 {0x6, 0x60, 0x0, 0x6, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x3, 0xc0, 0x0, 0x3, 0xe0, 0x0, 0x3, 0xe0, 0x0, 0x6, 0xe0, 0x0, 0x6, 0xf0, 0x0, 0x4, 0x70, 0x0, 0xc, 0x70, 0x0, 0x8, 0x78, 0x0, 0x8, 0x38, 0x0, 0x1f, 0xf8, 0x0, 0x10, 0x3c, 0x0, 0x30, 0x3c, 0x0, 0x30, 0x1e, 0x0, 0x70, 0x1e, 0x0, 0xf8, 0x7f, 0x80}

/* Aring (197) */
#define NXFONT_METRICS_197 {3, 17, 23, 0, 5, 0}
#define NXFONT_BITMAP_197 {0x1, 0x80, 0x0, 0x3, 0xc0, 0x0, 0x6, 0x60, 0x0, 0x6, 0x60, 0x0, 0x3, 0xc0, 0x0, 0x1, 0x80, 0x0, 0x1, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x3, 0xc0, 0x0, 0x3, 0xe0, 0x0, 0x3, 0xe0, 0x0, 0x6, 0xe0, 0x0, 0x6, 0xf0, 0x0, 0x4, 0x70, 0x0, 0xc, 0x70, 0x0, 0x8, 0x78, 0x0, 0x8, 0x38, 0x0, 0x1f, 0xf8, 0x0, 0x10, 0x3c, 0x0, 0x30, 0x3c, 0x0, 0x30, 0x1e, 0x0, 0x70, 0x1e, 0x0, 0xf8, 0x7f, 0x80}

/* AE (198) */
#define NXFONT_METRICS_198 {3, 23, 17, 0, 11, 0}
#define NXFONT_BITMAP_198 {0x1, 0xff, 0xfc, 0x0, 0x7c, 0x1c, 0x0, 0xfc, 0xc, 0x0, 0xbc, 0x4, 0x1, 0xbc, 0x4, 0x1, 0x3c, 0x20, 0x3, 0x3c, 0x20, 0x2, 0x3c, 0x60, 0x6, 0x3f, 0xe0, 0x7, 0xfc, 0x60, 0xc, 0x3c, 0x20, 0x8, 0x3c, 0x20, 0x18, 0x3c, 0x2, 0x10, 0x3c, 0x2, 0x30, 0x3c, 0x6, 0x70, 0x3c, 0xe, 0xf8, 0xff, 0xfe}

/* Ccedilla (199) */
#define NXFONT_METRICS_199 {2, 15, 23, 1, 11, 0}
#define NXFONT_BITMAP_199 {0x3, 0xf2, 0x1e, 0x3e, 0x3c, 0xe, 0x78, 0x6, 0x78, 0x2, 0xf0, 0x2, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0x78, 0x0, 0x78, 0x2, 0x3c, 0xe, 0x1f, 0x3c, 0x7, 0xf0, 0x1, 0x0, 0x3, 0x0, 0x3, 0x80, 0x0, 0xc0, 0x8, 0xc0, 0x7, 0x80}

/* Egrave (200) */
#define NXFONT_METRICS_200 {2, 15, 22, 1, 6, 0}
#define NXFONT_BITMAP_200 {0x7, 0x0, 0x3, 0x80, 0x1, 0x80, 0x0, 0xc0, 0x0, 0x0, 0xff, 0xfc, 0x3c, 0x1c, 0x3c, 0xc, 0x3c, 0x4, 0x3c, 0x4, 0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x60, 0x3f, 0xe0, 0x3c, 0x60, 0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x2, 0x3c, 0x2, 0x3c, 0x6, 0x3c, 0xe, 0xff, 0xfe}

/* Eacute (201) */
#define NXFONT_METRICS_201 {2, 15, 22, 1, 6, 0}
#define NXFONT_BITMAP_201 {0x1, 0xc0, 0x3, 0x80, 0x3, 0x0, 0x6, 0x0, 0x0, 0x0, 0xff, 0xfc, 0x3c, 0x1c, 0x3c, 0xc, 0x3c, 0x4, 0x3c, 0x4, 0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x60, 0x3f, 0xe0, 0x3c, 0x60, 0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x2, 0x3c, 0x2, 0x3c, 0x6, 0x3c, 0xe, 0xff, 0xfe}

/* Ecircumflex (202) */
#define NXFONT_METRICS_202 {2, 15, 22, 1, 6, 0}
#define NXFONT_BITMAP_202 {0x3, 0x0, 0x7, 0x80, 0xc, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xfc, 0x3c, 0x1c, 0x3c, 0xc, 0x3c, 0x4, 0x3c, 0x4, 0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x60, 0x3f, 0xe0, 0x3c, 0x60, 0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x2, 0x3c, 0x2, 0x3c, 0x6, 0x3c, 0xe, 0xff, 0xfe}

/* Edieresis (203) */
#define NXFONT_METRICS_203 {2, 15, 21, 1, 7, 0}
#define NXFONT_BITMAP_203 {0xc, 0xc0, 0xc, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xfc, 0x3c, 0x1c, 0x3c, 0xc, 0x3c, 0x4, 0x3c, 0x4, 0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x60, 0x3f, 0xe0, 0x3c, 0x60, 0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x2, 0x3c, 0x2, 0x3c, 0x6, 0x3c, 0xe, 0xff, 0xfe}

/* Igrave (204) */
#define NXFONT_METRICS_204 {1, 8, 22, 0, 6, 0}
#define NXFONT_BITMAP_204 {0x70, 0x38, 0x18, 0xc, 0x0, 0xff, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0xff}

/* Iacute (205) */
#define NXFONT_METRICS_205 {1, 8, 22, 0, 6, 0}
#define NXFONT_BITMAP_205 {0xe, 0x1c, 0x18, 0x30, 0x0, 0xff, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0xff}

/* Icircumflex (206) */
#define NXFONT_METRICS_206 {1, 8, 22, 0, 6, 0}
#define NXFONT_BITMAP_206 {0x18, 0x3c, 0x66, 0x0, 0x0, 0xff, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0xff}

/* Idieresis (207) */
#define NXFONT_METRICS_207 {1, 8, 21, 0, 7, 0}
#define NXFONT_BITMAP_207 {0x66, 0x66, 0x0, 0x0, 0xff, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0xff}

/* Eth (208) */
#define NXFONT_METRICS_208 {2, 16, 17, 1, 11, 0}
#define NXFONT_BITMAP_208 {0xff, 0xe0, 0x3c, 0x78, 0x3c, 0x3c, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0xf, 0x3c, 0xf, 0xff, 0x8f, 0xff, 0x8f, 0x3c, 0xf, 0x3c, 0xf, 0x3c, 0xe, 0x3c, 0x1e, 0x3c, 0x1c, 0x3c, 0x3c, 0x3c, 0x78, 0xff, 0xe0}

/* Ntilde (209) */
#define NXFONT_METRICS_209 {3, 17, 22, 0, 6, 0}
#define NXFONT_BITMAP_209 {0x1, 0x88, 0x0, 0x3, 0xf0, 0x0, 0x4, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0xf, 0x80, 0x7c, 0x7, 0x0, 0x3e, 0x2, 0x0, 0x3f, 0x2, 0x0, 0x3f, 0x82, 0x0, 0x2f, 0xc2, 0x0, 0x27, 0xe2, 0x0, 0x23, 0xe2, 0x0, 0x21, 0xf2, 0x0, 0x20, 0xfa, 0x0, 0x20, 0x7e, 0x0, 0x20, 0x3e, 0x0, 0x20, 0x1e, 0x0, 0x20, 0xe, 0x0, 0x20, 0xe, 0x0, 0x60, 0x6, 0x0, 0xf8, 0x2, 0x0}

/* Ograve (210) */
#define NXFONT_METRICS_210 {2, 16, 22, 1, 6, 0}
#define NXFONT_BITMAP_210 {0x7, 0x0, 0x3, 0x80, 0x1, 0x80, 0x0, 0xc0, 0x0, 0x0, 0x7, 0xe0, 0x1e, 0x78, 0x3c, 0x3c, 0x78, 0x1e, 0x78, 0x1e, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0x78, 0x1e, 0x78, 0x1e, 0x3c, 0x3c, 0x1e, 0x78, 0x7, 0xe0}

/* Oacute (211) */
#define NXFONT_METRICS_211 {2, 16, 22, 1, 6, 0}
#define NXFONT_BITMAP_211 {0x0, 0x70, 0x0, 0xe0, 0x0, 0xc0, 0x1, 0x80, 0x0, 0x0, 0x7, 0xe0, 0x1e, 0x78, 0x3c, 0x3c, 0x78, 0x1e, 0x78, 0x1e, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0x78, 0x1e, 0x78, 0x1e, 0x3c, 0x3c, 0x1e, 0x78, 0x7, 0xe0}

/* Ocircumflex (212) */
#define NXFONT_METRICS_212 {2, 16, 22, 1, 6, 0}
#define NXFONT_BITMAP_212 {0x1, 0x80, 0x3, 0xc0, 0x6, 0x60, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x1e, 0x78, 0x3c, 0x3c, 0x78, 0x1e, 0x78, 0x1e, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0x78, 0x1e, 0x78, 0x1e, 0x3c, 0x3c, 0x1e, 0x78, 0x7, 0xe0}

/* Otilde (213) */
#define NXFONT_METRICS_213 {2, 16, 22, 1, 6, 0}
#define NXFONT_BITMAP_213 {0x3, 0x10, 0x7, 0xe0, 0x8, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x1e, 0x78, 0x3c, 0x3c, 0x78, 0x1e, 0x78, 0x1e, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0x78, 0x1e, 0x78, 0x1e, 0x3c, 0x3c, 0x1e, 0x78, 0x7, 0xe0}

/* Odieresis (214) */
#define NXFONT_METRICS_214 {2, 16, 21, 1, 7, 0}
#define NXFONT_BITMAP_214 {0xc, 0x60, 0xc, 0x60, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x1e, 0x78, 0x3c, 0x3c, 0x78, 0x1e, 0x78, 0x1e, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0xf0, 0xf, 0x78, 0x1e, 0x78, 0x1e, 0x3c, 0x3c, 0x1e, 0x78, 0x7, 0xe0}

/* multiply (215) */
#define NXFONT_METRICS_215 {2, 12, 12, 1, 16, 0}
#define NXFONT_BITMAP_215 {0xc0, 0x30, 0xe0, 0x70, 0x70, 0xe0, 0x39, 0xc0, 0x1f, 0x80, 0xf, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x39, 0xc0, 0x70, 0xe0, 0xe0, 0x70, 0xc0, 0x30}

/* Oslash (216) */
#define NXFONT_METRICS_216 {2, 16, 19, 1, 10, 0}
#define NXFONT_BITMAP_216 {0x0, 0x4, 0x7, 0xec, 0x1e, 0x78, 0x38, 0x1c, 0x78, 0x3e, 0x78, 0x3e, 0xf0, 0x6f, 0xf0, 0xcf, 0xf0, 0xcf, 0xf1, 0x8f, 0xf3, 0xf, 0xf3, 0xf, 0xf6, 0xf, 0x7c, 0x1e, 0x7c, 0x1e, 0x38, 0x1c, 0x3e, 0x78, 0x37, 0xe0, 0x60, 0x0}

/* Ugrave (217) */
#define NXFONT_METRICS_217 {3, 17, 22, 0, 6, 0}
#define NXFONT_BITMAP_217 {0x3, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf, 0x80, 0x3e, 0x6, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x6, 0x0, 0x1e, 0x4, 0x0, 0x1f, 0x1c, 0x0, 0x7, 0xf8, 0x0}

/* Uacute (218) */
#define NXFONT_METRICS_218 {3, 17, 22, 0, 6, 0}
#define NXFONT_BITMAP_218 {0x0, 0x38, 0x0, 0x0, 0x70, 0x0, 0x0, 0x60, 0x0, 0x0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf, 0x80, 0x3e, 0x6, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x6, 0x0, 0x1e, 0x4, 0x0, 0x1f, 0x1c, 0x0, 0x7, 0xf8, 0x0}

/* Ucircumflex (219) */
#define NXFONT_METRICS_219 {3, 17, 22, 0, 6, 0}
#define NXFONT_BITMAP_219 {0x0, 0x60, 0x0, 0x0, 0xf0, 0x0, 0x1, 0x98, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf, 0x80, 0x3e, 0x6, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x6, 0x0, 0x1e, 0x4, 0x0, 0x1f, 0x1c, 0x0, 0x7, 0xf8, 0x0}

/* Udieresis (220) */
#define NXFONT_METRICS_220 {3, 17, 21, 0, 7, 0}
#define NXFONT_BITMAP_220 {0x3, 0x18, 0x0, 0x3, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf, 0x80, 0x3e, 0x6, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x2, 0x0, 0x3c, 0x6, 0x0, 0x1e, 0x4, 0x0, 0x1f, 0x1c, 0x0, 0x7, 0xf8, 0x0}

/* Yacute (221) */
#define NXFONT_METRICS_221 {3, 18, 23, 0, 5, 0}
#define NXFONT_BITMAP_221 {0x0, 0xe, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x18, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x8f, 0xc0, 0x3e, 0x3, 0x0, 0x1e, 0x2, 0x0, 0xf, 0x6, 0x0, 0xf, 0xc, 0x0, 0x7, 0x8c, 0x0, 0x7, 0x98, 0x0, 0x3, 0xd0, 0x0, 0x3, 0xf0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x7, 0xf8, 0x0}

/* Thorn (222) */
#define NXFONT_METRICS_222 {2, 14, 17, 0, 11, 0}
#define NXFONT_BITMAP_222 {0xff, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3f, 0xe0, 0x3c, 0x78, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x78, 0x3f, 0xe0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0xff, 0x0}

/* germandbls (223) */
#define NXFONT_METRICS_223 {2, 11, 17, 1, 11, 0}
#define NXFONT_BITMAP_223 {0x1f, 0x0, 0x39, 0x80, 0x71, 0xc0, 0x71, 0xc0, 0x71, 0xc0, 0x71, 0xc0, 0x73, 0x80, 0x77, 0x0, 0x73, 0x80, 0x71, 0xc0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xc0, 0xf3, 0x80}

/* agrave (224) */
#define NXFONT_METRICS_224 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_224 {0x38, 0x0, 0x1c, 0x0, 0xc, 0x0, 0x6, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x77, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0x43, 0x80, 0xf, 0x80, 0x73, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0xc0, 0x71, 0x80}

/* aacute (225) */
#define NXFONT_METRICS_225 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_225 {0xe, 0x0, 0x1c, 0x0, 0x18, 0x0, 0x30, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x77, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0x43, 0x80, 0xf, 0x80, 0x73, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0xc0, 0x71, 0x80}

/* acircumflex (226) */
#define NXFONT_METRICS_226 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_226 {0xc, 0x0, 0x1e, 0x0, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x77, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0x43, 0x80, 0xf, 0x80, 0x73, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0xc0, 0x71, 0x80}

/* atilde (227) */
#define NXFONT_METRICS_227 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_227 {0x18, 0x80, 0x3f, 0x0, 0x46, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x77, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0x43, 0x80, 0xf, 0x80, 0x73, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0xc0, 0x71, 0x80}

/* adieresis (228) */
#define NXFONT_METRICS_228 {2, 10, 16, 1, 12, 0}
#define NXFONT_BITMAP_228 {0x33, 0x0, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x77, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0x43, 0x80, 0xf, 0x80, 0x73, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0xc0, 0x71, 0x80}

/* aring (229) */
#define NXFONT_METRICS_229 {2, 10, 18, 1, 10, 0}
#define NXFONT_BITMAP_229 {0xc, 0x0, 0x1e, 0x0, 0x33, 0x0, 0x33, 0x0, 0x1e, 0x0, 0xc, 0x0, 0x3e, 0x0, 0x77, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0x43, 0x80, 0xf, 0x80, 0x73, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0xc0, 0x71, 0x80}

/* ae (230) */
#define NXFONT_METRICS_230 {2, 15, 12, 1, 16, 0}
#define NXFONT_BITMAP_230 {0x3e, 0x78, 0x77, 0xcc, 0xe3, 0xce, 0x63, 0x8e, 0x3, 0x8e, 0x1f, 0xfe, 0x73, 0x80, 0xe3, 0x80, 0xe3, 0xc0, 0xe7, 0xe2, 0xfe, 0xfc, 0x7c, 0x78}

/* ccedilla (231) */
#define NXFONT_METRICS_231 {2, 9, 18, 1, 16, 0}
#define NXFONT_BITMAP_231 {0x1e, 0x0, 0x73, 0x0, 0x73, 0x80, 0xe3, 0x80, 0xe1, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xf0, 0x0, 0x78, 0x80, 0x7f, 0x0, 0x1e, 0x0, 0x8, 0x0, 0x18, 0x0, 0x1c, 0x0, 0x6, 0x0, 0x46, 0x0, 0x3c, 0x0}

/* egrave (232) */
#define NXFONT_METRICS_232 {2, 9, 17, 1, 11, 0}
#define NXFONT_BITMAP_232 {0x38, 0x0, 0x1c, 0x0, 0xc, 0x0, 0x6, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x73, 0x0, 0x73, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xff, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xf0, 0x0, 0x78, 0x80, 0x7f, 0x0, 0x1e, 0x0}

/* eacute (233) */
#define NXFONT_METRICS_233 {2, 9, 17, 1, 11, 0}
#define NXFONT_BITMAP_233 {0xe, 0x0, 0x1c, 0x0, 0x18, 0x0, 0x30, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x73, 0x0, 0x73, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xff, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xf0, 0x0, 0x78, 0x80, 0x7f, 0x0, 0x1e, 0x0}

/* ecircumflex (234) */
#define NXFONT_METRICS_234 {2, 9, 17, 1, 11, 0}
#define NXFONT_BITMAP_234 {0x18, 0x0, 0x3c, 0x0, 0x66, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x73, 0x0, 0x73, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xff, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xf0, 0x0, 0x78, 0x80, 0x7f, 0x0, 0x1e, 0x0}

/* edieresis (235) */
#define NXFONT_METRICS_235 {2, 9, 16, 1, 12, 0}
#define NXFONT_BITMAP_235 {0x33, 0x0, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x73, 0x0, 0x73, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xff, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xf0, 0x0, 0x78, 0x80, 0x7f, 0x0, 0x1e, 0x0}

/* igrave (236) */
#define NXFONT_METRICS_236 {1, 5, 17, 1, 11, 0}
#define NXFONT_BITMAP_236 {0xe0, 0x70, 0x30, 0x18, 0x0, 0xf0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0xf8}

/* iacute (237) */
#define NXFONT_METRICS_237 {1, 6, 17, 1, 11, 0}
#define NXFONT_BITMAP_237 {0x1c, 0x38, 0x30, 0x60, 0x0, 0xf0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0xf8}

/* icircumflex (238) */
#define NXFONT_METRICS_238 {1, 6, 17, 1, 11, 0}
#define NXFONT_BITMAP_238 {0x30, 0x78, 0xcc, 0x0, 0x0, 0xf0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0xf8}

/* idieresis (239) */
#define NXFONT_METRICS_239 {1, 6, 16, 1, 12, 0}
#define NXFONT_BITMAP_239 {0xcc, 0xcc, 0x0, 0x0, 0xf0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0xf8}

/* eth (240) */
#define NXFONT_METRICS_240 {2, 11, 17, 1, 11, 0}
#define NXFONT_BITMAP_240 {0x60, 0x0, 0x38, 0xc0, 0xf, 0x0, 0x1e, 0x0, 0x63, 0x0, 0x1f, 0x80, 0x7b, 0xc0, 0x71, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x71, 0xc0, 0x7b, 0xc0, 0x1f, 0x0}

/* ntilde (241) */
#define NXFONT_METRICS_241 {2, 12, 17, 1, 11, 0}
#define NXFONT_BITMAP_241 {0xc, 0x40, 0x1f, 0x80, 0x23, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf3, 0xc0, 0x77, 0xe0, 0x78, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0xf9, 0xf0}

/* ograve (242) */
#define NXFONT_METRICS_242 {2, 11, 17, 1, 11, 0}
#define NXFONT_BITMAP_242 {0x1c, 0x0, 0xe, 0x0, 0x6, 0x0, 0x3, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x7b, 0xc0, 0x71, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x71, 0xc0, 0x7b, 0xc0, 0x1f, 0x0}

/* oacute (243) */
#define NXFONT_METRICS_243 {2, 11, 17, 1, 11, 0}
#define NXFONT_BITMAP_243 {0x3, 0x80, 0x7, 0x0, 0x6, 0x0, 0xc, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x7b, 0xc0, 0x71, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x71, 0xc0, 0x7b, 0xc0, 0x1f, 0x0}

/* ocircumflex (244) */
#define NXFONT_METRICS_244 {2, 11, 17, 1, 11, 0}
#define NXFONT_BITMAP_244 {0xc, 0x0, 0x1e, 0x0, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x7b, 0xc0, 0x71, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x71, 0xc0, 0x7b, 0xc0, 0x1f, 0x0}

/* otilde (245) */
#define NXFONT_METRICS_245 {2, 11, 17, 1, 11, 0}
#define NXFONT_BITMAP_245 {0x18, 0x80, 0x3f, 0x0, 0x46, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x7b, 0xc0, 0x71, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x71, 0xc0, 0x7b, 0xc0, 0x1f, 0x0}

/* odieresis (246) */
#define NXFONT_METRICS_246 {2, 11, 16, 1, 12, 0}
#define NXFONT_BITMAP_246 {0x31, 0x80, 0x31, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x7b, 0xc0, 0x71, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x71, 0xc0, 0x7b, 0xc0, 0x1f, 0x0}

/* divide (247) */
#define NXFONT_METRICS_247 {2, 12, 12, 1, 16, 0}
#define NXFONT_BITMAP_247 {0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf0, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0}

/* oslash (248) */
#define NXFONT_METRICS_248 {2, 11, 16, 1, 14, 0}
#define NXFONT_BITMAP_248 {0x0, 0x40, 0x0, 0x40, 0x1e, 0x80, 0x79, 0xc0, 0x71, 0xc0, 0xe2, 0xe0, 0xe2, 0xe0, 0xe4, 0xe0, 0xe4, 0xe0, 0xe8, 0xe0, 0xe8, 0xe0, 0x71, 0xc0, 0x7b, 0xc0, 0x3f, 0x0, 0x40, 0x0, 0x40, 0x0}

/* ugrave (249) */
#define NXFONT_METRICS_249 {2, 12, 17, 1, 11, 0}
#define NXFONT_BITMAP_249 {0x1c, 0x0, 0xe, 0x0, 0x6, 0x0, 0x3, 0x0, 0x0, 0x0, 0xf1, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x71, 0xe0, 0x7e, 0xf0, 0x3c, 0xe0}

/* uacute (250) */
#define NXFONT_METRICS_250 {2, 12, 17, 1, 11, 0}
#define NXFONT_BITMAP_250 {0x7, 0x0, 0xe, 0x0, 0xc, 0x0, 0x18, 0x0, 0x0, 0x0, 0xf1, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x71, 0xe0, 0x7e, 0xf0, 0x3c, 0xe0}

/* ucircumflex (251) */
#define NXFONT_METRICS_251 {2, 12, 17, 1, 11, 0}
#define NXFONT_BITMAP_251 {0x6, 0x0, 0xf, 0x0, 0x19, 0x80, 0x0, 0x0, 0x0, 0x0, 0xf1, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x71, 0xe0, 0x7e, 0xf0, 0x3c, 0xe0}

/* udieresis (252) */
#define NXFONT_METRICS_252 {2, 12, 16, 1, 12, 0}
#define NXFONT_BITMAP_252 {0x19, 0x80, 0x19, 0x80, 0x0, 0x0, 0x0, 0x0, 0xf1, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x71, 0xe0, 0x7e, 0xf0, 0x3c, 0xe0}

/* yacute (253) */
#define NXFONT_METRICS_253 {2, 12, 22, 0, 11, 0}
#define NXFONT_BITMAP_253 {0x1, 0xc0, 0x3, 0x80, 0x3, 0x0, 0x6, 0x0, 0x0, 0x0, 0xfd, 0xf0, 0x78, 0x60, 0x38, 0x40, 0x38, 0xc0, 0x3c, 0x80, 0x1c, 0x80, 0x1d, 0x80, 0x1f, 0x0, 0xf, 0x0, 0xf, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x64, 0x0, 0xec, 0x0, 0xf8, 0x0, 0x70, 0x0}

/* thorn (254) */
#define NXFONT_METRICS_254 {2, 12, 22, 1, 11, 0}
#define NXFONT_BITMAP_254 {0xf0, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x73, 0x80, 0x77, 0xe0, 0x7c, 0xe0, 0x78, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x78, 0xe0, 0x77, 0xe0, 0x73, 0x80, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0, 0xfc, 0x0}

/* ydieresis (255) */
#define NXFONT_METRICS_255 {2, 12, 21, 0, 12, 0}
#define NXFONT_BITMAP_255 {0x19, 0x80, 0x19, 0x80, 0x0, 0x0, 0x0, 0x0, 0xfd, 0xf0, 0x78, 0x60, 0x38, 0x40, 0x38, 0xc0, 0x3c, 0x80, 0x1c, 0x80, 0x1d, 0x80, 0x1f, 0x0, 0xf, 0x0, 0xf, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x64, 0x0, 0xec, 0x0, 0xf8, 0x0, 0x70, 0x0}

/****************************************************************************
 * Public Types
 ****************************************************************************/

/****************************************************************************
 * Public Data
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
#define EXTERN extern "C"
extern "C"
{
#else
#define EXTERN extern
#endif

/****************************************************************************
 * Public Functions Definitions
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
}
#endif

#endif /* __LIBS_LIBNX_NXFONTS_NXFONTS_SERIF27X38B_H */
