# Contribution to Apache NuttX

Hi! Thank you for wanting to contribute to Apache NuttX.

## Guidelines

In order to help us review your contribution successfully
it is very important you follow these guidelines:

  * Use descriptive **commit messages** and, if the change
    warrants further description, do add a separate paragraph
    like so:

        <first line (up to ~80 characters)>

        <more paragraphs here>

  * Be sure to **fill in** the pull-request template with
    meaningful content (be very descriptive, take your time).
    Do **not** remove these sections or ignore them.

    * **Tip**: if you create a commit message as above, the
      first line will be automatically used as PR title
      and the rest added to the description. Use it as a
      starting point to describe your PR.

  * You should follow [NuttX C Coding Standard](https://nuttx.apache.org/docs/latest/contributing/coding_style.html)

    * Your code will be automatically checked by GitHub
      Continuous Integration (CI) system. If you see the
      "check" step fails, it is possible that this happens
      due to style errors.

    * Note that we require you to solve these issues
      and adapt all modified files even if you didn't
      introduce the problem yourself (this way, every
      contribution gets us closer to compliance).

## For more information

For general notes on contributing to Apache NuttX continue reading [here](https://nuttx.apache.org/docs/latest/contributing/index.html).
