/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.nifi.security.cert;

import java.security.cert.X509Certificate;

/**
 * Abstraction for retrieving and formatting X.509 Certificate Subject and Issuer Principal Distinguished Names
 */
public interface PrincipalFormatter {
    /**
     * Get Subject Distinguished Name formatted as a string according to standard implementation conventions
     *
     * @param certificate X.509 Certificate
     * @return Formatted Subject Distinguished Name
     */
    String getSubject(X509Certificate certificate);

    /**
     * Get Issuer Distinguished Name formatted as a string according to standard implementation conventions
     *
     * @param certificate X.509 Certificate
     * @return Formatted Issuer Distinguished Name
     */
    String getIssuer(X509Certificate certificate);
}
