/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.serialization.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.nifi.registry.serialization.SerializationException;
import org.apache.nifi.registry.serialization.VersionedSerializer;

public class JAXBSerializer<T>
implements VersionedSerializer<T> {
    private static final String MAGIC_HEADER = "Flows";
    private static final byte[] MAGIC_HEADER_BYTES = "Flows".getBytes(StandardCharsets.UTF_8);
    private final Class<T> clazz;
    private final JAXBContext jaxbContext;

    public JAXBSerializer(Class<T> clazz) {
        this.clazz = clazz;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXBContext: " + e.getMessage(), e);
        }
    }

    @Override
    public void serialize(int dataModelVersion, T t, OutputStream out) throws SerializationException {
        if (t == null) {
            throw new IllegalArgumentException("The object to serialize cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("OutputStream cannot be null");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(9);
        byteBuffer.put(MAGIC_HEADER_BYTES);
        byteBuffer.putInt(dataModelVersion);
        try {
            out.write(byteBuffer.array());
        }
        catch (IOException e) {
            throw new SerializationException("Unable to write header while serializing process group", e);
        }
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (this.clazz.getAnnotation(XmlRootElement.class) != null) {
                marshaller.marshal(t, out);
            } else {
                String className = this.clazz.getSimpleName();
                String tagName = Character.toLowerCase(className.charAt(0)) + className.substring(1);
                marshaller.marshal((Object)new JAXBElement(new QName(tagName), this.clazz, t), out);
            }
        }
        catch (JAXBException e) {
            throw new SerializationException("Unable to serialize object", e);
        }
    }

    @Override
    public T deserialize(InputStream input) throws SerializationException {
        if (input == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        try {
            this.readDataModelVersion(input);
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            JAXBElement jaxbElement = unmarshaller.unmarshal((Source)new StreamSource(input), this.clazz);
            Object deserializedObject = jaxbElement.getValue();
            return (T)deserializedObject;
        }
        catch (JAXBException e) {
            throw new SerializationException("Unable to deserialize object", e);
        }
    }

    @Override
    public int readDataModelVersion(InputStream input) throws SerializationException {
        int headerLength = 9;
        byte[] buffer = new byte[9];
        int bytesRead = -1;
        try {
            bytesRead = input.read(buffer, 0, 9);
        }
        catch (IOException e) {
            throw new SerializationException("Unable to read header while deserializing process group", e);
        }
        if (bytesRead < 9) {
            throw new SerializationException("Unable to read header while deserializing process group, expected9 bytes, but found " + bytesRead);
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        byte[] magicHeaderBytes = new byte[MAGIC_HEADER_BYTES.length];
        bb.get(magicHeaderBytes);
        for (int i = 0; i < MAGIC_HEADER_BYTES.length; ++i) {
            if (MAGIC_HEADER_BYTES[i] == magicHeaderBytes[i]) continue;
            throw new SerializationException("Unable to read header while deserializing process group. Header byte sequence does not match");
        }
        return bb.getInt(MAGIC_HEADER_BYTES.length);
    }
}

