/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension;

import java.io.Closeable;
import java.io.IOException;
import org.apache.nifi.registry.extension.ExtensionManager;

public class ExtensionCloseable
implements Closeable {
    private final ClassLoader toSet;

    private ExtensionCloseable(ClassLoader toSet) {
        this.toSet = toSet;
    }

    public static ExtensionCloseable withComponentClassLoader(ExtensionManager manager, Class componentClass) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        ExtensionCloseable closeable = new ExtensionCloseable(current);
        ClassLoader componentClassLoader = manager.getExtensionClassLoader(componentClass.getName());
        if (componentClassLoader == null) {
            componentClassLoader = componentClass.getClassLoader();
        }
        Thread.currentThread().setContextClassLoader(componentClassLoader);
        return closeable;
    }

    public static ExtensionCloseable withClassLoader(ClassLoader componentClassLoader) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        ExtensionCloseable closeable = new ExtensionCloseable(current);
        Thread.currentThread().setContextClassLoader(componentClassLoader);
        return closeable;
    }

    @Override
    public void close() throws IOException {
        if (this.toSet != null) {
            Thread.currentThread().setContextClassLoader(this.toSet);
        }
    }
}

