/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Copies the values from the data-login attribute to the username/password fields.
 */
Demo.prepareQuickLinks = function () {
  jQuery("button[data-login]").click(function () {
    var link = jQuery(this);
    var login = link.data("login");
    jQuery(Tobago.Utils.escapeClientId("page:mainForm:username::field")).val(login.username);
    jQuery(Tobago.Utils.escapeClientId("page:mainForm:password::field")).val(login.password);
    return false;
  });
};

Tobago.registerListener(Demo.prepareQuickLinks, Tobago.Phase.DOCUMENT_READY);

/**
 * This code is needed to "repair" the submit parameter names and url to use
 * the names that a required for servlet authentication.
 */
Demo.prepareLoginForm = function() {
  jQuery(Tobago.Utils.escapeClientId("page:mainForm:username::field")).attr("name", "j_username");
  jQuery(Tobago.Utils.escapeClientId("page:mainForm:password::field")).attr("name", "j_password");
  var contextPath = jQuery(Tobago.Utils.escapeClientId("page:mainForm:login")).data("context-path");
  jQuery(Tobago.Utils.escapeClientId("page::form")).attr("action", contextPath + "/j_security_check");
};

// XXX turned off in the moment Tobago.registerListener(Demo.prepareLoginForm, Tobago.Phase.DOCUMENT_READY);
