/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.component.search.MyFacesSearchExpressionHints;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonEventUtils;
import org.apache.myfaces.renderkit.html.util.CommonPropertyUtils;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;

public class HtmlLabelRenderer
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlLabelRenderer.class.getName());

    @Override
    protected boolean isCommonPropertiesOptimizationEnabled(FacesContext facesContext) {
        return true;
    }

    @Override
    protected boolean isCommonEventsOptimizationEnabled(FacesContext facesContext) {
        return true;
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        ClientBehaviorRendererUtils.decodeClientBehaviors(context, component);
    }

    @Override
    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String text;
        super.encodeBegin(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        Map<String, List<ClientBehavior>> behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        this.encodeBefore(facesContext, writer, uiComponent);
        writer.startElement("label", uiComponent);
        if (uiComponent instanceof ClientBehaviorHolder) {
            if (!behaviors.isEmpty()) {
                HtmlRendererUtils.writeIdAndName(writer, uiComponent, facesContext);
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            }
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(uiComponent);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, uiComponent);
                CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, uiComponent);
            } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(uiComponent);
                CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, behaviors);
                CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, behaviors);
            } else {
                HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
                HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, uiComponent, behaviors);
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderLabelPassthroughPropertiesWithoutEvents(writer, commonPropertiesMarked, uiComponent);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.LABEL_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
            }
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderLabelPassthroughProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.LABEL_PASSTHROUGH_ATTRIBUTES);
            }
        }
        String forAttr = this.getFor(uiComponent);
        if (forAttr != null) {
            String forClientId = this.getClientId(facesContext, uiComponent, forAttr);
            writer.writeAttribute("for", forClientId, "for");
        } else if (log.isLoggable(Level.WARNING)) {
            log.warning("Attribute 'for' of label " + ComponentUtils.getPathToComponent(uiComponent) + " is not defined");
        }
        if (uiComponent instanceof ValueHolder && (text = RendererUtils.getStringValue(facesContext, uiComponent)) != null) {
            boolean escape = uiComponent instanceof HtmlOutputLabel ? ((HtmlOutputLabel)uiComponent).isEscape() : RendererUtils.getBooleanAttribute(uiComponent, "escape", true);
            if (escape) {
                writer.writeText(text, "value");
            } else {
                writer.write(text);
            }
        }
        writer.flush();
        this.encodeAfterStart(facesContext, writer, uiComponent);
    }

    protected void encodeAfterStart(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
    }

    protected void encodeBefore(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
    }

    protected String getFor(UIComponent component) {
        if (component instanceof HtmlOutputLabel) {
            return ((HtmlOutputLabel)component).getFor();
        }
        return (String)component.getAttributes().get("for");
    }

    protected String getClientId(FacesContext facesContext, UIComponent uiComponent, String forAttr) {
        SearchExpressionContext searchExpressionContext = SearchExpressionContext.createSearchExpressionContext(facesContext, uiComponent, MyFacesSearchExpressionHints.SET_RESOLVE_SINGLE_COMPONENT_IGNORE_NO_RESULT, null);
        return facesContext.getApplication().getSearchExpressionHandler().resolveClientId(searchExpressionContext, forAttr);
    }

    @Override
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeEnd(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        this.encodeBeforeEnd(facesContext, writer, uiComponent);
        writer.endElement("label");
        this.encodeAfter(facesContext, writer, uiComponent);
    }

    protected void encodeBeforeEnd(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
    }

    protected void encodeAfter(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
    }
}

