/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.faces.application.ResourceVisitOption;
import javax.faces.context.FacesContext;
import org.apache.myfaces.resource.ClassLoaderResourceLoaderIterator;
import org.apache.myfaces.resource.ContractResourceLoader;
import org.apache.myfaces.resource.ResourceMeta;
import org.apache.myfaces.resource.ResourceMetaImpl;
import org.apache.myfaces.util.lang.ClassUtils;

public class ClassLoaderContractResourceLoader
extends ContractResourceLoader {
    public ClassLoaderContractResourceLoader(String prefix) {
        super(prefix);
    }

    @Override
    public String getLibraryVersion(String path, String contractName) {
        return null;
    }

    @Override
    public InputStream getResourceInputStream(ResourceMeta resourceMeta) {
        InputStream is = null;
        String prefix = this.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            String name = prefix + '/' + resourceMeta.getContractName() + '/' + resourceMeta.getResourceIdentifier();
            is = this.getClassLoader().getResourceAsStream(name);
            if (is == null) {
                is = this.getClass().getClassLoader().getResourceAsStream(name);
            }
            return is;
        }
        String name = resourceMeta.getContractName() + '/' + resourceMeta.getResourceIdentifier();
        is = this.getClassLoader().getResourceAsStream(name);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(name);
        }
        return is;
    }

    @Override
    public URL getResourceURL(ResourceMeta resourceMeta) {
        URL url = null;
        String prefix = this.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            String name = prefix + '/' + resourceMeta.getContractName() + '/' + resourceMeta.getResourceIdentifier();
            url = this.getClassLoader().getResource(name);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(name);
            }
            return url;
        }
        String name = resourceMeta.getContractName() + '/' + resourceMeta.getResourceIdentifier();
        url = this.getClassLoader().getResource(name);
        if (url == null) {
            url = this.getClass().getClassLoader().getResource(name);
        }
        return url;
    }

    @Override
    public String getResourceVersion(String path, String contractName) {
        return null;
    }

    @Override
    public ResourceMeta createResourceMeta(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion, String contractName) {
        return new ResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion, contractName);
    }

    protected ClassLoader getClassLoader() {
        return ClassUtils.getContextClassLoader();
    }

    @Override
    public boolean libraryExists(String libraryName, String contractName) {
        String prefix = this.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            String name = prefix + '/' + contractName + '/' + libraryName;
            URL url = this.getClassLoader().getResource(name);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(name);
            }
            if (url != null) {
                return true;
            }
        } else {
            String name = contractName + '/' + libraryName;
            URL url = this.getClassLoader().getResource(name);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(name);
            }
            if (url != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<String> iterator(FacesContext facesContext, String path, int maxDepth, ResourceVisitOption ... options) {
        String basePath = path;
        String prefix = this.getPrefix();
        if (prefix != null) {
            basePath = prefix + '/' + (path.startsWith("/") ? path.substring(1) : path);
        }
        URL url = this.getClassLoader().getResource(basePath);
        return new ClassLoaderResourceLoaderIterator(url, basePath, maxDepth, options);
    }
}

