/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.setup;

import java.sql.SQLException;
import java.util.Optional;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.util.ArgumentChecks;

public final class Configuration {
    private static final Configuration DEFAULT = new Configuration();

    private Configuration() {
    }

    public static Configuration current() {
        return DEFAULT;
    }

    public Optional<DataSource> getDatabase() throws SQLException {
        return Optional.of(MetadataServices.getInstance().getDataSource());
    }

    public void setDatabase(Supplier<DataSource> supplier) {
        ArgumentChecks.ensureNonNull("source", supplier);
        MetadataServices.getInstance().setDataSource(supplier);
    }
}

