/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import thredds.catalog.DataFormatType;
import thredds.catalog2.Access;
import thredds.catalog2.Service;
import thredds.catalog2.builder.AccessBuilder;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssue;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.simpleImpl.DatasetImpl;
import thredds.catalog2.simpleImpl.ServiceImpl;

class AccessImpl
implements Access,
AccessBuilder {
    private final DatasetImpl parentDs;
    private ServiceImpl service;
    private String urlPath;
    private DataFormatType dataFormat;
    private long dataSize;
    private boolean isBuilt = false;

    AccessImpl(DatasetImpl parentDataset) {
        this.parentDs = parentDataset;
    }

    @Override
    public void setServiceBuilder(ServiceBuilder service) {
        if (this.isBuilt) {
            throw new IllegalStateException("This AccessBuilder has been built.");
        }
        if (service == null) {
            throw new IllegalArgumentException("Service must not be null.");
        }
        this.service = (ServiceImpl)service;
    }

    @Override
    public void setUrlPath(String urlPath) {
        if (this.isBuilt) {
            throw new IllegalStateException("This AccessBuilder has been built.");
        }
        if (urlPath == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        this.urlPath = urlPath;
    }

    @Override
    public void setDataFormat(DataFormatType dataFormat) {
        if (this.isBuilt) {
            throw new IllegalStateException("This AccessBuilder has been built.");
        }
        this.dataFormat = dataFormat != null ? dataFormat : DataFormatType.NONE;
    }

    @Override
    public void setDataSize(long dataSize) {
        if (this.isBuilt) {
            throw new IllegalStateException("This AccessBuilder has been built.");
        }
        if (dataSize < -1L) {
            throw new IllegalArgumentException("Value must be zero or greater, or -1 if unknown.");
        }
        this.dataSize = dataSize;
    }

    @Override
    public Service getService() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Access has escaped its AccessBuilder before build() was called.");
        }
        return this.service;
    }

    @Override
    public ServiceBuilder getServiceBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This AccessBuilder has been built.");
        }
        return this.service;
    }

    @Override
    public String getUrlPath() {
        return this.urlPath;
    }

    @Override
    public DataFormatType getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public BuilderIssues getIssues() {
        BuilderIssues issues = new BuilderIssues();
        if (this.service == null) {
            issues.addIssue(BuilderIssue.Severity.ERROR, "Dataset[\"" + this.parentDs.getName() + "\"] not accessible[\"" + this.urlPath + "\"] due to null service.", this, null);
        }
        if (this.urlPath == null) {
            issues.addIssue(BuilderIssue.Severity.ERROR, "Dataset[\"" + this.parentDs.getName() + "\"] not accessible[\"" + this.service != null ? this.service.getName() : "\"] due to null urlPath.", this, null);
        }
        return issues;
    }

    @Override
    public Access build() throws BuilderException {
        this.isBuilt = true;
        return this;
    }
}

