/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.common.DCTM;

import com.documentum.fc.client.DfAuthenticationException;
import com.documentum.fc.client.DfDocbaseUnreachableException;
import com.documentum.fc.client.DfIOException;
import com.documentum.fc.client.DfIdentityException;
import com.documentum.fc.client.IDfFolder;
import com.documentum.fc.client.IDfPersistentObject;
import com.documentum.fc.client.IDfSession;
import com.documentum.fc.client.IDfSysObject;
import com.documentum.fc.client.IDfUser;
import com.documentum.fc.client.IDfVersionPolicy;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.IDfId;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Map;
import org.apache.manifoldcf.crawler.common.DCTM.DocumentumException;
import org.apache.manifoldcf.crawler.common.DCTM.IDocumentumObject;
import org.apache.manifoldcf.crawler.common.DCTM.RMILocalClientSocketFactory;
import org.apache.manifoldcf.crawler.common.DCTM.RMILocalSocketFactory;

public class DocumentumObjectImpl
extends UnicastRemoteObject
implements IDocumentumObject {
    public static final String _rcsid = "@(#)$Id: DocumentumObjectImpl.java 988245 2010-08-23 18:39:35Z kwright $";
    protected IDfPersistentObject object;
    protected IDfSession session;

    public DocumentumObjectImpl(IDfSession session, IDfPersistentObject object) throws RemoteException {
        super(0, (RMIClientSocketFactory)new RMILocalClientSocketFactory(), (RMIServerSocketFactory)new RMILocalSocketFactory());
        this.session = session;
        this.object = object;
    }

    public void release() throws RemoteException {
        this.object = null;
        this.session = null;
    }

    public boolean exists() throws DocumentumException, RemoteException {
        return this.object != null;
    }

    public String getObjectId() throws DocumentumException, RemoteException {
        try {
            return this.object.getObjectId().toString();
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum exception: " + e.getMessage());
        }
    }

    public String getObjectName() throws DocumentumException, RemoteException {
        try {
            return ((IDfSysObject)this.object).getObjectName();
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum exception: " + e.getMessage());
        }
    }

    public String getContentType() throws DocumentumException, RemoteException {
        try {
            return ((IDfSysObject)this.object).getContentType();
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum exception: " + e.getMessage());
        }
    }

    public String getACLDomain() throws DocumentumException, RemoteException {
        try {
            return ((IDfSysObject)this.object).getACLDomain();
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum exception: " + e.getMessage());
        }
    }

    public String getACLName() throws DocumentumException, RemoteException {
        try {
            return ((IDfSysObject)this.object).getACLName();
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum exception: " + e.getMessage());
        }
    }

    public boolean isDeleted() throws DocumentumException, RemoteException {
        try {
            return this.object.isDeleted();
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum exception: " + e.getMessage());
        }
    }

    public boolean isHidden() throws DocumentumException, RemoteException {
        try {
            return ((IDfSysObject)this.object).isHidden();
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum exception: " + e.getMessage());
        }
    }

    public int getPermit() throws DocumentumException, RemoteException {
        try {
            return ((IDfSysObject)this.object).getPermit();
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum exception: " + e.getMessage());
        }
    }

    public long getContentSize() throws DocumentumException, RemoteException {
        try {
            return ((IDfSysObject)this.object).getContentSize();
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum exception: " + e.getMessage());
        }
    }

    public int getPageCount() throws DocumentumException, RemoteException {
        try {
            return ((IDfSysObject)this.object).getPageCount();
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum exception: " + e.getMessage());
        }
    }

    public String getVersionLabel() throws DocumentumException, RemoteException {
        try {
            String versionLabel;
            IDfVersionPolicy policy = ((IDfSysObject)this.object).getVersionPolicy();
            if (policy != null) {
                versionLabel = policy.getSameLabel();
                if (versionLabel == null) {
                    versionLabel = "";
                }
            } else {
                versionLabel = "";
            }
            return versionLabel;
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum exception: " + e.getMessage());
        }
    }

    public String getTypeName() throws DocumentumException, RemoteException {
        try {
            return ((IDfSysObject)this.object).getTypeName();
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum exception: " + e.getMessage());
        }
    }

    public String getVStamp() throws DocumentumException, RemoteException {
        try {
            return this.object.getString("i_vstamp");
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum exception: " + e.getMessage());
        }
    }

    public String[] getFolderPaths(Map pathMapCache) throws DocumentumException, RemoteException {
        try {
            int count = ((IDfSysObject)this.object).getFolderIdCount();
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < count) {
                IDfId folderID;
                String folderIDString;
                String[] folderPath;
                if ((folderPath = (String[])pathMapCache.get(folderIDString = (folderID = ((IDfSysObject)this.object).getFolderId(i++)).getId())) == null) {
                    IDfFolder folder = (IDfFolder)this.session.getObject(folderID);
                    if (folder == null) {
                        folderPath = new String[]{};
                    } else {
                        int folderPathCount = folder.getFolderPathCount();
                        folderPath = new String[folderPathCount];
                        for (int j = 0; j < folderPathCount; ++j) {
                            folderPath[j] = folder.getFolderPath(j);
                        }
                    }
                    pathMapCache.put(folderIDString, folderPath);
                }
                int j = 0;
                while (j < folderPath.length) {
                    list.add(folderPath[j++]);
                }
            }
            String[] rval = new String[list.size()];
            for (i = 0; i < rval.length; ++i) {
                rval[i] = (String)list.get(i);
            }
            return rval;
        }
        catch (DfAuthenticationException ex) {
            throw new DocumentumException("Bad credentials: " + ex.getMessage(), 1);
        }
        catch (DfIdentityException ex) {
            throw new DocumentumException("Bad docbase name: " + ex.getMessage(), 2);
        }
        catch (DfDocbaseUnreachableException e) {
            throw new DocumentumException("Docbase unreachable: " + e.getMessage(), 0);
        }
        catch (DfIOException e) {
            throw new DocumentumException("Docbase io exception: " + e.getMessage(), 0);
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum error: " + e.getMessage());
        }
    }

    public String getFile(String path) throws DocumentumException, RemoteException {
        try {
            return ((IDfSysObject)this.object).getFile(path);
        }
        catch (DfAuthenticationException ex) {
            throw new DocumentumException("Bad credentials: " + ex.getMessage(), 1);
        }
        catch (DfIdentityException ex) {
            throw new DocumentumException("Bad docbase name: " + ex.getMessage(), 2);
        }
        catch (DfDocbaseUnreachableException e) {
            throw new DocumentumException("Docbase unreachable: " + e.getMessage(), 0);
        }
        catch (DfIOException e) {
            throw new DocumentumException("Docbase io exception: " + e.getMessage(), 0);
        }
        catch (DfException dfe) {
            String errorMessage = dfe.getMessage();
            if (errorMessage.indexOf("[DM_CONTENT_E_CANT_START_PULL]") != -1) {
                throw new DocumentumException(dfe.getMessage(), 3);
            }
            if (errorMessage.indexOf("[DM_OBJECT_E_LOAD_INVALID_STRING_LEN]") != -1 || errorMessage.indexOf("[DM_PLATFORM_E_INTEGER_CONVERSION_ERROR]") != -1 || errorMessage.indexOf("[DM_STORAGE_E_BAD_TICKET]") != -1) {
                throw new DocumentumException(dfe.getMessage(), 5);
            }
            throw new DocumentumException(dfe.getMessage(), 0);
        }
    }

    public String[] getAttributeValues(String attribute) throws DocumentumException, RemoteException {
        try {
            int valueCount = this.object.getValueCount(attribute);
            String[] values = new String[valueCount];
            int y = 0;
            while (y < valueCount) {
                String value = this.object.getRepeatingString(attribute, y);
                values[y++] = value;
            }
            return values;
        }
        catch (DfAuthenticationException ex) {
            throw new DocumentumException("Bad credentials: " + ex.getMessage(), 1);
        }
        catch (DfIdentityException ex) {
            throw new DocumentumException("Bad docbase name: " + ex.getMessage(), 2);
        }
        catch (DfDocbaseUnreachableException e) {
            throw new DocumentumException("Docbase unreachable: " + e.getMessage(), 0);
        }
        catch (DfIOException e) {
            throw new DocumentumException("Docbase io exception: " + e.getMessage(), 0);
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum error: " + e.getMessage());
        }
    }

    public int getUserState() throws DocumentumException, RemoteException {
        try {
            return ((IDfUser)this.object).getUserState();
        }
        catch (DfAuthenticationException ex) {
            throw new DocumentumException("Bad credentials: " + ex.getMessage(), 1);
        }
        catch (DfIdentityException ex) {
            throw new DocumentumException("Bad docbase name: " + ex.getMessage(), 2);
        }
        catch (DfDocbaseUnreachableException e) {
            throw new DocumentumException("Docbase unreachable: " + e.getMessage(), 0);
        }
        catch (DfIOException e) {
            throw new DocumentumException("Docbase io exception: " + e.getMessage(), 0);
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum error: " + e.getMessage());
        }
    }

    public String getUserName() throws DocumentumException, RemoteException {
        try {
            return ((IDfUser)this.object).getUserName();
        }
        catch (DfAuthenticationException ex) {
            throw new DocumentumException("Bad credentials: " + ex.getMessage(), 1);
        }
        catch (DfIdentityException ex) {
            throw new DocumentumException("Bad docbase name: " + ex.getMessage(), 2);
        }
        catch (DfDocbaseUnreachableException e) {
            throw new DocumentumException("Docbase unreachable: " + e.getMessage(), 0);
        }
        catch (DfIOException e) {
            throw new DocumentumException("Docbase io exception: " + e.getMessage(), 0);
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum error: " + e.getMessage());
        }
    }
}

