/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.meridio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.meridio.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.connectorcommon.common.CommonsHTTPSender;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.DMDataSet;
import org.apache.manifoldcf.crawler.connectors.meridio.RMDataSet.RMDataSet;
import org.apache.manifoldcf.meridio.MeridioDataSetException;
import org.apache.manifoldcf.meridio.MeridioWrapper;
import org.apache.manifoldcf.ui.util.Encoder;
import org.tempuri.GroupResult;
import org.w3c.dom.Element;

public class MeridioAuthority
extends BaseAuthorityConnector {
    public static final String _rcsid = "@(#)$Id: MeridioAuthority.java 988245 2010-08-23 18:39:35Z kwright $";
    private MeridioWrapper meridio_ = null;
    private URL DmwsURL = null;
    private URL RmwsURL = null;
    private URL MetaCartawsURL = null;
    private SSLSocketFactory mySSLFactory = null;
    private String DMWSProxyHost = null;
    private String DMWSProxyPort = null;
    private String RMWSProxyHost = null;
    private String RMWSProxyPort = null;
    private String MetaCartaWSProxyHost = null;
    private String MetaCartaWSProxyPort = null;
    private String UserName = null;
    private String Password = null;
    private String cacheLifetime = null;
    private String cacheLRUsize = null;
    private long responseLifetime = 60000L;
    private int LRUsize = 1000;
    protected ICacheManager cacheManager = null;
    private static final int MANAGE_DOCUMENT_PRIVILEGE = 17;
    protected static StringSet emptyStringSet = new StringSet();

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void clearThreadContext() {
        super.clearThreadContext();
        this.cacheManager = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.DMWSProxyHost = configParams.getParameter("DMWSProxyHost");
        this.DMWSProxyPort = configParams.getParameter("DMWSProxyPort");
        this.RMWSProxyHost = configParams.getParameter("RMWSProxyHost");
        this.RMWSProxyPort = configParams.getParameter("RMWSProxyPort");
        this.MetaCartaWSProxyHost = configParams.getParameter("MetaCartaWSProxyHost");
        this.MetaCartaWSProxyPort = configParams.getParameter("MetaCartaWSProxyPort");
        this.UserName = configParams.getParameter("UserName");
        this.Password = configParams.getObfuscatedParameter("Password");
        this.cacheLifetime = configParams.getParameter("CacheLifetimeMins");
        if (this.cacheLifetime == null) {
            this.cacheLifetime = "1";
        }
        this.cacheLRUsize = configParams.getParameter("CacheLRUSize");
        if (this.cacheLRUsize == null) {
            this.cacheLRUsize = "1000";
        }
    }

    protected void attemptToConnect() throws ManifoldCFException {
        try {
            this.responseLifetime = Long.parseLong(this.cacheLifetime) * 60L * 1000L;
            this.LRUsize = Integer.parseInt(this.cacheLRUsize);
        }
        catch (NumberFormatException e) {
            throw new ManifoldCFException("Cache lifetime or Cache LRU size must be an integer: " + e.getMessage(), (Throwable)e);
        }
        if (this.meridio_ == null) {
            String DMWSProtocol = this.params.getParameter("DMWSServerProtocol");
            if (DMWSProtocol == null) {
                throw new ManifoldCFException("Missing required configuration parameter: DMWSServerProtocol");
            }
            Object DMWSPort = this.params.getParameter("DMWSServerPort");
            DMWSPort = DMWSPort == null || ((String)DMWSPort).length() == 0 ? "" : ":" + (String)DMWSPort;
            String DMWSUrlString = DMWSProtocol + "://" + this.params.getParameter("DMWSServerName") + (String)DMWSPort + this.params.getParameter("DMWSLocation");
            String RMWSProtocol = this.params.getParameter("RMWSServerProtocol");
            if (RMWSProtocol == null) {
                throw new ManifoldCFException("Missing required configuration parameter: RMWSServerProtocol");
            }
            Object RMWSPort = this.params.getParameter("RMWSServerPort");
            RMWSPort = RMWSPort == null || ((String)RMWSPort).length() == 0 ? "" : ":" + (String)RMWSPort;
            String RMWSUrlString = RMWSProtocol + "://" + this.params.getParameter("RMWSServerName") + (String)RMWSPort + this.params.getParameter("RMWSLocation");
            String MetaCartaWSProtocol = this.params.getParameter("MetaCartaWSServerProtocol");
            if (MetaCartaWSProtocol == null) {
                throw new ManifoldCFException("Missing required configuration parameter: MetaCartaWSServerProtocol");
            }
            Object MetaCartaWSPort = this.params.getParameter("MetaCartaWSServerPort");
            MetaCartaWSPort = MetaCartaWSPort == null || ((String)MetaCartaWSPort).length() == 0 ? "" : ":" + (String)MetaCartaWSPort;
            String ManifoldCFWSUrlString = MetaCartaWSProtocol + "://" + this.params.getParameter("MetaCartaWSServerName") + (String)MetaCartaWSPort + this.params.getParameter("MetaCartaWSLocation");
            String keystoreData = this.params.getParameter("MeridioKeystore");
            this.mySSLFactory = keystoreData != null ? KeystoreManagerFactory.make((String)"", (String)keystoreData).getSecureSocketFactory() : null;
            try {
                this.DmwsURL = new URL(DMWSUrlString);
                this.RmwsURL = new URL(RMWSUrlString);
                this.MetaCartawsURL = new URL(ManifoldCFWSUrlString);
                if (Logging.authorityConnectors.isDebugEnabled()) {
                    Logging.authorityConnectors.debug((Object)("Meridio: Document Management Web Service (DMWS) URL is [" + this.DmwsURL + "]"));
                    Logging.authorityConnectors.debug((Object)("Meridio: Record Management Web Service (RMWS) URL is [" + this.RmwsURL + "]"));
                    Logging.authorityConnectors.debug((Object)("Meridio: MetaCarta Web Service (MCWS) URL is [" + this.MetaCartawsURL + "]"));
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new ManifoldCFException("Meridio: Could not construct the URL for either the Meridio DM, Meridio RM, or MetaCarta Meridio Web Service: " + malformedURLException, (Throwable)malformedURLException);
            }
            try {
                this.meridio_ = new MeridioWrapper(Logging.authorityConnectors, this.DmwsURL, this.RmwsURL, this.MetaCartawsURL, this.DMWSProxyHost, this.DMWSProxyPort, this.RMWSProxyHost, this.RMWSProxyPort, this.MetaCartaWSProxyHost, this.MetaCartaWSProxyPort, this.UserName, this.Password, InetAddress.getLocalHost().getHostName(), this.mySSLFactory, CommonsHTTPSender.class, "client-config.wsdd");
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Meridio: bad number: " + e.getMessage(), (Throwable)e);
            }
            catch (UnknownHostException unknownHostException) {
                throw new ManifoldCFException("Meridio: A Unknown Host Exception occurred while connecting - is a network software and hardware configuration: " + unknownHostException.getMessage(), (Throwable)unknownHostException);
            }
            catch (AxisFault e) {
                String exceptionName;
                long currentTime = System.currentTimeMillis();
                if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                    Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                    if (elem != null) {
                        elem.normalize();
                        String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                        throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing Meridio: " + e.getMessage(), (Throwable)e);
                    }
                    throw new ManifoldCFException("Unknown http error occurred while connecting: " + e.getMessage(), (Throwable)e);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                if (Logging.authorityConnectors.isDebugEnabled()) {
                    Logging.authorityConnectors.debug((Object)("Meridio: Got an unknown remote exception connecting - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
                }
                throw new ManifoldCFException("Remote procedure exception: " + e.getMessage(), (Throwable)e);
            }
            catch (RemoteException remoteException) {
                throw new ManifoldCFException("Meridio: An unknown remote exception occurred while connecting: " + remoteException.getMessage(), (Throwable)remoteException);
            }
        }
    }

    public String check() throws ManifoldCFException {
        Logging.authorityConnectors.debug((Object)"Meridio: Entering 'check' method");
        this.attemptToConnect();
        try {
            RMDataSet rmws;
            DMDataSet ds = this.meridio_.getStaticData();
            if (null == ds) {
                Logging.authorityConnectors.warn((Object)"Meridio: DM DataSet returned was null in 'check' method");
                return "Connection Failed - Internal Error Contact Support";
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Meridio System Name is [" + ds.getSYSTEMINFO().getSystemName() + "] and the comment is [" + ds.getSYSTEMINFO().getComment() + "]"));
            }
            if (null == (rmws = this.meridio_.getConfiguration())) {
                Logging.authorityConnectors.warn((Object)"Meridio: RM DataSet returned was null in 'check' method");
                return "Connection Failed - RM DataSet Error, contact Support";
            }
            this.meridio_.getUsersGroups(2);
            Logging.authorityConnectors.debug((Object)"Meridio: Exiting 'check' method");
            return super.check();
        }
        catch (AxisFault e) {
            String exceptionName;
            long currentTime = System.currentTimeMillis();
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    return "Unexpected http error code " + httpErrorCode + " accessing Meridio: " + e.getMessage();
                }
                return "Unknown http error occurred while connecting: " + e.getMessage();
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Meridio: Got an unknown remote exception checking - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
            }
            return "Axis fault: " + e.getMessage();
        }
        catch (RemoteException remoteException) {
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Meridio: Unknown remote exception occurred during 'check' method: " + remoteException.getMessage()), (Throwable)remoteException);
            }
            return "Meridio: An unknown remote exception occurred while connecting: " + remoteException.getMessage();
        }
        catch (MeridioDataSetException meridioDataSetException) {
            Logging.authorityConnectors.warn((Object)"Meridio: DataSet Exception occurred during 'check' method", (Throwable)meridioDataSetException);
            return "Connection Failed - DataSet error: " + meridioDataSetException.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws ManifoldCFException {
        Logging.authorityConnectors.debug((Object)"Meridio: Entering 'disconnect' method");
        try {
            if (this.meridio_ != null) {
                this.meridio_.logout();
            }
        }
        catch (AxisFault e) {
            String exceptionName;
            long currentTime = System.currentTimeMillis();
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    Logging.authorityConnectors.warn((Object)("Unexpected http error code " + httpErrorCode + " logging out: " + e.getMessage()));
                    return;
                }
                Logging.authorityConnectors.warn((Object)("Unknown http error occurred while logging out: " + e.getMessage()));
                return;
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server")) && e.getFaultString().indexOf(" 23031#") != -1) {
                this.meridio_ = null;
                return;
            }
            Logging.authorityConnectors.warn((Object)("Meridio: Got an unknown remote exception logging out - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString()), (Throwable)e);
            return;
        }
        catch (RemoteException remoteException) {
            Logging.authorityConnectors.warn((Object)("Meridio: A remote exception occurred while logging out: " + remoteException.getMessage()), (Throwable)remoteException);
        }
        finally {
            super.disconnect();
            this.meridio_ = null;
            this.DmwsURL = null;
            this.RmwsURL = null;
            this.MetaCartawsURL = null;
            this.mySSLFactory = null;
            this.DMWSProxyHost = null;
            this.DMWSProxyPort = null;
            this.RMWSProxyHost = null;
            this.RMWSProxyPort = null;
            this.MetaCartaWSProxyHost = null;
            this.MetaCartaWSProxyPort = null;
            this.UserName = null;
            this.Password = null;
            this.cacheLifetime = null;
            this.cacheLRUsize = null;
        }
        Logging.authorityConnectors.debug((Object)"Meridio: Exiting 'disconnect' method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        this.attemptToConnect();
        AuthorizationResponseDescription objectDescription = new AuthorizationResponseDescription(userName, this.DmwsURL.toString(), this.RmwsURL.toString(), this.MetaCartawsURL.toString(), this.DMWSProxyHost, this.DMWSProxyPort, this.RMWSProxyHost, this.RMWSProxyPort, this.MetaCartaWSProxyHost, this.MetaCartaWSProxyPort, this.UserName, this.Password, this.responseLifetime, this.LRUsize);
        ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
        try {
            AuthorizationResponse response;
            ICacheCreateHandle createHandle;
            block8: {
                AuthorizationResponse authorizationResponse;
                createHandle = this.cacheManager.enterCreateSection(ch);
                try {
                    response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                    if (response == null) break block8;
                    authorizationResponse = response;
                }
                catch (Throwable throwable) {
                    this.cacheManager.leaveCreateSection(createHandle);
                    throw throwable;
                }
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            response = this.getAuthorizationResponseUncached(userName);
            this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
            AuthorizationResponse authorizationResponse = response;
            this.cacheManager.leaveCreateSection(createHandle);
            return authorizationResponse;
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected AuthorizationResponse getAuthorizationResponseUncached(String userName) throws ManifoldCFException {
        if (Logging.authorityConnectors.isDebugEnabled()) {
            Logging.authorityConnectors.debug((Object)("Meridio: Authentication user name = '" + userName + "'"));
        }
        while (true) {
            this.attemptToConnect();
            int index = userName.indexOf("@");
            if (index != -1) {
                userName = userName.substring(0, index);
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Meridio: Meridio user name = '" + userName + "'"));
            }
            ArrayList<Object> aclList = new ArrayList<Object>();
            try {
                long userId = this.meridio_.getUserIdFromName(userName);
                if (0L == userId) {
                    if (Logging.authorityConnectors.isDebugEnabled()) {
                        Logging.authorityConnectors.debug((Object)("Meridio: User '" + userName + "' does not exist"));
                    }
                    return RESPONSE_USERNOTFOUND;
                }
                if (Logging.authorityConnectors.isDebugEnabled()) {
                    Logging.authorityConnectors.debug((Object)("Meridio: Found user - the User Id for '" + userName + "' is " + userId));
                }
                aclList.add("U" + userId);
                GroupResult[] userGroups = null;
                userGroups = this.meridio_.getUsersGroups(new Long(userId).intValue());
                if (userGroups != null) {
                    for (int i = 0; i < userGroups.length; ++i) {
                        if (Logging.authorityConnectors.isDebugEnabled()) {
                            Logging.authorityConnectors.debug((Object)("Group ID '" + userGroups[i].getGroupID() + "' Group Name '" + userGroups[i].getGroupName() + ">'"));
                        }
                        aclList.add("G" + userGroups[i].getGroupID());
                    }
                }
                RMDataSet userPrivileges = this.meridio_.getUserPrivilegeList(new Long(userId).intValue());
                for (int i = 0; i < userPrivileges.getRm2Privilege().length; ++i) {
                    if (Logging.authorityConnectors.isDebugEnabled()) {
                        Logging.authorityConnectors.debug((Object)("Meridio: Privilege ID '" + userPrivileges.getRm2Privilege()[i].getId() + "' Name '" + userPrivileges.getRm2Privilege()[i].getName() + "'"));
                    }
                    if (userPrivileges.getRm2Privilege()[i].getId() != 17) continue;
                    Logging.authorityConnectors.debug((Object)"Meridio: User has Manage Document privilege so adding READ_ALL to token list");
                    aclList.add("READ_ALL");
                }
                String[] rval = new String[aclList.size()];
                for (int i = 0; i < rval.length; ++i) {
                    rval[i] = (String)aclList.get(i);
                }
                Logging.authorityConnectors.debug((Object)"Meridio: Exiting method getAccessTokens");
                return new AuthorizationResponse(rval, 0);
            }
            catch (AxisFault e) {
                String exceptionName;
                long currentTime = System.currentTimeMillis();
                if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                    Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                    if (elem != null) {
                        elem.normalize();
                        String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                        throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing Meridio: " + e.getMessage(), (Throwable)e);
                    }
                    throw new ManifoldCFException("Unknown http error occurred while getting doc versions: " + e.getMessage(), (Throwable)e);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server")) && e.getFaultString().indexOf(" 23031#") != -1) {
                    this.meridio_ = null;
                    continue;
                }
                if (Logging.authorityConnectors.isDebugEnabled()) {
                    Logging.authorityConnectors.debug((Object)("Meridio: Got an unknown remote exception getting user tokens - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
                }
                throw new ManifoldCFException("Axis fault: " + e.getMessage(), (Throwable)e);
            }
            catch (RemoteException remoteException) {
                throw new ManifoldCFException("Meridio: A remote exception occurred while getting user tokens: " + remoteException.getMessage(), (Throwable)remoteException);
            }
            catch (MeridioDataSetException meridioDataSetException) {
                Logging.authorityConnectors.error((Object)("Meridio: A provlem occurred manipulating the Web Service XML: " + meridioDataSetException.getMessage()), (Throwable)meridioDataSetException);
                throw new ManifoldCFException("Meridio: A problem occurred manipulating the Web Service XML: " + meridioDataSetException.getMessage(), (Throwable)meridioDataSetException);
            }
            break;
        }
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "MeridioConnector.DocumentServer"));
        tabsArray.add(Messages.getString(locale, "MeridioConnector.RecordsServer"));
        tabsArray.add(Messages.getString(locale, "MeridioConnector.UserServiceServer"));
        tabsArray.add(Messages.getString(locale, "MeridioConnector.Credentials"));
        tabsArray.add(Messages.getString(locale, "MeridioConnector.Cache"));
        out.print("<script type=\"text/javascript\">\n<!--\n\nfunction checkConfig()\n{\n  if (editconnection.dmwsServerPort.value != \"\" && !isInteger(editconnection.dmwsServerPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAValidNumber") + "\");\n    editconnection.dmwsServerPort.focus();\n    return false;\n  }\n  if (editconnection.rmwsServerPort.value != \"\" && !isInteger(editconnection.rmwsServerPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAValidNumber") + "\");\n    editconnection.rmwsServerPort.focus();\n    return false;\n  }\n  if (editconnection.dmwsProxyPort.value != \"\" && !isInteger(editconnection.dmwsProxyPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAValidNumber") + "\");\n    editconnection.dmwsProxyPort.focus();\n    return false;\n  }\n  if (editconnection.rmwsProxyPort.value != \"\" && !isInteger(editconnection.rmwsProxyPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAValidNumber") + "\");\n    editconnection.rmwsProxyPort.focus();\n    return false;\n  }\n  if (editconnection.metacartawsServerPort.value != \"\" && !isInteger(editconnection.metacartawsServerPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAValidNumber") + "\");\n    editconnection.metacartawsServerPort.focus();\n    return false;\n  }\n  if (editconnection.metacartawsProxyPort.value != \"\" && !isInteger(editconnection.metacartawsProxyPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAValidNumber") + "\");\n    editconnection.metacartawsProxyPort.focus();\n    return false;\n  }\n  if (editconnection.userName.value != \"\" && editconnection.userName.value.indexOf(\"\\\") <= 0)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.AValidMeridioUserNameHasTheForm") + "\");\n    editconnection.userName.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction checkConfigForSave()\n{\n  if (editconnection.dmwsServerName.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseFillInAMeridioDocumentManagementServerName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.DocumentServer") + "\");\n    editconnection.dmwsServerName.focus();\n    return false;\n  }\n  if (editconnection.rmwsServerName.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseFillInAMeridioRecordsManagementServerName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.RecordsServer") + "\");\n    editconnection.rmwsServerName.focus();\n    return false;\n  }\n  if (editconnection.metacartawsServerName.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseFillInAUserServiceServerName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.UserServiceServer") + "\");\n    editconnection.metacartawsServerName.focus();\n    return false;\n  }\n\n  if (editconnection.dmwsServerPort.value != \"\" && !isInteger(editconnection.dmwsServerPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAMeridioDocumentManagementPortNumber") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.DocumentServer") + "\");\n    editconnection.dmwsServerPort.focus();\n    return false;\n  }\n  if (editconnection.rmwsServerPort.value != \"\" && !isInteger(editconnection.rmwsServerPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAMeridioDocumentManagementPortNumber") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.RecordsServer") + "\");\n    editconnection.rmwsServerPort.focus();\n    return false;\n  }\n  if (editconnection.metacartawsServerPort.value != \"\" && !isInteger(editconnection.metacartawsServerPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAUserServicePortNumber") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.UserServiceServer") + "\");\n    editconnection.metacartawsServerPort.focus();\n    return false;\n  }\n\n  if (editconnection.userName.value == \"\" || editconnection.userName.value.indexOf(\"\\\") <= 0)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.TheConnectionRequiresAValidMeridioUserNameOfTheForm") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.Credentials") + "\");\n    editconnection.userName.focus();\n    return false;\n  }\n  if (editconnection.cachelifetime.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.CacheLifetimeCannotBeNull") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.Cache") + "\");\n    editconnection.cachelifetime.focus();\n    return false;\n  }\n  if (editconnection.cachelifetime.value != \"\" && !isInteger(editconnection.cachelifetime.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.CacheLifetimeMustBeAnInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.Cache") + "\");\n    editconnection.cachelifetime.focus();\n    return false;\n  }\n  if (editconnection.cachelrusize.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.CacheLRUSizeCannotBeNull") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.Cache") + "\");\n    editconnection.cachelrusize.focus();\n    return false;\n  }\n  if (editconnection.cachelrusize.value != \"\" && !isInteger(editconnection.cachelrusize.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.CacheLRUSizeMustBeAnInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.Cache") + "\");\n    editconnection.cachelrusize.focus();\n    return false;\n  }\n\n  return true;\n}\n\nfunction DeleteCertificate(aliasName)\n{\n  editconnection.keystorealias.value = aliasName;\n  editconnection.configop.value = \"Delete\";\n  postForm();\n}\n\nfunction AddCertificate()\n{\n  if (editconnection.certificate.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.ChooseACertificateFile") + "\");\n    editconnection.certificate.focus();\n  }\n  else\n  {\n    editconnection.configop.value = \"Add\";\n    postForm();\n  }\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String cacheLRUsize;
        String password;
        String userName;
        String metacartawsProxyPort;
        String rmwsProxyPort;
        String dmwsProxyPort;
        String metacartawsProxyHost;
        String rmwsProxyHost;
        String dmwsProxyHost;
        String metacartawsLocation;
        String rmwsLocation;
        String dmwsLocation;
        String metacartawsServerPort;
        String rmwsServerPort;
        String dmwsServerPort;
        String metacartawsServerName;
        String rmwsServerName;
        String dmwsServerName;
        String metacartawsServerProtocol;
        String rmwsServerProtocol;
        String dmwsServerProtocol = parameters.getParameter("DMWSServerProtocol");
        if (dmwsServerProtocol == null) {
            dmwsServerProtocol = "http";
        }
        if ((rmwsServerProtocol = parameters.getParameter("RMWSServerProtocol")) == null) {
            rmwsServerProtocol = "http";
        }
        if ((metacartawsServerProtocol = parameters.getParameter("MetaCartaWSServerProtocol")) == null) {
            metacartawsServerProtocol = "http";
        }
        if ((dmwsServerName = parameters.getParameter("DMWSServerName")) == null) {
            dmwsServerName = "";
        }
        if ((rmwsServerName = parameters.getParameter("RMWSServerName")) == null) {
            rmwsServerName = "";
        }
        if ((metacartawsServerName = parameters.getParameter("MetaCartaWSServerName")) == null) {
            metacartawsServerName = "";
        }
        if ((dmwsServerPort = parameters.getParameter("DMWSServerPort")) == null) {
            dmwsServerPort = "";
        }
        if ((rmwsServerPort = parameters.getParameter("RMWSServerPort")) == null) {
            rmwsServerPort = "";
        }
        if ((metacartawsServerPort = parameters.getParameter("MetaCartaWSServerPort")) == null) {
            metacartawsServerPort = "";
        }
        if ((dmwsLocation = parameters.getParameter("DMWSLocation")) == null) {
            dmwsLocation = "/DMWS/MeridioDMWS.asmx";
        }
        if ((rmwsLocation = parameters.getParameter("RMWSLocation")) == null) {
            rmwsLocation = "/RMWS/MeridioRMWS.asmx";
        }
        if ((metacartawsLocation = parameters.getParameter("MetaCartaWSLocation")) == null) {
            metacartawsLocation = "/MetaCartaWebService/MetaCarta.asmx";
        }
        if ((dmwsProxyHost = parameters.getParameter("DMWSProxyHost")) == null) {
            dmwsProxyHost = "";
        }
        if ((rmwsProxyHost = parameters.getParameter("RMWSProxyHost")) == null) {
            rmwsProxyHost = "";
        }
        if ((metacartawsProxyHost = parameters.getParameter("MetaCartaWSProxyHost")) == null) {
            metacartawsProxyHost = "";
        }
        if ((dmwsProxyPort = parameters.getParameter("DMWSProxyPort")) == null) {
            dmwsProxyPort = "";
        }
        if ((rmwsProxyPort = parameters.getParameter("RMWSProxyPort")) == null) {
            rmwsProxyPort = "";
        }
        if ((metacartawsProxyPort = parameters.getParameter("MetaCartaWSProxyPort")) == null) {
            metacartawsProxyPort = "";
        }
        if ((userName = parameters.getParameter("UserName")) == null) {
            userName = "";
        }
        password = (password = parameters.getObfuscatedParameter("Password")) == null ? "" : out.mapPasswordToKey(password);
        String meridioKeystore = parameters.getParameter("MeridioKeystore");
        IKeystoreManager localKeystore = meridioKeystore == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)meridioKeystore);
        String cacheLifetime = parameters.getParameter("CacheLifetimeMins");
        if (cacheLifetime == null) {
            cacheLifetime = "1";
        }
        if ((cacheLRUsize = parameters.getParameter("CacheLRUSize")) == null) {
            cacheLRUsize = "1000";
        }
        out.print("<input name=\"configop\" type=\"hidden\" value=\"Continue\"/>\n");
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.DocumentServer"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DocumentWebserviceServerProtocol") + "</nobr></td><td class=\"value\"><select name=\"dmwsServerProtocol\"><option value=\"http\" " + (dmwsServerProtocol.equals("http") ? "selected=\"true\"" : "") + ">http</option><option value=\"https\" " + (dmwsServerProtocol.equals("https") ? "selected=\"true\"" : "") + ">https</option></select></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DocumentWebserviceServerName") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"64\" name=\"dmwsServerName\" value=\"" + Encoder.attributeEscape((String)dmwsServerName) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DocumentWebserviceServerPort") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"5\" name=\"dmwsServerPort\" value=\"" + dmwsServerPort + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DocumentWebserviceLocation") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"64\" name=\"dmwsLocation\" value=\"" + Encoder.attributeEscape((String)dmwsLocation) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"separator\" colspan=\"2\"><hr/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DocumentWebserviceServerProxyHost") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"64\" name=\"dmwsProxyHost\" value=\"" + Encoder.attributeEscape((String)dmwsProxyHost) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DocumentWebserviceServerProxyPort") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"5\" name=\"dmwsProxyPort\" value=\"" + dmwsProxyPort + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"dmwsServerProtocol\" value=\"" + dmwsServerProtocol + "\"/>\n<input type=\"hidden\" name=\"dmwsServerName\" value=\"" + Encoder.attributeEscape((String)dmwsServerName) + "\"/>\n<input type=\"hidden\" name=\"dmwsServerPort\" value=\"" + dmwsServerPort + "\"/>\n<input type=\"hidden\" name=\"dmwsLocation\" value=\"" + Encoder.attributeEscape((String)dmwsLocation) + "\"/>\n<input type=\"hidden\" name=\"dmwsProxyHost\" value=\"" + Encoder.attributeEscape((String)dmwsProxyHost) + "\"/>\n<input type=\"hidden\" name=\"dmwsProxyPort\" value=\"" + dmwsProxyPort + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.RecordsServer"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.RecordWebserviceServerProtocol") + "</nobr></td><td class=\"value\"><select name=\"rmwsServerProtocol\"><option value=\"http\" " + (rmwsServerProtocol.equals("http") ? "selected=\"true\"" : "") + ">http</option><option value=\"https\" " + (rmwsServerProtocol.equals("https") ? "selected=\"true\"" : "") + ">https</option></select></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.RecordWebserviceServerName") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"64\" name=\"rmwsServerName\" value=\"" + Encoder.attributeEscape((String)rmwsServerName) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.RecordWebserviceServerPort") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"5\" name=\"rmwsServerPort\" value=\"" + rmwsServerPort + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.RecordWebserviceLocation") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"64\" name=\"rmwsLocation\" value=\"" + Encoder.attributeEscape((String)rmwsLocation) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"separator\" colspan=\"2\"><hr/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.RecordWebserviceServerProxyHost") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"64\" name=\"rmwsProxyHost\" value=\"" + Encoder.attributeEscape((String)rmwsProxyHost) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.RecordWebserviceServerProxyPort") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"5\" name=\"rmwsProxyPort\" value=\"" + rmwsProxyPort + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"rmwsServerProtocol\" value=\"" + rmwsServerProtocol + "\"/>\n<input type=\"hidden\" name=\"rmwsServerName\" value=\"" + Encoder.attributeEscape((String)rmwsServerName) + "\"/>\n<input type=\"hidden\" name=\"rmwsServerPort\" value=\"" + rmwsServerPort + "\"/>\n<input type=\"hidden\" name=\"rmwsLocation\" value=\"" + Encoder.attributeEscape((String)rmwsLocation) + "\"/>\n<input type=\"hidden\" name=\"rmwsProxyHost\" value=\"" + Encoder.attributeEscape((String)rmwsProxyHost) + "\"/>\n<input type=\"hidden\" name=\"rmwsProxyPort\" value=\"" + rmwsProxyPort + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.UserServiceServer"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>User webservice server protocol:</nobr></td><td class=\"value\"><select name=\"metacartawsServerProtocol\"><option value=\"http\" " + (metacartawsServerProtocol.equals("http") ? "selected=\"true\"" : "") + ">http</option><option value=\"https\" " + (metacartawsServerProtocol.equals("https") ? "selected=\"true\"" : "") + ">https</option></select></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.UserWebserviceServerName") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"64\" name=\"metacartawsServerName\" value=\"" + Encoder.attributeEscape((String)metacartawsServerName) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.UserWebserviceServerPort") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"5\" name=\"metacartawsServerPort\" value=\"" + metacartawsServerPort + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.UserWebserviceLocation") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"64\" name=\"metacartawsLocation\" value=\"" + Encoder.attributeEscape((String)metacartawsLocation) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"separator\" colspan=\"2\"><hr/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.UserWebserviceServerProxyHost") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"64\" name=\"metacartawsProxyHost\" value=\"" + Encoder.attributeEscape((String)metacartawsProxyHost) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.UserWebserviceServerProxyPort") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"5\" name=\"metacartawsProxyPort\" value=\"" + metacartawsProxyPort + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"metacartawsServerProtocol\" value=\"" + metacartawsServerProtocol + "\"/>\n<input type=\"hidden\" name=\"metacartawsServerName\" value=\"" + Encoder.attributeEscape((String)metacartawsServerName) + "\"/>\n<input type=\"hidden\" name=\"metacartawsServerPort\" value=\"" + metacartawsServerPort + "\"/>\n<input type=\"hidden\" name=\"metacartawsLocation\" value=\"" + Encoder.attributeEscape((String)metacartawsLocation) + "\"/>\n<input type=\"hidden\" name=\"metacartawsProxyHost\" value=\"" + Encoder.attributeEscape((String)metacartawsProxyHost) + "\"/>\n<input type=\"hidden\" name=\"metacartawsProxyPort\" value=\"" + metacartawsProxyPort + "\"/>\n");
        }
        if (meridioKeystore != null) {
            out.print("<input type=\"hidden\" name=\"keystoredata\" value=\"" + Encoder.attributeEscape((String)meridioKeystore) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.Credentials"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.UserName") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"userName\" value=\"" + Encoder.attributeEscape((String)userName) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.Password") + "</nobr></td><td class=\"value\"><input type=\"password\" size=\"32\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.SSLCertificateList") + "</nobr></td>\n    <td class=\"value\">\n      <input type=\"hidden\" name=\"keystorealias\" value=\"\"/>\n      <table class=\"displaytable\">\n");
            String[] contents = localKeystore.getContents();
            if (contents.length == 0) {
                out.print("        <tr><td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.NoCertificatesPresent") + "</nobr></td></tr>\n");
            } else {
                for (int i = 0; i < contents.length; ++i) {
                    String alias = contents[i];
                    Object description = localKeystore.getDescription(alias);
                    if (((String)description).length() > 128) {
                        description = ((String)description).substring(0, 125) + "...";
                    }
                    out.print("        <tr>\n          <td class=\"value\"><input type=\"button\" onclick='Javascript:DeleteCertificate(\"" + Encoder.attributeJavascriptEscape((String)alias) + "\")' alt=\"" + Messages.getAttributeString(locale, "MeridioConnector.DeleteCert") + Encoder.attributeEscape((String)alias) + "\" value=\"Delete\"/></td>\n          <td>" + Encoder.bodyEscape((String)description) + "</td>\n        </tr>\n");
                }
            }
            out.print("      </table>\n      <input type=\"button\" onclick=\"Javascript:AddCertificate()\" alt=\"" + Messages.getAttributeString(locale, "MeridioConnector.AddCert") + "\" value=\"Add\"/>&nbsp;\n        Certificate:&nbsp;<input name=\"certificate\" size=\"50\" type=\"file\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"userName\" value=\"" + Encoder.attributeEscape((String)userName) + "\"/>\n<input type=\"hidden\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.Cache"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.CacheLifetime") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"cachelifetime\" value=\"" + Encoder.attributeEscape((String)cacheLifetime) + "\"/> " + Messages.getBodyString(locale, "MeridioConnector.minutes") + "</td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.CacheLRUSize") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"cachelrusize\" value=\"" + Encoder.attributeEscape((String)cacheLRUsize) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"cachelifetime\" value=\"" + Encoder.attributeEscape((String)cacheLifetime) + "\"/>\n<input type=\"hidden\" name=\"cachelrusize\" value=\"" + Encoder.attributeEscape((String)cacheLRUsize) + "\"/>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String cacheLRUsize;
        String cacheLifetime;
        String configOp;
        String password;
        String userName;
        String metacartawsProxyPort;
        String rmwsProxyPort;
        String dmwsProxyPort;
        String metacartawsProxyHost;
        String rmwsProxyHost;
        String dmwsProxyHost;
        String metacartawsLocation;
        String rmwsLocation;
        String dmwsLocation;
        String metacartawsServerPort;
        String rmwsServerPort;
        String dmwsServerPort;
        String metacartawsServerName;
        String rmwsServerName;
        String dmwsServerName;
        String metacartawsServerProtocol;
        String rmwsServerProtocol;
        String dmwsServerProtocol = variableContext.getParameter("dmwsServerProtocol");
        if (dmwsServerProtocol != null) {
            parameters.setParameter("DMWSServerProtocol", dmwsServerProtocol);
        }
        if ((rmwsServerProtocol = variableContext.getParameter("rmwsServerProtocol")) != null) {
            parameters.setParameter("RMWSServerProtocol", rmwsServerProtocol);
        }
        if ((metacartawsServerProtocol = variableContext.getParameter("metacartawsServerProtocol")) != null) {
            parameters.setParameter("MetaCartaWSServerProtocol", metacartawsServerProtocol);
        }
        if ((dmwsServerName = variableContext.getParameter("dmwsServerName")) != null) {
            parameters.setParameter("DMWSServerName", dmwsServerName);
        }
        if ((rmwsServerName = variableContext.getParameter("rmwsServerName")) != null) {
            parameters.setParameter("RMWSServerName", rmwsServerName);
        }
        if ((metacartawsServerName = variableContext.getParameter("metacartawsServerName")) != null) {
            parameters.setParameter("MetaCartaWSServerName", metacartawsServerName);
        }
        if ((dmwsServerPort = variableContext.getParameter("dmwsServerPort")) != null) {
            if (dmwsServerPort.length() > 0) {
                parameters.setParameter("DMWSServerPort", dmwsServerPort);
            } else {
                parameters.setParameter("DMWSServerPort", null);
            }
        }
        if ((rmwsServerPort = variableContext.getParameter("rmwsServerPort")) != null) {
            if (rmwsServerPort.length() > 0) {
                parameters.setParameter("RMWSServerPort", rmwsServerPort);
            } else {
                parameters.setParameter("RMWSServerPort", null);
            }
        }
        if ((metacartawsServerPort = variableContext.getParameter("metacartawsServerPort")) != null) {
            if (metacartawsServerPort.length() > 0) {
                parameters.setParameter("MetaCartaWSServerPort", metacartawsServerPort);
            } else {
                parameters.setParameter("MetaCartaWSServerPort", null);
            }
        }
        if ((dmwsLocation = variableContext.getParameter("dmwsLocation")) != null) {
            parameters.setParameter("DMWSLocation", dmwsLocation);
        }
        if ((rmwsLocation = variableContext.getParameter("rmwsLocation")) != null) {
            parameters.setParameter("RMWSLocation", rmwsLocation);
        }
        if ((metacartawsLocation = variableContext.getParameter("metacartawsLocation")) != null) {
            parameters.setParameter("MetaCartaWSLocation", metacartawsLocation);
        }
        if ((dmwsProxyHost = variableContext.getParameter("dmwsProxyHost")) != null) {
            parameters.setParameter("DMWSProxyHost", dmwsProxyHost);
        }
        if ((rmwsProxyHost = variableContext.getParameter("rmwsProxyHost")) != null) {
            parameters.setParameter("RMWSProxyHost", rmwsProxyHost);
        }
        if ((metacartawsProxyHost = variableContext.getParameter("metacartawsProxyHost")) != null) {
            parameters.setParameter("MetaCartaWSProxyHost", metacartawsProxyHost);
        }
        if ((dmwsProxyPort = variableContext.getParameter("dmwsProxyPort")) != null && dmwsProxyPort.length() > 0) {
            parameters.setParameter("DMWSProxyPort", dmwsProxyPort);
        }
        if ((rmwsProxyPort = variableContext.getParameter("rmwsProxyPort")) != null && rmwsProxyPort.length() > 0) {
            parameters.setParameter("RMWSProxyPort", rmwsProxyPort);
        }
        if ((metacartawsProxyPort = variableContext.getParameter("metacartawsProxyPort")) != null && metacartawsProxyPort.length() > 0) {
            parameters.setParameter("MetaCartaWSProxyPort", metacartawsProxyPort);
        }
        if ((userName = variableContext.getParameter("userName")) != null) {
            parameters.setParameter("UserName", userName);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter("Password", variableContext.mapKeyToPassword(password));
        }
        if ((configOp = variableContext.getParameter("configop")) != null) {
            String keystoreValue;
            String alias;
            if (configOp.equals("Delete")) {
                alias = variableContext.getParameter("keystorealias");
                keystoreValue = parameters.getParameter("MeridioKeystore");
                IKeystoreManager mgr = keystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
                mgr.remove(alias);
                parameters.setParameter("MeridioKeystore", mgr.getString());
            } else if (configOp.equals("Add")) {
                alias = IDFactory.make((IThreadContext)threadContext);
                byte[] certificateValue = variableContext.getBinaryBytes("certificate");
                keystoreValue = parameters.getParameter("MeridioKeystore");
                IKeystoreManager mgr = keystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
                ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                String certError = null;
                try {
                    mgr.importCertificate(alias, (InputStream)is);
                }
                catch (Throwable e) {
                    certError = e.getMessage();
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                    }
                }
                if (certError != null) {
                    return "Illegal certificate: " + certError;
                }
                parameters.setParameter("MeridioKeystore", mgr.getString());
            }
        }
        if ((cacheLifetime = variableContext.getParameter("cachelifetime")) != null) {
            parameters.setParameter("CacheLifetimeMins", cacheLifetime);
        }
        if ((cacheLRUsize = variableContext.getParameter("cachelrusize")) != null) {
            parameters.setParameter("CacheLRUSize", cacheLRUsize);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.Parameters") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=&lt;" + Integer.toString(kmanager.getContents().length) + Messages.getBodyString(locale, "MeridioConnector.certificates") + "&gt;</nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    protected static class AuthorizationResponseDescription
    extends BaseDescription {
        protected String userName;
        protected String DmwsURL;
        protected String RmwsURL;
        protected String wsURL;
        protected String DMWSProxyHost;
        protected String DMWSProxyPort;
        protected String RMWSProxyHost;
        protected String RMWSProxyPort;
        protected String wsProxyHost;
        protected String wsProxyPort;
        protected String adminUserName;
        protected String adminPassword;
        protected long responseLifetime;
        protected long expirationTime = -1L;

        public AuthorizationResponseDescription(String userName, String DmwsURL, String RmwsURL, String wsURL, String DMWSProxyHost, String DMWSProxyPort, String RMWSProxyHost, String RMWSProxyPort, String wsProxyHost, String wsProxyPort, String adminUserName, String adminPassword, long responseLifetime, int LRUsize) {
            super("MeridioAuthority", LRUsize);
            this.userName = userName;
            this.DmwsURL = DmwsURL;
            this.RmwsURL = RmwsURL;
            this.wsURL = wsURL;
            this.DMWSProxyHost = DMWSProxyHost;
            this.DMWSProxyPort = DMWSProxyPort;
            this.RMWSProxyHost = RMWSProxyHost;
            this.RMWSProxyPort = RMWSProxyPort;
            this.wsProxyHost = wsProxyHost;
            this.wsProxyPort = wsProxyPort;
            this.adminUserName = adminUserName;
            this.adminPassword = adminPassword;
            this.responseLifetime = responseLifetime;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            return ((Object)((Object)this)).getClass().getName() + "-" + this.userName + "-" + this.DmwsURL + "-" + this.RmwsURL + "-" + this.wsURL + "-" + (this.DMWSProxyHost == null ? "" : this.DMWSProxyHost) + "-" + (this.DMWSProxyPort == null ? "" : this.DMWSProxyPort) + "-" + (this.RMWSProxyHost == null ? "" : this.RMWSProxyHost) + "-" + (this.RMWSProxyPort == null ? "" : this.RMWSProxyPort) + "-" + (this.wsProxyHost == null ? "" : this.wsProxyHost) + "-" + (this.wsProxyPort == null ? "" : this.wsProxyPort) + "-" + this.adminUserName + "-" + this.adminPassword;
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + this.responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            return this.userName.hashCode() + this.DmwsURL.hashCode() + this.RmwsURL.hashCode() + this.wsURL.hashCode() + (this.DMWSProxyHost == null ? 0 : this.DMWSProxyHost.hashCode()) + (this.DMWSProxyPort == null ? 0 : this.DMWSProxyPort.hashCode()) + (this.RMWSProxyHost == null ? 0 : this.RMWSProxyHost.hashCode()) + (this.RMWSProxyPort == null ? 0 : this.RMWSProxyPort.hashCode()) + (this.wsProxyHost == null ? 0 : this.wsProxyHost.hashCode()) + (this.wsProxyPort == null ? 0 : this.wsProxyPort.hashCode()) + this.adminUserName.hashCode() + this.adminPassword.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthorizationResponseDescription)) {
                return false;
            }
            AuthorizationResponseDescription ard = (AuthorizationResponseDescription)((Object)o);
            return ard.userName.equals(this.userName) && ard.DmwsURL.equals(this.DmwsURL) && ard.RmwsURL.equals(this.RmwsURL) && ard.wsURL.equals(this.wsURL) && (ard.DMWSProxyHost == null || this.DMWSProxyHost == null ? ard.DMWSProxyHost == this.DMWSProxyHost : ard.DMWSProxyHost.equals(this.DMWSProxyHost)) && (ard.DMWSProxyPort == null || this.DMWSProxyPort == null ? ard.DMWSProxyPort == this.DMWSProxyPort : ard.DMWSProxyPort.equals(this.DMWSProxyPort)) && (ard.RMWSProxyHost == null || this.RMWSProxyHost == null ? ard.RMWSProxyHost == this.RMWSProxyHost : ard.RMWSProxyHost.equals(this.RMWSProxyHost)) && (ard.RMWSProxyPort == null || this.RMWSProxyPort == null ? ard.RMWSProxyPort == this.RMWSProxyPort : ard.RMWSProxyPort.equals(this.RMWSProxyPort)) && (ard.wsProxyHost == null || this.wsProxyHost == null ? ard.wsProxyHost == this.wsProxyHost : ard.wsProxyHost.equals(this.wsProxyHost)) && (ard.wsProxyPort == null || this.wsProxyPort == null ? ard.wsProxyPort == this.wsProxyPort : ard.wsProxyPort.equals(this.wsProxyPort)) && ard.adminUserName.equals(this.adminUserName) && ard.adminPassword.equals(this.adminPassword);
        }
    }
}

