/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$TrustedFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.InterruptibleTask;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.TrustedListenableFutureTask$TrustedFutureInterruptibleTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;

class TrustedListenableFutureTask
extends AbstractFuture$TrustedFuture
implements RunnableFuture {
    private volatile InterruptibleTask task;

    static TrustedListenableFutureTask create(Callable callable) {
        return new TrustedListenableFutureTask(callable);
    }

    static TrustedListenableFutureTask create(Runnable runnable, @Nullable Object object) {
        return new TrustedListenableFutureTask(Executors.callable(runnable, object));
    }

    TrustedListenableFutureTask(Callable callable) {
        this.task = new TrustedListenableFutureTask$TrustedFutureInterruptibleTask(this, callable);
    }

    @Override
    public void run() {
        InterruptibleTask interruptibleTask = this.task;
        if (interruptibleTask != null) {
            interruptibleTask.run();
        }
        this.task = null;
    }

    @Override
    protected void afterDone() {
        InterruptibleTask interruptibleTask;
        super.afterDone();
        if (this.wasInterrupted() && (interruptibleTask = this.task) != null) {
            interruptibleTask.interruptTask();
        }
        this.task = null;
    }

    @Override
    protected String pendingToString() {
        InterruptibleTask interruptibleTask = this.task;
        if (interruptibleTask != null) {
            return "task=[" + interruptibleTask + "]";
        }
        return super.pendingToString();
    }
}

