/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.lucene.monitor.CandidateMatcher;
import org.apache.lucene.monitor.MatcherFactory;
import org.apache.lucene.monitor.MultiMatchingQueries;
import org.apache.lucene.monitor.QueryMatch;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class ParallelMatcher<T extends QueryMatch>
extends CandidateMatcher<T> {
    private final BlockingQueue<MatcherTask> queue = new LinkedBlockingQueue<MatcherTask>(1024);
    private final List<Future<CandidateMatcher<T>>> futures = new ArrayList<Future<CandidateMatcher<T>>>();
    private final CandidateMatcher<T> collectorMatcher;
    private static final MatcherTask END = new MatcherTask("", null, Collections.emptyMap());

    private ParallelMatcher(IndexSearcher searcher, ExecutorService executor, MatcherFactory<T> matcherFactory, int threads) {
        super(searcher);
        for (int i = 0; i < threads; ++i) {
            MatcherWorker mw = new MatcherWorker(matcherFactory);
            this.futures.add(executor.submit(mw));
        }
        this.collectorMatcher = matcherFactory.createMatcher(searcher);
    }

    @Override
    public void matchQuery(String queryId, Query matchQuery, Map<String, String> metadata) throws IOException {
        try {
            this.queue.put(new MatcherTask(queryId, matchQuery, metadata));
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted during match", e);
        }
    }

    @Override
    public T resolve(T match1, T match2) {
        return this.collectorMatcher.resolve(match1, match2);
    }

    @Override
    protected void doFinish() {
        try {
            for (int i = 0; i < this.futures.size(); ++i) {
                this.queue.put(END);
            }
            for (Future<CandidateMatcher<T>> future : this.futures) {
                MultiMatchingQueries<T> matches = future.get().finish(0L, 0);
                for (int doc = 0; doc < matches.getBatchSize(); ++doc) {
                    for (QueryMatch match : matches.getMatches(doc)) {
                        this.addMatch(match, doc);
                    }
                }
                for (Map.Entry<String, Exception> error : matches.getErrors().entrySet()) {
                    this.reportError(error.getKey(), error.getValue());
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Interrupted during match", e);
        }
    }

    public static <T extends QueryMatch> MatcherFactory<T> factory(ExecutorService executor, MatcherFactory<T> matcherFactory, int threads) {
        return new ParallelMatcherFactory<T>(executor, matcherFactory, threads);
    }

    public static <T extends QueryMatch> MatcherFactory<T> factory(ExecutorService executor, MatcherFactory<T> matcherFactory) {
        int threads = Runtime.getRuntime().availableProcessors();
        return new ParallelMatcherFactory<T>(executor, matcherFactory, threads);
    }

    private class MatcherWorker
    implements Callable<CandidateMatcher<T>> {
        final CandidateMatcher<T> matcher;

        private MatcherWorker(MatcherFactory<T> matcherFactory) {
            this.matcher = matcherFactory.createMatcher(ParallelMatcher.this.searcher);
        }

        @Override
        public CandidateMatcher<T> call() {
            try {
                MatcherTask task;
                while ((task = ParallelMatcher.this.queue.take()) != END) {
                    try {
                        this.matcher.matchQuery(task.id, task.matchQuery, task.metadata);
                    }
                    catch (IOException e) {
                        this.matcher.reportError(task.id, e);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted during match", e);
            }
            return this.matcher;
        }
    }

    private record MatcherTask(String id, Query matchQuery, Map<String, String> metadata) {
    }

    private record ParallelMatcherFactory<T extends QueryMatch>(ExecutorService executor, MatcherFactory<T> matcherFactory, int threads) implements MatcherFactory<T>
    {
        @Override
        public ParallelMatcher<T> createMatcher(IndexSearcher searcher) {
            return new ParallelMatcher<T>(searcher, this.executor, this.matcherFactory, this.threads);
        }
    }
}

