/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.server.restful;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.apache.linkis.metadata.query.common.domain.GenerateSqlInfo;
import org.apache.linkis.metadata.query.common.domain.MetaColumnInfo;
import org.apache.linkis.metadata.query.common.domain.MetaPartitionInfo;
import org.apache.linkis.metadata.query.common.exception.MetaMethodInvokeException;
import org.apache.linkis.metadata.query.server.service.MetadataQueryService;
import org.apache.linkis.metadata.query.server.utils.MetadataUtils;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"metadata query"})
@RestController
@RequestMapping(value={"/metadataQuery"})
public class MetadataQueryRestful {
    private static final Logger logger = LoggerFactory.getLogger(MetadataQueryRestful.class);
    @Autowired
    private MetadataQueryService metadataQueryService;

    @RequestMapping(value={"/getConnectionInfo"}, method={RequestMethod.GET})
    public Message getConnectionInfo(@RequestParam(value="dataSourceName") String dataSourceName, @RequestParam(value="system") String system, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceName).matches()) {
                return Message.error((String)"'dataSourceName' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getConnectionInfo, dataSourceName:" + dataSourceName));
            Map<String, String> queryParams = request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> StringUtils.join((Object[])((Object[])entry.getValue()), (String)",")));
            Map<String, String> info = this.metadataQueryService.getConnectionInfoByDsName(dataSourceName, queryParams, system, userName);
            return Message.ok().data("info", info);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to get connection info [\u83b7\u5f97\u8fde\u63a5\u4fe1\u606f\u5931\u8d25], name: [" + dataSourceName + "], system:[" + system + "]", e);
        }
    }

    @ApiOperation(value="getDatabases", notes="get databases", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceName", required=true, dataType="String"), @ApiImplicitParam(name="envId", required=false, dataType="String"), @ApiImplicitParam(name="system", required=true, dataType="String")})
    @RequestMapping(value={"/getDatabases"}, method={RequestMethod.GET})
    public Message getDatabases(@RequestParam(value="dataSourceName") String dataSourceName, @RequestParam(value="envId", required=false) String envId, @RequestParam(value="system") String system, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceName).matches()) {
                return Message.error((String)"'dataSourceName' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getDatabases, dataSourceName:" + dataSourceName));
            List<String> databases = this.metadataQueryService.getDatabasesByDsNameAndEnvId(dataSourceName, system, userName, envId);
            return Message.ok().data("dbs", databases);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to get database list[\u83b7\u53d6\u5e93\u4fe1\u606f\u5931\u8d25], name:[" + dataSourceName + "], system:[" + system + "]", e);
        }
    }

    @ApiOperation(value="getTables", notes="get tables", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceName", required=true, dataType="String"), @ApiImplicitParam(name="envId", required=false, dataType="String"), @ApiImplicitParam(name="system", required=true, dataType="String"), @ApiImplicitParam(name="database", required=true, dataType="String")})
    @RequestMapping(value={"/getTables"}, method={RequestMethod.GET})
    public Message getTables(@RequestParam(value="dataSourceName") String dataSourceName, @RequestParam(value="envId", required=false) String envId, @RequestParam(value="database") String database, @RequestParam(value="system") String system, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceName).matches()) {
                return Message.error((String)"'dataSourceName' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(database).matches()) {
                return Message.error((String)"'database' is invalid[\u6570\u636e\u5e93\u540d\u79f0\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getTables, dataSourceName:" + dataSourceName));
            List<String> tables = this.metadataQueryService.getTablesByDsNameAndEnvId(dataSourceName, database, system, userName, envId);
            return Message.ok().data("tables", tables);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to get table list[\u83b7\u53d6\u8868\u4fe1\u606f\u5931\u8d25], name:[" + dataSourceName + "], system:[" + system + "], database:[" + database + "]", e);
        }
    }

    @ApiOperation(value="getTableProps", notes="get table props", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceName", required=true, dataType="String"), @ApiImplicitParam(name="system", required=true, dataType="String"), @ApiImplicitParam(name="database", required=true, dataType="String"), @ApiImplicitParam(name="table", required=true, dataType="String")})
    @RequestMapping(value={"/getTableProps"}, method={RequestMethod.GET})
    public Message getTableProps(@RequestParam(value="dataSourceName") String dataSourceName, @RequestParam(value="database") String database, @RequestParam(value="table") String table, @RequestParam(value="system") String system, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(database).matches()) {
                return Message.error((String)"'database' is invalid[\u6570\u636e\u5e93\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(table).matches()) {
                return Message.error((String)"'table' is invalid[\u8868\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceName).matches()) {
                return Message.error((String)"'dataSourceName' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getTableProps, dataSourceName:" + dataSourceName));
            Map<String, String> tableProps = this.metadataQueryService.getTablePropsByDsName(dataSourceName, database, table, system, userName);
            return Message.ok().data("props", tableProps);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to get table properties[\u83b7\u53d6\u8868\u53c2\u6570\u4fe1\u606f\u5931\u8d25], name:[" + dataSourceName + "], system:[" + system + "], database:[" + database + "], table:[" + table + "]", e);
        }
    }

    @ApiOperation(value="getPartitions", notes="get partitions", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceName", required=true, dataType="String"), @ApiImplicitParam(name="system", required=true, dataType="String"), @ApiImplicitParam(name="database", required=true, dataType="String"), @ApiImplicitParam(name="table", required=true, dataType="String")})
    @RequestMapping(value={"/getPartitions"}, method={RequestMethod.GET})
    public Message getPartitions(@RequestParam(value="dataSourceName") String dataSourceName, @RequestParam(value="database") String database, @RequestParam(value="table") String table, @RequestParam(value="system") String system, @RequestParam(name="traverse", required=false, defaultValue="false") Boolean traverse, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(database).matches()) {
                return Message.error((String)"'database' is invalid[\u6570\u636e\u5e93\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(table).matches()) {
                return Message.error((String)"'table' is invalid[\u8868\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceName).matches()) {
                return Message.error((String)"'dataSourceName' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getPartitions, dataSourceName:" + dataSourceName));
            MetaPartitionInfo partitionInfo = this.metadataQueryService.getPartitionsByDsName(dataSourceName, database, table, system, traverse, userName);
            return Message.ok().data("partitions", (Object)partitionInfo);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to get partitions[\u83b7\u53d6\u8868\u5206\u533a\u4fe1\u606f\u5931\u8d25], name:[" + dataSourceName + "], system:[" + system + "], database:[" + database + "], table:[" + table + "]", e);
        }
    }

    @ApiOperation(value="getPartitionProps", notes="get partition props", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceName", required=true, dataType="String"), @ApiImplicitParam(name="system", required=true, dataType="String"), @ApiImplicitParam(name="database", required=true, dataType="String"), @ApiImplicitParam(name="table", required=true, dataType="String"), @ApiImplicitParam(name="partition", required=true, dataType="String")})
    @RequestMapping(value={"getPartitionProps"}, method={RequestMethod.GET})
    public Message getPartitionProps(@RequestParam(value="dataSourceName") String dataSourceName, @RequestParam(value="database") String database, @RequestParam(value="table") String table, @RequestParam(value="partition") String partition, @RequestParam(value="system") String system, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(database).matches()) {
                return Message.error((String)"'database' is invalid[\u6570\u636e\u5e93\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(table).matches()) {
                return Message.error((String)"'table' is invalid[\u8868\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceName).matches()) {
                return Message.error((String)"'dataSourceName' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(partition).matches()) {
                return Message.error((String)"'partition' is invalid[partition\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getPartitionProps, dataSourceName:" + dataSourceName));
            Map<String, String> partitionProps = this.metadataQueryService.getPartitionPropsByDsName(dataSourceName, database, table, partition, system, userName);
            return Message.ok().data("props", partitionProps);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to get partition properties[\u83b7\u53d6\u5206\u533a\u53c2\u6570\u4fe1\u606f\u5931\u8d25], name:[" + dataSourceName + "], system:[" + system + "], database:[" + database + "], table:[" + table + "], partition:[" + partition + "]", e);
        }
    }

    @ApiOperation(value="getColumns", notes="get columns", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceName", required=true, dataType="String"), @ApiImplicitParam(name="envId", required=false, dataType="String"), @ApiImplicitParam(name="system", required=true, dataType="String"), @ApiImplicitParam(name="database", required=true, dataType="String"), @ApiImplicitParam(name="table", required=true, dataType="String")})
    @RequestMapping(value={"/getColumns"}, method={RequestMethod.GET})
    public Message getColumns(@RequestParam(value="dataSourceName") String dataSourceName, @RequestParam(value="envId", required=false) String envId, @RequestParam(value="database") String database, @RequestParam(value="table") String table, @RequestParam(value="system") String system, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(database).matches()) {
                return Message.error((String)"'database' is invalid[\u6570\u636e\u5e93\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(table).matches()) {
                return Message.error((String)"'table' is invalid[\u8868\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceName).matches()) {
                return Message.error((String)"'dataSourceName' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getColumns, dataSourceName:" + dataSourceName));
            List<MetaColumnInfo> columns = this.metadataQueryService.getColumnsByDsNameAndEnvId(dataSourceName, database, table, system, userName, envId);
            return Message.ok().data("columns", columns);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to get column list[\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25], name:[" + dataSourceName + "], system:[" + system + "], database:[" + database + "], table:[" + table + "]", e);
        }
    }

    @ApiOperation(value="getSparkDdlSql", notes="get spark ddl sql", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceName", required=true, dataType="String"), @ApiImplicitParam(name="envId", required=false, dataType="String"), @ApiImplicitParam(name="system", required=true, dataType="String"), @ApiImplicitParam(name="database", required=true, dataType="String"), @ApiImplicitParam(name="table", required=true, dataType="String")})
    @RequestMapping(value={"/getSparkSql"}, method={RequestMethod.GET})
    public Message getSparkSql(@RequestParam(value="dataSourceName") String dataSourceName, @RequestParam(value="envId", required=false) String envId, @RequestParam(value="database") String database, @RequestParam(value="table") String table, @RequestParam(value="system") String system, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(database).matches()) {
                return Message.error((String)"'database' is invalid[\u6570\u636e\u5e93\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(table).matches()) {
                return Message.error((String)"'table' is invalid[\u8868\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceName).matches()) {
                return Message.error((String)"'dataSourceName' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getSparkDdlSql, dataSourceName:" + dataSourceName));
            GenerateSqlInfo sparkSql = this.metadataQueryService.getSparkSqlByDsNameAndEnvId(dataSourceName, database, table, system, userName, envId);
            return Message.ok().data("sparkSql", (Object)sparkSql);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to spark sql[\u83b7\u53d6getSparkSql\u4fe1\u606f\u5931\u8d25], name:[" + dataSourceName + "], system:[" + system + "], database:[" + database + "], table:[" + table + "]", e);
        }
    }

    @ApiOperation(value="getJdbcSql", notes="get jdbc sql", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataSourceName", required=true, dataType="String"), @ApiImplicitParam(name="envId", required=false, dataType="String"), @ApiImplicitParam(name="system", required=true, dataType="String"), @ApiImplicitParam(name="database", required=true, dataType="String"), @ApiImplicitParam(name="table", required=true, dataType="String")})
    @RequestMapping(value={"/getJdbcSql"}, method={RequestMethod.GET})
    public Message getJdbcSql(@RequestParam(value="dataSourceName") String dataSourceName, @RequestParam(value="envId", required=false) String envId, @RequestParam(value="database") String database, @RequestParam(value="table") String table, @RequestParam(value="system") String system, HttpServletRequest request) {
        try {
            if (StringUtils.isBlank((CharSequence)system)) {
                return Message.error((String)"'system' is missing[\u7f3a\u5c11\u7cfb\u7edf\u540d]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(system).matches()) {
                return Message.error((String)"'system' is invalid[\u7cfb\u7edf\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(database).matches()) {
                return Message.error((String)"'database' is invalid[\u6570\u636e\u5e93\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(table).matches()) {
                return Message.error((String)"'table' is invalid[\u8868\u540d\u9519\u8bef]");
            }
            if (!MetadataUtils.nameRegexPattern.matcher(dataSourceName).matches()) {
                return Message.error((String)"'dataSourceName' is invalid[\u6570\u636e\u6e90\u9519\u8bef]");
            }
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("getJdbcSql, dataSourceName:" + dataSourceName));
            GenerateSqlInfo sparkSql = this.metadataQueryService.getJdbcSqlByDsNameAndEnvId(dataSourceName, database, table, system, userName, envId);
            return Message.ok().data("jdbcSql", (Object)sparkSql);
        }
        catch (Exception e) {
            return this.errorToResponseMessage("Fail to jdbc sql[\u83b7\u53d6getJdbcSql\u4fe1\u606f\u5931\u8d25], name:[" + dataSourceName + "], system:[" + system + "], database:[" + database + "], table:[" + table + "]", e);
        }
    }

    private Message errorToResponseMessage(String uiMessage, Exception e) {
        if (e instanceof MetaMethodInvokeException) {
            MetaMethodInvokeException invokeException = (MetaMethodInvokeException)e;
            if (logger.isDebugEnabled()) {
                String argumentJson = null;
                try {
                    argumentJson = Json.toJson((Object)invokeException.getArgs(), null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                logger.trace(uiMessage + " => Method: " + invokeException.getMethod() + ", Arguments:" + argumentJson, (Throwable)e);
            }
            uiMessage = uiMessage + " possible reason[\u53ef\u80fd\u539f\u56e0]: (" + invokeException.getCause().getMessage() + ")";
        } else if (e instanceof ErrorException) {
            uiMessage = uiMessage + " possible reason[\u53ef\u80fd\u539f\u56e0]: (" + e.getMessage() + ")";
        }
        logger.error(uiMessage, (Throwable)e);
        return Message.error((String)uiMessage);
    }
}

