/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.security;

import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.RSAUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.gateway.config.GatewayConfiguration$;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.security.GatewaySSOUtils$;
import org.apache.linkis.gateway.security.ProxyUserUtils$;
import org.apache.linkis.gateway.security.SecurityHook;
import org.apache.linkis.gateway.security.UserRestful;
import org.apache.linkis.gateway.security.sso.SSOInterceptor$;
import org.apache.linkis.gateway.security.token.TokenAuthentication$;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.apache.linkis.server.package$;
import org.apache.linkis.server.security.SSOUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb!\u0002\f\u0018\u0003\u0003\u0011\u0003\"B\u001b\u0001\t\u00031\u0004b\u0002\u001d\u0001\u0001\u0004%I!\u000f\u0005\b\u0001\u0002\u0001\r\u0011\"\u0003B\u0011\u00199\u0005\u0001)Q\u0005u!9\u0001\n\u0001b\u0001\n\u0003I\u0005B\u0002)\u0001A\u0003%!\nC\u0003R\u0001\u0011\u0005!\u000bC\u0004U\u0001\t\u0007I\u0011B+\t\ry\u0003\u0001\u0015!\u0003W\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u0015)\b\u0001\"\u0001w\u0011\u0015A\b\u0001\"\u0001z\u0011\u0015Y\bA\"\u0005}\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\t9\u0002\u0001C\u0001\u00033Aq!!\b\u0001\r#\tyBA\nBEN$(/Y2u+N,'OU3ti\u001a,HN\u0003\u0002\u00193\u0005A1/Z2ve&$\u0018P\u0003\u0002\u001b7\u00059q-\u0019;fo\u0006L(B\u0001\u000f\u001e\u0003\u0019a\u0017N\\6jg*\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0012*[A\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0016\u000e\u0003]I!\u0001L\f\u0003\u0017U\u001bXM\u001d*fgR4W\u000f\u001c\t\u0003]Mj\u0011a\f\u0006\u0003aE\nQ!\u001e;jYNT!AM\u000e\u0002\r\r|W.\\8o\u0013\t!tFA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u00059\u0004C\u0001\u0016\u0001\u00035\u0019XmY;sSRL\bj\\8lgV\t!\bE\u0002%wuJ!\u0001P\u0013\u0003\u000b\u0005\u0013(/Y=\u0011\u0005)r\u0014BA \u0018\u00051\u0019VmY;sSRL\bj\\8l\u0003E\u0019XmY;sSRL\bj\\8lg~#S-\u001d\u000b\u0003\u0005\u0016\u0003\"\u0001J\"\n\u0005\u0011+#\u0001B+oSRDqAR\u0002\u0002\u0002\u0003\u0007!(A\u0002yIE\nab]3dkJLG/\u001f%p_.\u001c\b%\u0001\tegN\u0004&o\u001c6fGR\u001cVM\u001c3feV\t!\n\u0005\u0002L\u001d6\tAJ\u0003\u0002N7\u0005\u0019!\u000f]2\n\u0005=c%AB*f]\u0012,'/A\tegN\u0004&o\u001c6fGR\u001cVM\u001c3fe\u0002\n\u0001c]3u'\u0016\u001cWO]5us\"{wn[:\u0015\u0005\t\u001b\u0006\"\u0002\u001d\b\u0001\u0004Q\u0014!C;tKJ\u0014VmZ3y+\u00051\u0006CA,]\u001b\u0005A&BA-[\u0003\u0011a\u0017M\\4\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0017\u0002\u0007'R\u0014\u0018N\\4\u0002\u0015U\u001cXM\u001d*fO\u0016D\b%A\u0007e_V\u001bXM\u001d*fcV,7\u000f\u001e\u000b\u0003\u0005\u0006DQA\u0019\u0006A\u0002\r\fabZ1uK^\f\u0017pQ8oi\u0016DH\u000f\u0005\u0002eO6\tQM\u0003\u0002g3\u0005!\u0001\u000e\u001e;q\u0013\tAWM\u0001\bHCR,w/Y=D_:$X\r\u001f;\u0002\u000bA\u0014x\u000e_=\u0015\u0005-\f\bC\u00017p\u001b\u0005i'B\u00018\u001c\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001/\u001c\u0002\b\u001b\u0016\u001c8/Y4f\u0011\u0015\u00117\u00021\u0001d\u0003!\u00198o\u001c'pO&tGC\u0001\"u\u0011\u0015\u0011G\u00021\u0001d\u0003\u0015awnZ5o)\tYw\u000fC\u0003c\u001b\u0001\u00071-\u0001\u0005sK\u001eL7\u000f^3s)\tY'\u0010C\u0003c\u001d\u0001\u00071-\u0001\u0005uefdunZ5o)\tYW\u0010C\u0003\u007f\u001f\u0001\u00071-A\u0004d_:$X\r\u001f;\u0002\r1|wm\\;u)\rY\u00171\u0001\u0005\u0006EB\u0001\raY\u0001\tkN,'/\u00138g_R\u00191.!\u0003\t\u000b\t\f\u0002\u0019A2\u0002\u0011\t\f7/Z5oM>$2a[A\b\u0011\u0015\u0011'\u00031\u0001d\u0003%\u0001XO\u00197jG.+\u0017\u0010F\u0002l\u0003+AQAY\nA\u0002\r\f\u0011\u0002[3beR\u0014W-\u0019;\u0015\u0007-\fY\u0002C\u0003c)\u0001\u00071-A\u0006uef\u0014VmZ5ti\u0016\u0014HcA6\u0002\"!)a0\u0006a\u0001G\u0002")
public abstract class AbstractUserRestful
implements UserRestful,
Logging {
    private SecurityHook[] securityHooks;
    private final Sender dssProjectSender;
    private final String userRegex;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        AbstractUserRestful abstractUserRestful = this;
        synchronized (abstractUserRestful) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private SecurityHook[] securityHooks() {
        return this.securityHooks;
    }

    private void securityHooks_$eq(SecurityHook[] x$1) {
        this.securityHooks = x$1;
    }

    public Sender dssProjectSender() {
        return this.dssProjectSender;
    }

    public void setSecurityHooks(SecurityHook[] securityHooks) {
        this.securityHooks_$eq(securityHooks);
    }

    private String userRegex() {
        return this.userRegex;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doUserRequest(GatewayContext gatewayContext) {
        Message message;
        String path = gatewayContext.getRequest().getRequestURI().replace(this.userRegex(), "");
        if (StringUtils.isNotBlank((CharSequence)path) && path.startsWith("sso-login")) {
            this.ssoLogin(gatewayContext);
            return;
        }
        String string = path;
        if ("register".equals(string)) {
            message = this.register(gatewayContext);
        } else if ("login".equals(string)) {
            message = (Message)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
                String loginUser = GatewaySSOUtils$.MODULE$.getLoginUsername(gatewayContext);
                return Message$.MODULE$.ok(new StringBuilder(69).append(loginUser).append(" already logged in, please log out before signing in(\u5df2\u7ecf\u767b\u5f55\uff0c\u8bf7\u5148\u9000\u51fa\u518d\u8fdb\u884c\u767b\u5f55)\uff01").toString()).data("userName", (Object)loginUser);
            }, (Function1 & Serializable & scala.Serializable)x$1 -> this.login(gatewayContext));
        } else if ("token-login".equals(string)) {
            if ("POST".equalsIgnoreCase(gatewayContext.getRequest().getMethod())) {
                TokenAuthentication$.MODULE$.tokenAuth(gatewayContext, true);
                return;
            }
            message = Message$.MODULE$.error("Only support method POST");
        } else {
            message = "logout".equals(string) ? this.logout(gatewayContext) : ("userInfo".equals(string) ? this.userInfo(gatewayContext) : ("publicKey".equals(string) ? this.publicKey(gatewayContext) : ("heartbeat".equals(string) ? this.heartbeat(gatewayContext) : ("proxy".equals(string) ? this.proxy(gatewayContext) : ("baseinfo".equals(string) ? this.baseinfo(gatewayContext) : Message$.MODULE$.error(new StringBuilder(20).append("unknown request URI ").append(path).toString()))))));
        }
        Message message2 = message;
        gatewayContext.getResponse().write(Message$.MODULE$.response(message2));
        gatewayContext.getResponse().setStatus(Message$.MODULE$.messageToHttpStatus(message2));
        gatewayContext.getResponse().sendResponse();
    }

    public Message proxy(GatewayContext gatewayContext) {
        String validationCode;
        String proxyUser = gatewayContext.getRequest().getQueryParams().get("proxyUser")[0];
        if (ProxyUserUtils$.MODULE$.validate(proxyUser, validationCode = gatewayContext.getRequest().getQueryParams().get("validationCode")[0])) {
            String lowerCaseUserName = proxyUser.toString().toLowerCase(Locale.getDefault());
            GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext, lowerCaseUserName);
            return package$.MODULE$.ok("\u4ee3\u7406\u6210\u529f").data("proxyUser", (Object)proxyUser);
        }
        return Message$.MODULE$.error("Validation failed");
    }

    public void ssoLogin(GatewayContext gatewayContext) {
        Message message = Message$.MODULE$.ok("succeed");
        gatewayContext.getResponse().write(Message$.MODULE$.response(message));
        gatewayContext.getResponse().setStatus(Message$.MODULE$.messageToHttpStatus(message));
        gatewayContext.getResponse().sendResponse();
    }

    public Message login(GatewayContext gatewayContext) {
        Message message;
        block0: {
            message = this.tryLogin(gatewayContext);
            message.data("sessionTimeOut", (Object)BoxesRunTime.boxToLong((long)SSOUtils$.MODULE$.getSessionTimeOut())).data("enableWatermark", GatewayConfiguration$.MODULE$.ENABLE_WATER_MARK().getValue());
            if (this.securityHooks() == null) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.securityHooks())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.postLogin(gatewayContext);
                return BoxedUnit.UNIT;
            });
        }
        return message;
    }

    public Message register(GatewayContext gatewayContext) {
        Message message = this.tryRegister(gatewayContext);
        return message;
    }

    public abstract Message tryLogin(GatewayContext var1);

    public Message logout(GatewayContext gatewayContext) {
        block1: {
            GatewaySSOUtils$.MODULE$.removeLoginUser(gatewayContext);
            if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_SSO_LOGIN().getValue())) {
                SSOInterceptor$.MODULE$.getSSOInterceptor().logout(gatewayContext);
            }
            if (this.securityHooks() == null) break block1;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.securityHooks())).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.preLogout(gatewayContext);
                return BoxedUnit.UNIT;
            });
        }
        return package$.MODULE$.ok("Logout successful(\u9000\u51fa\u767b\u5f55\u6210\u529f)\uff01");
    }

    public Message userInfo(GatewayContext gatewayContext) {
        return package$.MODULE$.ok("get user information succeed!").data("userName", (Object)GatewaySSOUtils$.MODULE$.getLoginUsername(gatewayContext));
    }

    public Message baseinfo(GatewayContext gatewayContext) {
        return Message$.MODULE$.ok("get baseinfo success(\u83b7\u53d6\u6210\u529f)\uff01").data("resultSetExportEnable", GatewayConfiguration$.MODULE$.IS_DOWNLOAD().getValue()).data("linkisClusterName", GatewayConfiguration$.MODULE$.LINKIS_CLUSTER_NAME().getValue()).data("engineLogOnlyAdminEnable", GatewayConfiguration$.MODULE$.ENGINE_LOG_ONLY_ADMIN().getValue());
    }

    public Message publicKey(GatewayContext gatewayContext) {
        BoxedUnit boxedUnit;
        Message message = Message$.MODULE$.ok("Gain success(\u83b7\u53d6\u6210\u529f)\uff01").data("enableSSL", (Object)BoxesRunTime.boxToBoolean((boolean)SSOUtils$.MODULE$.sslEnable()));
        if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.LOGIN_ENCRYPT_ENABLE().getValue())) {
            this.logger().info(new StringBuilder(20).append("DEBUG: privateKey : ").append(RSAUtils$.MODULE$.getDefaultPrivateKey()).toString());
            long timeStamp = System.currentTimeMillis();
            this.logger().info(new StringBuilder(12).append("DEBUG: time ").append(timeStamp).toString());
            message.data("debugTime", (Object)BoxesRunTime.boxToLong((long)timeStamp));
            boxedUnit = message.data("publicKey", (Object)RSAUtils$.MODULE$.getDefaultPublicKey());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        message.data("enableLoginEncrypt", GatewayConfiguration$.MODULE$.LOGIN_ENCRYPT_ENABLE().getValue());
        return message;
    }

    public Message heartbeat(GatewayContext gatewayContext) {
        return (Message)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            GatewaySSOUtils$.MODULE$.getLoginUsername(gatewayContext);
            Message retMessage = Message$.MODULE$.ok("Maintain heartbeat success(\u7ef4\u7cfb\u5fc3\u8df3\u6210\u529f)");
            retMessage.setStatus(0);
            return retMessage;
        }, (Function1 & Serializable & scala.Serializable)t -> Message$.MODULE$.noLogin(t.getMessage()));
    }

    public abstract Message tryRegister(GatewayContext var1);

    /*
     * WARNING - void declaration
     */
    public AbstractUserRestful() {
        void var1_1;
        Logging.$init$((Logging)this);
        this.securityHooks = (SecurityHook[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(SecurityHook.class));
        this.dssProjectSender = Sender$.MODULE$.getSender((String)GatewayConfiguration$.MODULE$.DSS_QUERY_WORKSPACE_SERVICE_NAME().getValue());
        String userURI = (String)ServerConfiguration$.MODULE$.BDP_SERVER_USER_URI().getValue();
        if (!userURI.endsWith("/")) {
            userURI = new StringBuilder(1).append(userURI).append("/").toString();
        }
        this.userRegex = var1_1;
    }
}

