/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.persistence.persistence.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.util.Pair;
import org.apache.linkis.cs.common.entity.enumeration.ContextScope;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.common.entity.source.ContextValue;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.serialize.helper.ContextSerializationHelper;
import org.apache.linkis.cs.common.serialize.helper.SerializationHelper;
import org.apache.linkis.cs.persistence.conf.PersistenceConf;
import org.apache.linkis.cs.persistence.dao.ContextMapMapper;
import org.apache.linkis.cs.persistence.entity.ExtraFieldClass;
import org.apache.linkis.cs.persistence.entity.PersistenceContextKey;
import org.apache.linkis.cs.persistence.entity.PersistenceContextKeyValue;
import org.apache.linkis.cs.persistence.entity.PersistenceContextValue;
import org.apache.linkis.cs.persistence.persistence.ContextMapPersistence;
import org.apache.linkis.cs.persistence.util.PersistenceUtils;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextMapPersistenceImpl
implements ContextMapPersistence {
    @Autowired
    private ContextMapMapper contextMapMapper;
    private Class<PersistenceContextKey> pKClass = PersistenceContextKey.class;
    private Class<PersistenceContextValue> pVClass = PersistenceContextValue.class;
    private Class<PersistenceContextKeyValue> pKVClass = PersistenceContextKeyValue.class;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper json = BDPJettyServerHelper.jacksonJson();
    private final SerializationHelper serialHelper = ContextSerializationHelper.getInstance();

    @Override
    public void create(ContextID contextID, ContextKeyValue kV) throws CSErrorException {
        try {
            Pair<PersistenceContextKey, ExtraFieldClass> pK = PersistenceUtils.transfer(kV.getContextKey(), this.pKClass);
            Pair<PersistenceContextValue, ExtraFieldClass> pV = PersistenceUtils.transfer(kV.getContextValue(), this.pVClass);
            Pair<PersistenceContextKeyValue, ExtraFieldClass> pKV = PersistenceUtils.transfer(kV, this.pKVClass);
            ((PersistenceContextValue)pV.getFirst()).setValueStr(this.serialHelper.serialize(kV.getContextValue().getValue()));
            ((ExtraFieldClass)pKV.getSecond()).addSub((ExtraFieldClass)pK.getSecond());
            ((ExtraFieldClass)pKV.getSecond()).addSub((ExtraFieldClass)pV.getSecond());
            ((PersistenceContextKeyValue)pKV.getFirst()).setProps(this.json.writeValueAsString(pKV.getSecond()));
            ((PersistenceContextKeyValue)pKV.getFirst()).setContextId(contextID.getContextId());
            ((PersistenceContextKeyValue)pKV.getFirst()).setContextKey((ContextKey)pK.getFirst());
            ((PersistenceContextKeyValue)pKV.getFirst()).setContextValue((ContextValue)pV.getFirst());
            Date now = new Date();
            ((PersistenceContextKeyValue)pKV.getFirst()).setCreateTime(now);
            ((PersistenceContextKeyValue)pKV.getFirst()).setUpdateTime(now);
            ((PersistenceContextKeyValue)pKV.getFirst()).setAccessTime(now);
            this.contextMapMapper.createMap((PersistenceContextKeyValue)pKV.getFirst());
        }
        catch (JsonProcessingException e) {
            this.logger.error("writeAsJson failed:", (Throwable)e);
            throw new CSErrorException(97000, e.getMessage());
        }
    }

    @Override
    public void update(ContextID contextID, ContextKeyValue kV) throws CSErrorException {
        Pair<PersistenceContextKey, ExtraFieldClass> pK = PersistenceUtils.transfer(kV.getContextKey(), this.pKClass);
        Pair<PersistenceContextValue, ExtraFieldClass> pV = PersistenceUtils.transfer(kV.getContextValue(), this.pVClass);
        Pair<PersistenceContextKeyValue, ExtraFieldClass> pKV = PersistenceUtils.transfer(kV, this.pKVClass);
        Object value = kV.getContextValue().getValue();
        if (value != null) {
            ((PersistenceContextValue)pV.getFirst()).setValueStr(this.serialHelper.serialize(value));
        }
        ((PersistenceContextKeyValue)pKV.getFirst()).setContextKey((ContextKey)pK.getFirst());
        ((PersistenceContextKeyValue)pKV.getFirst()).setContextValue((ContextValue)pV.getFirst());
        ((PersistenceContextKeyValue)pKV.getFirst()).setContextId(contextID.getContextId());
        if (null == ((PersistenceContextKeyValue)pKV.getFirst()).getAccessTime()) {
            ((PersistenceContextKeyValue)pKV.getFirst()).setUpdateTime(new Date());
        }
        this.contextMapMapper.updateMap((PersistenceContextKeyValue)pKV.getFirst());
    }

    @Override
    public ContextKeyValue get(ContextID contextID, ContextKey contextKey) throws CSErrorException {
        PersistenceContextKeyValue pKV = this.contextMapMapper.getContextMap(contextID, contextKey);
        if (pKV == null) {
            return null;
        }
        return this.transfer(pKV);
    }

    private ContextKeyValue transfer(PersistenceContextKeyValue pKV) throws CSErrorException {
        try {
            PersistenceContextKey pK = (PersistenceContextKey)pKV.getContextKey();
            PersistenceContextValue pV = (PersistenceContextValue)pKV.getContextValue();
            if (((Boolean)PersistenceConf.ENABLE_CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue()).booleanValue()) {
                if (StringUtils.isBlank((CharSequence)pKV.getProps()) || StringUtils.isBlank((CharSequence)((CharSequence)PersistenceConf.CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue()))) {
                    this.logger.error("Props : {} of ContextMap or CSID_REPLACE_PACKAGE_HEADER : {} cannot be empty.", (Object)pKV.getProps(), PersistenceConf.CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue());
                } else if (pKV.getProps().contains((CharSequence)PersistenceConf.CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Will replace package header of source : {} from : {} to : {}", new Object[]{pKV.getProps(), PersistenceConf.CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue(), "org.apache.linkis"});
                    }
                    pKV.setProps(pKV.getProps().replaceAll((String)PersistenceConf.CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue(), "org.apache.linkis"));
                }
            }
            ExtraFieldClass extraFieldClass = (ExtraFieldClass)this.json.readValue(pKV.getProps(), ExtraFieldClass.class);
            ContextKey key = (ContextKey)PersistenceUtils.transfer(extraFieldClass.getOneSub(0), pK);
            ContextValue value = (ContextValue)PersistenceUtils.transfer(extraFieldClass.getOneSub(1), pV);
            if (value != null) {
                value.setValue(this.serialHelper.deserialize(pV.getValueStr()));
            }
            ContextKeyValue kv = (ContextKeyValue)PersistenceUtils.transfer(extraFieldClass, pKV);
            kv.setContextKey(key);
            kv.setContextValue(value);
            return kv;
        }
        catch (IOException e) {
            this.logger.error("readJson failed:", (Throwable)e);
            throw new CSErrorException(97000, e.getMessage());
        }
    }

    @Override
    public List<ContextKeyValue> getAll(ContextID contextID, String key) {
        List<PersistenceContextKeyValue> pKVs = this.contextMapMapper.getAllContextMapByKey(contextID, key);
        return pKVs.stream().map(PersistenceUtils.map(this::transfer)).collect(Collectors.toList());
    }

    @Override
    public List<ContextKeyValue> getAll(ContextID contextID) {
        List<PersistenceContextKeyValue> pKVs = this.contextMapMapper.getAllContextMapByContextID(contextID);
        return pKVs.stream().map(PersistenceUtils.map(this::transfer)).collect(Collectors.toList());
    }

    @Override
    public List<ContextKeyValue> getAll(ContextID contextID, ContextScope contextScope) {
        List<PersistenceContextKeyValue> pKVs = this.contextMapMapper.getAllContextMapByScope(contextID, contextScope);
        return pKVs.stream().map(PersistenceUtils.map(this::transfer)).collect(Collectors.toList());
    }

    @Override
    public List<ContextKeyValue> getAll(ContextID contextID, ContextType contextType) {
        List<PersistenceContextKeyValue> pKVs = this.contextMapMapper.getAllContextMapByType(contextID, contextType);
        return pKVs.stream().map(PersistenceUtils.map(this::transfer)).collect(Collectors.toList());
    }

    @Override
    public void reset(ContextID contextID, ContextKey contextKey) {
    }

    @Override
    public void remove(ContextID contextID, ContextKey contextKey) {
        this.contextMapMapper.removeContextMap(contextID, contextKey);
    }

    @Override
    public void removeAll(ContextID contextID) {
        this.contextMapMapper.removeAllContextMapByContextID(contextID);
    }

    @Override
    public void removeAll(ContextID contextID, ContextType contextType) {
        this.contextMapMapper.removeAllContextMapByType(contextID, contextType);
    }

    @Override
    public void removeAll(ContextID contextID, ContextScope contextScope) {
        this.contextMapMapper.removeAllContextMapByScope(contextID, contextScope);
    }

    @Override
    public void removeByKeyPrefix(ContextID contextID, String keyPrefix) {
        this.contextMapMapper.removeByKeyPrefix(contextID, keyPrefix);
    }

    @Override
    public void removeByKeyPrefix(ContextID contextID, ContextType contextType, String keyPrefix) {
        this.contextMapMapper.removeByKeyPrefixAndContextType(contextID, contextType, keyPrefix);
    }

    @Override
    public void removeByKey(ContextID contextID, ContextType contextType, String keyStr) {
        this.contextMapMapper.removeByKeyAndContextType(contextID, contextType, keyStr);
    }

    @Override
    public List<ContextKeyValue> searchContextIDByTime(Date createTimeStart, Date createTimeEnd, Date updateTimeStart, Date updateTimeEnd, Date accessTimeStart, Date accessTimeEnd) {
        List<PersistenceContextKeyValue> result = this.contextMapMapper.getAllContextMapByTime(createTimeStart, createTimeEnd, updateTimeStart, updateTimeEnd, accessTimeStart, accessTimeEnd);
        ArrayList<ContextKeyValue> rsList = new ArrayList<ContextKeyValue>();
        if (null != result) {
            for (PersistenceContextKeyValue pKV : result) {
                rsList.add(pKV);
            }
        }
        return rsList;
    }
}

