/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.contextcache.cache.csid.impl;

import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.linkis.common.exception.FatalException;
import org.apache.linkis.common.listener.EventListener;
import org.apache.linkis.cs.common.entity.listener.ContextIDListenerDomain;
import org.apache.linkis.cs.common.entity.listener.ContextKeyListenerDomain;
import org.apache.linkis.cs.common.entity.listener.ListenerDomain;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.contextcache.cache.csid.ContextIDValue;
import org.apache.linkis.cs.contextcache.cache.csid.ContextIDValueGenerator;
import org.apache.linkis.cs.contextcache.cache.csid.impl.ContextIDValueImpl;
import org.apache.linkis.cs.contextcache.cache.cskey.ContextKeyValueContext;
import org.apache.linkis.cs.listener.ListenerBus.ContextAsyncListenerBus;
import org.apache.linkis.cs.listener.callback.imp.DefaultContextIDCallbackEngine;
import org.apache.linkis.cs.listener.callback.imp.DefaultContextKeyCallbackEngine;
import org.apache.linkis.cs.listener.manager.imp.DefaultContextListenerManager;
import org.apache.linkis.cs.persistence.ContextPersistenceManager;
import org.apache.linkis.cs.persistence.persistence.ContextIDListenerPersistence;
import org.apache.linkis.cs.persistence.persistence.ContextKeyListenerPersistence;
import org.apache.linkis.cs.persistence.persistence.ContextMapPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Lookup;
import org.springframework.stereotype.Component;

@Component
public abstract class ContextIDValueGeneratorImpl
implements ContextIDValueGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ContextIDValueGeneratorImpl.class);
    private ContextAsyncListenerBus listenerBus = DefaultContextListenerManager.getInstance().getContextAsyncListenerBus();
    @Autowired
    private ContextPersistenceManager contextPersistenceManager;
    private ContextMapPersistence contextMapPersistence;
    private ContextIDListenerPersistence contextIDListenerPersistence;
    private ContextKeyListenerPersistence contextKeyListenerPersistence;
    private DefaultContextIDCallbackEngine contextIDCallbackEngine;
    private DefaultContextKeyCallbackEngine contextKeyCallbackEngine;

    @Lookup
    protected abstract ContextKeyValueContext getContextKeyValueContext();

    @PostConstruct
    void init() throws FatalException {
        try {
            this.contextIDCallbackEngine = DefaultContextListenerManager.getInstance().getContextIDCallbackEngine();
            this.contextKeyCallbackEngine = DefaultContextListenerManager.getInstance().getContextKeyCallbackEngine();
            this.contextMapPersistence = this.contextPersistenceManager.getContextMapPersistence();
            this.contextIDListenerPersistence = this.contextPersistenceManager.getContextIDListenerPersistence();
            this.contextKeyListenerPersistence = this.contextPersistenceManager.getContextKeyListenerPersistence();
        }
        catch (Exception e) {
            throw new FatalException(97001, "Failed to get proxy of contextMapPersistence");
        }
    }

    @Override
    public ContextIDValue createContextIDValue(ContextID contextID) throws CSErrorException {
        logger.info("Start to createContextIDValue of ContextID({}) ", (Object)contextID.getContextId());
        if (this.contextMapPersistence == null) {
            throw new CSErrorException(97001, "Failed to get proxy of contextMapPersistence");
        }
        List<ContextKeyValue> contextKeyValueList = this.contextMapPersistence.getAll(contextID);
        ContextKeyValueContext contextKeyValueContext = this.getContextKeyValueContext();
        contextKeyValueContext.setContextID(contextID);
        contextKeyValueContext.putAll(contextKeyValueList);
        try {
            logger.info("For contextID({}) register contextKeyListener", (Object)contextID.getContextId());
            List<ContextKeyListenerDomain> contextKeyListenerPersistenceAll = this.contextKeyListenerPersistence.getAll(contextID);
            if (CollectionUtils.isNotEmpty(contextKeyListenerPersistenceAll)) {
                for (ContextKeyListenerDomain contextKeyListenerDomain : contextKeyListenerPersistenceAll) {
                    this.contextKeyCallbackEngine.registerClient((ListenerDomain)contextKeyListenerDomain);
                }
            }
            logger.info("For contextID({}) register contextIDListener", (Object)contextID.getContextId());
            List<ContextIDListenerDomain> contextIDListenerPersistenceAll = this.contextIDListenerPersistence.getAll(contextID);
            if (CollectionUtils.isNotEmpty(contextIDListenerPersistenceAll)) {
                for (ContextIDListenerDomain contextIDListenerDomain : contextIDListenerPersistenceAll) {
                    this.contextIDCallbackEngine.registerClient((ListenerDomain)contextIDListenerDomain);
                }
            }
        }
        catch (Throwable e) {
            logger.error("Failed to register listener: ", e);
        }
        logger.info("Finished to createContextIDValue of ContextID({}) ", (Object)contextID.getContextId());
        ContextIDValueImpl contextIDValue = new ContextIDValueImpl(contextID.getContextId(), contextKeyValueContext);
        this.listenerBus.addListener((EventListener)contextIDValue);
        return contextIDValue;
    }
}

