/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.config;

import de.codecentric.boot.admin.server.config.AdminServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class SpringBootAdminServerEnabledCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata annotatedTypeMetadata) {
        AdminServerProperties serverProperties = this.getClientProperties(context);
        if (!serverProperties.getServer().isEnabled()) {
            return ConditionOutcome.noMatch((String)"Spring Boot Server is disabled, because 'spring.boot.admin.server.enabled' is false.");
        }
        return ConditionOutcome.match();
    }

    private AdminServerProperties getClientProperties(ConditionContext context) {
        AdminServerProperties serverProperties = new AdminServerProperties();
        Binder.get((Environment)context.getEnvironment()).bind("spring.boot.admin", Bindable.ofInstance((Object)serverProperties));
        return serverProperties;
    }
}

