/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.interceptor.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.exception.LinkisCommonErrorException;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.CodeAndRunTypeUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.entrance.conf.EntranceConfiguration$;
import org.apache.linkis.governance.common.entity.TemplateConfKey;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.governance.common.protocol.conf.TemplateConfRequest;
import org.apache.linkis.governance.common.protocol.conf.TemplateConfResponse;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.entrance.ExecuteOnceLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.protocol.utils.TaskUtils$;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

public final class TemplateConfUtils$
implements Logging {
    public static TemplateConfUtils$ MODULE$;
    private final String confTemplateNameKey;
    private final LoadingCache<String, List<TemplateConfKey>> templateCache;
    private final LoadingCache<String, List<TemplateConfKey>> templateCacheName;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new TemplateConfUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        TemplateConfUtils$ templateConfUtils$ = this;
        synchronized (templateConfUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String confTemplateNameKey() {
        return this.confTemplateNameKey;
    }

    private LoadingCache<String, List<TemplateConfKey>> templateCache() {
        return this.templateCache;
    }

    private LoadingCache<String, List<TemplateConfKey>> templateCacheName() {
        return this.templateCacheName;
    }

    public String getCustomTemplateConfName(String code, String codeType) {
        String templateConfName;
        block9: {
            String string;
            String str;
            UnanchoredRegex errRegex;
            block10: {
                String[] res;
                block11: {
                    String languageType;
                    templateConfName = "";
                    String varString = null;
                    String errString = null;
                    Object rightVarString = null;
                    String string2 = languageType = CodeAndRunTypeUtils$.MODULE$.getLanguageTypeByCodeType(codeType, CodeAndRunTypeUtils$.MODULE$.getLanguageTypeByCodeType$default$2());
                    String string3 = CodeAndRunTypeUtils$.MODULE$.LANGUAGE_TYPE_SQL();
                    String string4 = string2;
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        varString = new StringBuilder(20).append("\\s*---@set ").append(this.confTemplateNameKey()).append("=\\s*.+\\s*").toString();
                        errString = "\\s*---@.*";
                    } else {
                        boolean bl;
                        String string5 = CodeAndRunTypeUtils$.MODULE$.LANGUAGE_TYPE_PYTHON();
                        String string6 = string2;
                        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                            bl = true;
                        } else {
                            String string7 = CodeAndRunTypeUtils$.MODULE$.LANGUAGE_TYPE_SHELL();
                            String string8 = string2;
                            bl = !(string7 != null ? !string7.equals(string8) : string8 != null);
                        }
                        if (bl) {
                            varString = new StringBuilder(19).append("\\s*##@set ").append(this.confTemplateNameKey()).append("=\\s*.+\\s*").toString();
                            errString = "\\s*##@";
                        } else {
                            String string9 = CodeAndRunTypeUtils$.MODULE$.LANGUAGE_TYPE_SCALA();
                            String string10 = string2;
                            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                                varString = new StringBuilder(20).append("\\s*///@set ").append(this.confTemplateNameKey()).append("=\\s*.+\\s*").toString();
                                errString = "\\s*///@.+";
                            } else {
                                return templateConfName;
                            }
                        }
                    }
                    UnanchoredRegex customRegex = new StringOps(Predef$.MODULE$.augmentString(varString)).r().unanchored();
                    errRegex = new StringOps(Predef$.MODULE$.augmentString(errString)).r().unanchored();
                    String codeRes = code.replaceAll("\r\n", "\n");
                    String[] res2 = codeRes.split("\n");
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res2)).size() <= 0) break block9;
                    str = res2[0];
                    string = str;
                    Option option = ((Regex)customRegex).unapplySeq((CharSequence)string);
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(0) != 0) break block10;
                    String clearStr = str.endsWith(";") ? str.substring(0, str.length() - 1) : str;
                    res = clearStr.split("=");
                    if (res == null || res.length != 2) break block11;
                    templateConfName = res[1].trim();
                    this.logger().info(new StringBuilder(23).append("get template conf name ").append(templateConfName).toString());
                    break block9;
                }
                if (res.length > 2) {
                    throw new LinkisCommonErrorException(20044, new StringBuilder(43).append(str).append(" template conf name var defined uncorrectly").toString());
                }
                throw new LinkisCommonErrorException(20045, new StringBuilder(48).append("template conf name var  was defined uncorrectly:").append(str).toString());
            }
            Option option = ((Regex)errRegex).unapplySeq((CharSequence)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(0) != 0) break block9;
            this.logger().warn(new StringBuilder(162).append("The template conf name var definition is incorrect:").append(str).append(",if it is not used, it will not run the error, but it is recommended to use the correct specification to define").toString());
        }
        return templateConfName;
    }

    public JobRequest dealWithTemplateConf(JobRequest jobRequest, StringBuilder logAppender) {
        block12: {
            Object object;
            JobRequest jobRequest2 = jobRequest;
            if (jobRequest2 == null) break block12;
            JobRequest jobRequest3 = jobRequest2;
            Map params = jobRequest3.getParams();
            Map startMap = TaskUtils$.MODULE$.getStartupMap(params);
            List templateConflist = new ArrayList();
            String templateName = "";
            Tuple2 tuple2 = LabelUtil$.MODULE$.getUserCreator(jobRequest.getLabels());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            String creator = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)creator);
            String user2 = (String)tuple22._1();
            String creator2 = (String)tuple22._2();
            if (((String)EntranceConfiguration$.MODULE$.DEFAULT_REQUEST_APPLICATION_NAME().getValue()).equals(creator2)) {
                String codeType = LabelUtil$.MODULE$.getCodeType(jobRequest.getLabels());
                templateName = this.getCustomTemplateConfName(jobRequest.getExecutionCode(), codeType);
            }
            if (StringUtils.isBlank((CharSequence)templateName)) {
                this.logger().debug("jobRequest startMap param template name is empty");
                this.logger().info("jobRequest startMap params :{} ", new Object[]{startMap});
                String templateUuid = startMap.getOrDefault("ec.conf.templateId", "").toString();
                if (StringUtils.isBlank((CharSequence)templateUuid)) {
                    this.logger().debug("jobRequest startMap param template id is empty");
                    object = BoxedUnit.UNIT;
                } else {
                    this.logger().info("try to get template conf list with template uid:{} ", new Object[]{templateUuid});
                    logAppender.append(LogUtils$.MODULE$.generateInfo(new StringBuilder(50).append("Try to get template conf data with template uid:").append(templateUuid).append("\nn").toString()));
                    templateConflist = (List)this.templateCache().get((Object)templateUuid);
                    object = templateConflist == null || templateConflist.size() == 0 ? logAppender.append(LogUtils$.MODULE$.generateWarn(new StringBuilder(54).append("Can not get any template conf data with template uid:").append(templateUuid).append("\n").toString())) : BoxedUnit.UNIT;
                }
            } else {
                this.logger().info("Try to get template conf list with template name:[{}]", new Object[]{templateName});
                logAppender.append(LogUtils$.MODULE$.generateInfo(new StringBuilder(52).append("Try to get template conf data with template name:[").append(templateName).append("]\n").toString()));
                templateConflist = (List)this.templateCacheName().get((Object)templateName);
                if (templateConflist == null || templateConflist.size() == 0) {
                    object = logAppender.append(LogUtils$.MODULE$.generateWarn(new StringBuilder(55).append("Can not get any template conf data with template name:").append(templateName).append("\n").toString()));
                } else {
                    TaskUtils$.MODULE$.clearStartupMap(params);
                    if (BoxesRunTime.unboxToBoolean((Object)EntranceConfiguration$.MODULE$.TEMPLATE_CONF_ADD_ONCE_LABEL_ENABLE().getValue())) {
                        ExecuteOnceLabel onceLabel = (ExecuteOnceLabel)LabelBuilderFactoryContext.getLabelBuilderFactory().createLabel(ExecuteOnceLabel.class);
                        this.logger().info("Add once label for task id:{}", new Object[]{jobRequest3.getId().toString()});
                        object = BoxesRunTime.boxToBoolean((boolean)jobRequest3.getLabels().add(onceLabel));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                }
            }
            if (templateConflist != null && templateConflist.size() > 0) {
                HashMap keyList = new HashMap();
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(templateConflist).asScala()).foreach((Function1 & Serializable & scala.Serializable)ele -> {
                    String key = ele.getKey();
                    Object oldValue = startMap.get(key);
                    if (oldValue != null && StringUtils.isNotBlank((CharSequence)oldValue.toString())) {
                        MODULE$.logger().info(new StringBuilder(35).append("key:").append(key).append(" value:").append(oldValue).append(" not empty, skip to deal").toString());
                        return BoxedUnit.UNIT;
                    }
                    String newValue = ele.getConfigValue();
                    MODULE$.logger().info(new StringBuilder(39).append("key:").append(key).append(" value:").append(newValue).append(" will add to startMap params").toString());
                    Object object = TaskUtils$.MODULE$.isWithDebugInfo(params) ? logAppender.append(LogUtils$.MODULE$.generateInfo(new StringBuilder(6).append("add ").append(key).append("=").append(newValue).append("\n").toString())) : BoxedUnit.UNIT;
                    return keyList.put(key, newValue);
                });
                if (keyList.size() > 0) {
                    TaskUtils$.MODULE$.addStartupMap(params, keyList);
                }
            }
        }
        return jobRequest;
    }

    private TemplateConfUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.confTemplateNameKey = "ec.resource.name";
        this.templateCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<TemplateConfKey>>(){

            public List<TemplateConfKey> load(String templateUuid) {
                List templateList;
                block0: {
                    templateList = (List)Utils$.MODULE$.tryAndWarn((Function0 & Serializable & scala.Serializable)() -> {
                        List list;
                        Sender sender = Sender$.MODULE$.getSender((String)Configuration$.MODULE$.CLOUD_CONSOLE_CONFIGURATION_SPRING_APPLICATION_NAME().getValue());
                        TemplateConfUtils$.MODULE$.logger().info(new StringBuilder(46).append("load template configuration data templateUuid:").append(templateUuid).toString());
                        Object object = sender.ask((Object)new TemplateConfRequest(templateUuid));
                        if (object instanceof TemplateConfResponse) {
                            TemplateConfResponse templateConfResponse = (TemplateConfResponse)object;
                            TemplateConfUtils$.MODULE$.logger().debug(String.valueOf(templateConfResponse.getList()));
                            list = templateConfResponse.getList();
                        } else {
                            TemplateConfUtils$.MODULE$.logger().warn(new StringBuilder(61).append("load template configuration data templateUuid:").append(templateUuid).append(" loading failed").toString());
                            list = new ArrayList<E>(0);
                        }
                        List res = list;
                        return res;
                    }, TemplateConfUtils$.MODULE$.logger());
                    if (templateList.size() != 0) break block0;
                    TemplateConfUtils$.MODULE$.logger().warn("template configuration data loading failed, plaese check warn log");
                }
                return templateList;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$load$1(java.lang.String )}, serializedLambda);
            }
        });
        this.templateCacheName = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<TemplateConfKey>>(){

            public List<TemplateConfKey> load(String templateName) {
                List templateList;
                block0: {
                    templateList = (List)Utils$.MODULE$.tryAndWarn((Function0 & Serializable & scala.Serializable)() -> {
                        List list;
                        Sender sender = Sender$.MODULE$.getSender((String)Configuration$.MODULE$.CLOUD_CONSOLE_CONFIGURATION_SPRING_APPLICATION_NAME().getValue());
                        TemplateConfUtils$.MODULE$.logger().info(new StringBuilder(46).append("load template configuration data templateName:").append(templateName).toString());
                        Object object = sender.ask((Object)new TemplateConfRequest(null, templateName));
                        if (object instanceof TemplateConfResponse) {
                            TemplateConfResponse templateConfResponse = (TemplateConfResponse)object;
                            TemplateConfUtils$.MODULE$.logger().debug(String.valueOf(templateConfResponse.getList()));
                            list = templateConfResponse.getList();
                        } else {
                            TemplateConfUtils$.MODULE$.logger().warn(new StringBuilder(61).append("load template configuration data templateName:").append(templateName).append(" loading failed").toString());
                            list = new ArrayList<E>(0);
                        }
                        List res = list;
                        return res;
                    }, TemplateConfUtils$.MODULE$.logger());
                    if (templateList.size() != 0) break block0;
                    TemplateConfUtils$.MODULE$.logger().warn("template configuration data loading failed, plaese check warn log");
                }
                return templateList;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$load$2(java.lang.String )}, serializedLambda);
            }
        });
    }
}

